/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.AbstractInputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFilePropertyAnnotationHandler
extends AbstractInputPropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputFile.class;
    }

    @Override
    protected void validate(String propertyName, Object value, Collection<String> messages) {
        File fileValue = (File)value;
        if (!fileValue.exists()) {
            messages.add(String.format("File '%s' specified for property '%s' does not exist.", fileValue, propertyName));
        } else if (!fileValue.isFile()) {
            messages.add(String.format("File '%s' specified for property '%s' is not a file.", fileValue, propertyName));
        }
    }

    @Override
    protected TaskInputFilePropertyBuilder createPropertyBuilder(TaskPropertyActionContext context, TaskInternal task, Callable<Object> futureValue) {
        return task.getInputs().files(futureValue);
    }
}

