/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRMethod
extends AbstractIRMethod {
    protected final MethodHandle variable;
    protected final MethodHandle specific;
    protected final int specificArity;
    private final boolean hasExplicitCallProtocol;
    private final boolean hasKwargs;

    public CompiledIRMethod(MethodHandle variable, IRScope method, Visibility visibility, RubyModule implementationClass, boolean hasKwargs) {
        this(variable, null, -1, method, visibility, implementationClass, hasKwargs);
    }

    public CompiledIRMethod(MethodHandle variable, MethodHandle specific, int specificArity, IRScope method, Visibility visibility, RubyModule implementationClass, boolean hasKwargs) {
        super(method, visibility, implementationClass);
        this.variable = variable;
        this.specific = specific;
        this.specificArity = hasKwargs ? -1 : specificArity;
        this.method.getStaticScope().determineModule();
        this.hasExplicitCallProtocol = method.hasExplicitCallProtocol();
        this.hasKwargs = hasKwargs;
        this.setHandle(variable);
    }

    public MethodHandle getHandleFor(int arity2) {
        if (this.specificArity != -1 && arity2 == this.specificArity) {
            return this.specific;
        }
        return null;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ((IRMethod)this.method).getArgumentDescriptors();
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (this.method instanceof IRMethod) {
            return ((IRMethod)this.method).lazilyAcquireInterpreterContext();
        }
        InterpreterContext ic = this.method.getInterpreterContext();
        return ic;
    }

    protected void post(ThreadContext context) {
        context.postMethodFrameAndScope();
    }

    protected void pre(ThreadContext context, StaticScope staticScope, RubyModule implementationClass, IRubyObject self2, String name2, Block block) {
        context.preMethodFrameAndScope(implementationClass, name2, self2, block, staticScope);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (!this.hasExplicitCallProtocol) {
            return this.callNoProtocol(context, self2, name2, args2, block);
        }
        if (this.hasKwargs) {
            args2 = IRRuntimeHelpers.frobnicateKwargsArgument(context, args2, this.getSignature().required());
        }
        return CompiledIRMethod.invokeExact(this.variable, context, this.staticScope, self2, args2, block, this.implementationClass, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        if (!this.hasExplicitCallProtocol) {
            return this.callNoProtocol(context, self2, clazz, name2, block);
        }
        return CompiledIRMethod.invokeExact(this.specific, context, this.staticScope, self2, block, this.implementationClass, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (!this.hasExplicitCallProtocol) {
            return this.callNoProtocol(context, self2, clazz, name2, arg0, block);
        }
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, block);
        }
        return CompiledIRMethod.invokeExact(this.specific, context, this.staticScope, self2, arg0, block, this.implementationClass, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (!this.hasExplicitCallProtocol) {
            return this.callNoProtocol(context, self2, clazz, name2, arg0, arg1, block);
        }
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }
        return CompiledIRMethod.invokeExact(this.specific, context, this.staticScope, self2, arg0, arg1, block, this.implementationClass, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (!this.hasExplicitCallProtocol) {
            return this.callNoProtocol(context, self2, clazz, name2, arg0, arg1, arg2, block);
        }
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        return CompiledIRMethod.invokeExact(this.specific, context, this.staticScope, self2, arg0, arg1, arg2, block, this.implementationClass, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject callNoProtocol(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        StaticScope staticScope = this.staticScope;
        RubyModule implementationClass = this.implementationClass;
        this.pre(context, staticScope, implementationClass, self2, name2, block);
        if (this.hasKwargs) {
            args2 = IRRuntimeHelpers.frobnicateKwargsArgument(context, args2, this.getSignature().required());
        }
        try {
            IRubyObject iRubyObject = CompiledIRMethod.invokeExact(this.variable, context, staticScope, self2, args2, block, implementationClass, name2);
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject callNoProtocol(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        StaticScope staticScope = this.staticScope;
        RubyModule implementationClass = this.implementationClass;
        this.pre(context, staticScope, implementationClass, self2, name2, block);
        try {
            IRubyObject iRubyObject = CompiledIRMethod.invokeExact(this.specific, context, staticScope, self2, block, implementationClass, name2);
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject callNoProtocol(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, Helpers.arrayOf(arg0), block);
        }
        StaticScope staticScope = this.staticScope;
        RubyModule implementationClass = this.implementationClass;
        this.pre(context, staticScope, implementationClass, self2, name2, block);
        try {
            IRubyObject iRubyObject = CompiledIRMethod.invokeExact(this.specific, context, staticScope, self2, arg0, block, implementationClass, name2);
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject callNoProtocol(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, Helpers.arrayOf(arg0, arg1), block);
        }
        StaticScope staticScope = this.staticScope;
        RubyModule implementationClass = this.implementationClass;
        this.pre(context, staticScope, implementationClass, self2, name2, block);
        try {
            IRubyObject iRubyObject = CompiledIRMethod.invokeExact(this.specific, context, staticScope, self2, arg0, arg1, block, implementationClass, name2);
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject callNoProtocol(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, Helpers.arrayOf(arg0, arg1, arg2), block);
        }
        StaticScope staticScope = this.staticScope;
        RubyModule implementationClass = this.implementationClass;
        this.pre(context, staticScope, implementationClass, self2, name2, block);
        try {
            IRubyObject iRubyObject = CompiledIRMethod.invokeExact(this.specific, context, staticScope, self2, arg0, arg1, arg2, block, implementationClass, name2);
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    @Override
    public String getFile() {
        return this.method.getFileName();
    }

    @Override
    public int getLine() {
        return this.method.getLineNumber();
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + ' ' + this.method + ' ' + this.getSignature();
    }

    private static IRubyObject invokeExact(MethodHandle method, ThreadContext context, StaticScope staticScope, IRubyObject self2, IRubyObject[] args2, Block block, RubyModule implementationClass, String name2) {
        try {
            return method.invokeExact(context, staticScope, self2, args2, block, implementationClass, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    private static IRubyObject invokeExact(MethodHandle method, ThreadContext context, StaticScope staticScope, IRubyObject self2, Block block, RubyModule implementationClass, String name2) {
        try {
            return method.invokeExact(context, staticScope, self2, block, implementationClass, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    private static IRubyObject invokeExact(MethodHandle method, ThreadContext context, StaticScope staticScope, IRubyObject self2, IRubyObject arg0, Block block, RubyModule implementationClass, String name2) {
        try {
            return method.invokeExact(context, staticScope, self2, arg0, block, implementationClass, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    private static IRubyObject invokeExact(MethodHandle method, ThreadContext context, StaticScope staticScope, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block, RubyModule implementationClass, String name2) {
        try {
            return method.invokeExact(context, staticScope, self2, arg0, arg1, block, implementationClass, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    private static IRubyObject invokeExact(MethodHandle method, ThreadContext context, StaticScope staticScope, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block, RubyModule implementationClass, String name2) {
        try {
            return method.invokeExact(context, staticScope, self2, arg0, arg1, arg2, block, implementationClass, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }
}

