#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: foundation
version: 0.0.3
id: foundation-0.0.3-7IvqLXsFLES2KlG7AuZpxo
key: foundation-0.0.3-7IvqLXsFLES2KlG7AuZpxo
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: vincent@snarc.org
stability: experimental
homepage: https://github.com/haskell-foundation/foundation
synopsis: Alternative prelude with batteries and no dependencies
description:
    A custom prelude with no dependencies apart from base.
    .
    This package has the following goals:
    .
    * provide a base like sets of modules that provide a consistent set of features and bugfixes across multiple versions of GHC (unlike base).
    .
    * provide a better and more efficient prelude than base'\''s prelude.
    .
    * be self-sufficient: no external dependencies apart from base.
    .
    * provide better data-types: packed unicode string by default, arrays.
    .
    * Better numerical classes that better represent mathematical thing (No more all-in-one Num).
    .
    * Better I/O system with less Lazy IO
    .
    * Usual partial functions distinguished through type system
category: foundation
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Foundation Foundation.Numerical Foundation.Array
    Foundation.Array.Internal Foundation.Bits
    Foundation.Class.Bifunctor Foundation.Class.Storable
    Foundation.Convertible Foundation.String Foundation.String.ASCII
    Foundation.IO Foundation.IO.FileMap Foundation.VFS
    Foundation.VFS.Path Foundation.VFS.FilePath Foundation.VFS.URI
    Foundation.Math.Trigonometry Foundation.Hashing Foundation.Foreign
    Foundation.Collection Foundation.Primitive Foundation.Monad
    Foundation.Monad.Reader Foundation.Monad.State
    Foundation.System.Info Foundation.Strict Foundation.Parser
    Foundation.Random Foundation.System.Entropy Foundation.Tuple.Nth
hidden-modules: Foundation.String.Internal Foundation.String.UTF8
                Foundation.String.Encoding.Encoding
                Foundation.String.Encoding.UTF16 Foundation.String.Encoding.UTF32
                Foundation.String.Encoding.ASCII7
                Foundation.String.Encoding.ISO_8859_1 Foundation.String.UTF8Table
                Foundation.String.ModifiedUTF8 Foundation.Tuple
                Foundation.Hashing.FNV Foundation.Hashing.SipHash
                Foundation.Hashing.Hasher Foundation.Hashing.Hashable
                Foundation.Collection.Buildable Foundation.Collection.List
                Foundation.Collection.Element Foundation.Collection.InnerFunctor
                Foundation.Collection.Collection Foundation.Collection.Sequential
                Foundation.Collection.Keyed Foundation.Collection.Indexed
                Foundation.Collection.Foldable Foundation.Collection.Mutable
                Foundation.Collection.Zippable Foundation.Internal.Base
                Foundation.Internal.CallStack Foundation.Internal.Environment
                Foundation.Internal.Primitive Foundation.Internal.IsList
                Foundation.Internal.Identity Foundation.Internal.Proxy
                Foundation.Internal.Types Foundation.Internal.PrimTypes
                Foundation.Internal.MonadTrans Foundation.Internal.Natural
                Foundation.Internal.NumLiteral Foundation.Numerical.Primitives
                Foundation.Numerical.Number Foundation.Numerical.Additive
                Foundation.Numerical.Subtractive
                Foundation.Numerical.Multiplicative Foundation.Numerical.Floating
                Foundation.IO.File Foundation.IO.Terminal
                Foundation.Primitive.Types Foundation.Primitive.Monad
                Foundation.Primitive.Utils Foundation.Primitive.FinalPtr
                Foundation.Monad.MonadIO Foundation.Monad.Exception
                Foundation.Monad.Transformer Foundation.Monad.Identity
                Foundation.Monad.Base Foundation.Array.Chunked.Unboxed
                Foundation.Array.Common Foundation.Array.Unboxed
                Foundation.Array.Unboxed.Mutable Foundation.Array.Unboxed.ByteArray
                Foundation.Array.Boxed Foundation.Array.Bitmap
                Foundation.Foreign.MemoryMap Foundation.Foreign.MemoryMap.Types
                Foundation.Partial Foundation.System.Entropy.Common
                Foundation.Foreign.MemoryMap.Posix Foundation.System.Entropy.Unix
abi: 1a4d25774964f24c76505dbae0080948
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/foundation-0.0.3
library-dirs: /usr/lib/ghc-8.0.1/site-local/foundation-0.0.3
data-dir: /usr/share/arm-linux-ghc-8.0.1/foundation-0.0.3
hs-libraries: HSfoundation-0.0.3-7IvqLXsFLES2KlG7AuZpxo
depends:
    base-4.9.0.0 ghc-prim-0.5.0.0
haddock-interfaces: /usr/share/doc/haskell-foundation/html/foundation.haddock
haddock-html: /usr/share/doc/haskell-foundation/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
