/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.view;

import ch.ehi.basics.i18n.ResourceBundle;
import java.io.File;
import java.io.FileFilter;

public class GenericFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private static java.util.ResourceBundle resources = ResourceBundle.getBundle(GenericFileFilter.class);
    private String description;
    private String extension;

    public GenericFileFilter(String string, String string2) {
        this.description = string;
        this.extension = string2;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = GenericFileFilter.getFileExtension(file);
        if (string != null) {
            return string.equalsIgnoreCase(this.extension);
        }
        return false;
    }

    public static GenericFileFilter createCsvFilter() {
        return new GenericFileFilter(resources.getString("CICsvFilter"), "csv");
    }

    public static GenericFileFilter createXlsFilter() {
        return new GenericFileFilter("MS Excel", "xls");
    }

    public static GenericFileFilter createHtmlFilter() {
        return new GenericFileFilter(resources.getString("CIHtmlFilter"), "html");
    }

    public static GenericFileFilter createSqlFilter() {
        return new GenericFileFilter(resources.getString("CISqlFilter"), "sql");
    }

    public static GenericFileFilter createXmlFilter() {
        return new GenericFileFilter(resources.getString("CIXmlFilter"), "xml");
    }

    public static GenericFileFilter createXmlSchemaFilter() {
        return new GenericFileFilter(resources.getString("CIXsdFilter"), "xsd");
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtension() {
        return this.extension;
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return GenericFileFilter.getFileExtension(string);
    }

    public static String getFileExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length()) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String stripFileExtension(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length()) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String stripFileExtension(File file) {
        String string = file.getName();
        return GenericFileFilter.stripFileExtension(string);
    }
}

