/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.keys.StringKey;

public class TIFFTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE;
    public static final TranscodingHints.Key KEY_COMPRESSION_METHOD = new StringKey();

    public TIFFTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    @Override
    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    private WriteAdapter getWriteAdapter(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            WriteAdapter writeAdapter = (WriteAdapter)clazz.newInstance();
            return writeAdapter;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        Object object;
        boolean bl = false;
        if (this.hints.containsKey(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            bl = (Boolean)this.hints.get(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (bl) {
            object = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            this.forceTransparentWhite(bufferedImage, (SinglePixelPackedSampleModel)object);
        }
        if ((object = this.getWriteAdapter("org.apache.batik.ext.awt.image.codec.tiff.TIFFTranscoderInternalCodecWriteAdapter")) == null) {
            object = this.getWriteAdapter("org.apache.batik.transcoder.image.TIFFTranscoderImageIOWriteAdapter");
        }
        if (object == null) {
            throw new TranscoderException("Could not write TIFF file because no WriteAdapter is availble");
        }
        object.writeImage(this, bufferedImage, transcoderOutput);
    }

    public static interface WriteAdapter {
        public void writeImage(TIFFTranscoder var1, BufferedImage var2, TranscoderOutput var3) throws TranscoderException;
    }
}

