/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.TruffleRuntimeAccess;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;

public class Truffle {
    private static final TruffleRuntime RUNTIME = Truffle.initRuntime();

    @Deprecated
    public Truffle() {
    }

    public static TruffleRuntime getRuntime() {
        return RUNTIME;
    }

    private static TruffleRuntime initRuntime() {
        return AccessController.doPrivileged(new PrivilegedAction<TruffleRuntime>(){

            @Override
            public TruffleRuntime run() {
                boolean jdk8OrEarlier;
                String runtimeClassName = System.getProperty("truffle.TruffleRuntime");
                if (runtimeClassName != null) {
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Class<?> runtimeClass = Class.forName(runtimeClassName, false, cl);
                        return (TruffleRuntime)runtimeClass.newInstance();
                    }
                    catch (Throwable e) {
                        throw (InternalError)new InternalError().initCause(e);
                    }
                }
                TruffleRuntimeAccess access = null;
                Class<?> servicesClass = null;
                boolean bl = jdk8OrEarlier = System.getProperty("java.specification.version").compareTo("1.9") < 0;
                if (!jdk8OrEarlier) {
                    Iterator<TruffleRuntimeAccess> providers = ServiceLoader.load(TruffleRuntimeAccess.class).iterator();
                    if (providers.hasNext()) {
                        access = providers.next();
                        if (providers.hasNext()) {
                            throw new InternalError(String.format("Multiple %s providers found", TruffleRuntimeAccess.class.getName()));
                        }
                    }
                } else {
                    try {
                        servicesClass = Class.forName("jdk.vm.ci.services.Services");
                    }
                    catch (ClassNotFoundException providers) {
                        // empty catch block
                    }
                    if (servicesClass == null) {
                        try {
                            servicesClass = Class.forName("jdk.vm.ci.service.Services");
                        }
                        catch (ClassNotFoundException providers) {
                            // empty catch block
                        }
                    }
                    if (servicesClass == null) {
                        try {
                            servicesClass = Class.forName("jdk.internal.jvmci.service.Services");
                        }
                        catch (ClassNotFoundException providers) {
                            // empty catch block
                        }
                    }
                    if (servicesClass == null) {
                        try {
                            servicesClass = Class.forName("com.oracle.jvmci.service.Services");
                        }
                        catch (ClassNotFoundException providers) {
                            // empty catch block
                        }
                    }
                    if (servicesClass != null) {
                        try {
                            Method m = servicesClass.getDeclaredMethod("loadSingle", Class.class, Boolean.TYPE);
                            access = (TruffleRuntimeAccess)m.invoke(null, TruffleRuntimeAccess.class, false);
                        }
                        catch (Throwable e) {
                            throw (InternalError)new InternalError().initCause(e);
                        }
                    }
                }
                if (access != null) {
                    return access.getRuntime();
                }
                return new DefaultTruffleRuntime();
            }
        });
    }
}

