/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.lexer;

import java.nio.channels.Channel;
import org.jcodings.Encoding;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public abstract class LexerSource {
    private final String name;
    private int lineOffset;
    protected RubyArray scriptLines;

    public LexerSource(String sourceName, int lineOffset, RubyArray scriptLines) {
        this.name = sourceName;
        this.lineOffset = lineOffset;
        this.scriptLines = scriptLines;
    }

    public String getFilename() {
        return this.name;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void encodeExistingScriptLines(Encoding encoding) {
        if (this.scriptLines == null) {
            return;
        }
        int length = this.scriptLines.getLength();
        for (int i = 0; i < length; ++i) {
            RubyString line = (RubyString)this.scriptLines.eltOk(0L);
            line.setEncoding(encoding);
        }
    }

    public abstract Encoding getEncoding();

    public abstract void setEncoding(Encoding var1);

    public abstract ByteList gets();

    public abstract int getOffset();

    public abstract Channel getRemainingAsChannel();

    public abstract IRubyObject getRemainingAsIO();
}

