# -*- coding: utf-8 -*-

# Copyright (c) 2016 - 2017 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to select QtHelp documentation sets to be
installed.
"""

from __future__ import unicode_literals

import os

from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QDialog, QTreeWidgetItem

from .Ui_QtHelpDocumentationSelectionDialog import \
    Ui_QtHelpDocumentationSelectionDialog


class QtHelpDocumentationSelectionDialog(
        QDialog, Ui_QtHelpDocumentationSelectionDialog):
    """
    Class implementing a dialog to select QtHelp documentation sets to be
    installed.
    """
    def __init__(self, helpDocuments, parent=None):
        """
        Constructor
        
        @param helpDocuments dictionary containing the lists of help documents
            to be shown
        @type dict of lists of str
        @param parent reference to the parent widget
        @type QWidget
        """
        super(QtHelpDocumentationSelectionDialog, self).__init__(parent)
        self.setupUi(self)
        
        for category in helpDocuments:
            parentItem = QTreeWidgetItem(self.documentationList, [category])
            for document in helpDocuments[category]:
                item = QTreeWidgetItem(parentItem,
                                       [os.path.basename(document)])
                item.setData(0, Qt.UserRole, document)
        self.documentationList.sortItems(0, Qt.AscendingOrder)
    
    def getData(self):
        """
        Public method to retrieve the selected help documents.
        
        @return list of QtHelp documentation sets to be installed
        @rtype list of str
        """
        documents = []
        for item in self.documentationList.selectedItems():
            fileName = item.data(0, Qt.UserRole)
            if fileName:
                documents.append(fileName)
        return documents
