/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.AntBuilder;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.compile.AntDepend;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Factory;
import org.gradle.language.base.internal.tasks.StaleClassCleaner;

public class AntDependsStaleClassCleaner
extends StaleClassCleaner {
    private final Factory<AntBuilder> antBuilderFactory;
    private final CompileOptions compileOptions;
    private File dependencyCacheDir;

    public AntDependsStaleClassCleaner(Factory<AntBuilder> antBuilderFactory, CompileOptions compileOptions) {
        this.antBuilderFactory = antBuilderFactory;
        this.compileOptions = compileOptions;
    }

    public void setDependencyCacheDir(File dependencyCacheDir) {
        this.dependencyCacheDir = dependencyCacheDir;
    }

    public void execute() {
        ImmutableMap.Builder options = ImmutableMap.builder();
        options.put((Object)"destDir", (Object)this.getDestinationDir());
        options.putAll(this.compileOptions.getDependOptions().optionMap());
        if (this.compileOptions.getDependOptions().isUseCache()) {
            options.put((Object)"cache", (Object)this.dependencyCacheDir);
        }
        final AntBuilder ant = (AntBuilder)this.antBuilderFactory.create();
        ant.getProject().addTaskDefinition("gradleDepend", AntDepend.class);
        ant.invokeMethod("gradleDepend", (Object)new Object[]{options.build(), new Closure<Object>((Object)this, (Object)this){

            public void doCall(Object ignore) {
                AntDependsStaleClassCleaner.this.getSource().addToAntBuilder((Object)ant, "src", FileCollection.AntType.MatchingTask);
            }
        }});
    }
}

