/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifacts;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentArtifactsResolveResult;

public class ResolvedArtifactsGraphVisitor
implements DependencyGraphVisitor {
    private final IdGenerator<Long> idGenerator = new LongIdGenerator();
    private final Map<Long, ArtifactSet> artifactSetsByConfiguration = Maps.newHashMap();
    private final Map<ComponentArtifactIdentifier, ResolvedArtifact> allResolvedArtifacts = Maps.newHashMap();
    private final ArtifactResolver artifactResolver;
    private final DependencyArtifactsVisitor artifactResults;

    public ResolvedArtifactsGraphVisitor(DependencyArtifactsVisitor artifactsBuilder, ArtifactResolver artifactResolver) {
        this.artifactResults = artifactsBuilder;
        this.artifactResolver = artifactResolver;
    }

    @Override
    public void start(DependencyGraphNode root) {
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
    }

    @Override
    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
        for (DependencyGraphEdge dependencyGraphEdge : resolvedConfiguration.getIncomingEdges()) {
            DependencyGraphNode parent = dependencyGraphEdge.getFrom();
            ArtifactSet artifacts = this.getArtifacts(dependencyGraphEdge, resolvedConfiguration);
            this.artifactResults.visitArtifacts(parent, resolvedConfiguration, artifacts);
        }
    }

    @Override
    public void finish(DependencyGraphNode root) {
        this.artifactResults.finishArtifacts();
        this.allResolvedArtifacts.clear();
        this.artifactSetsByConfiguration.clear();
    }

    private ArtifactSet getArtifacts(DependencyGraphEdge dependency, DependencyGraphNode toConfiguration) {
        long id = (Long)this.idGenerator.generateId();
        ConfigurationMetadata configuration = toConfiguration.getMetadata();
        ComponentResolveMetadata component = toConfiguration.getOwner().getMetadata();
        Set<ComponentArtifactMetadata> artifacts = dependency.getArtifacts(configuration);
        if (!artifacts.isEmpty()) {
            ImmutableSet variants = ImmutableSet.of((Object)new DefaultVariantMetadata(AttributeContainerInternal.EMPTY, artifacts));
            return new DefaultArtifactSet(component.getId(), component.getSource(), ModuleExclusions.excludeNone(), (Set<? extends VariantMetadata>)variants, this.artifactResolver, this.allResolvedArtifacts, id);
        }
        ArtifactSet configurationArtifactSet = this.artifactSetsByConfiguration.get(toConfiguration.getNodeId());
        if (configurationArtifactSet == null) {
            Set<? extends VariantMetadata> variants = this.doResolve(component, configuration);
            configurationArtifactSet = new DefaultArtifactSet(component.getId(), component.getSource(), dependency.getExclusions(), variants, this.artifactResolver, this.allResolvedArtifacts, id);
            if (!dependency.getExclusions().mayExcludeArtifacts()) {
                this.artifactSetsByConfiguration.put(toConfiguration.getNodeId(), configurationArtifactSet);
            }
        }
        return configurationArtifactSet;
    }

    private Set<? extends VariantMetadata> doResolve(ComponentResolveMetadata component, ConfigurationMetadata configuration) {
        DefaultBuildableComponentArtifactsResolveResult result = new DefaultBuildableComponentArtifactsResolveResult();
        this.artifactResolver.resolveArtifacts(component, result);
        return ((ComponentArtifacts)result.getResult()).getVariantsFor(configuration);
    }
}

