/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.Closeable;
import org.gradle.api.internal.changedetection.state.InMemoryTaskArtifactCache;
import org.gradle.api.internal.changedetection.state.TaskHistoryStore;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskHistoryStore
implements TaskHistoryStore,
Closeable {
    private final InMemoryTaskArtifactCache inMemoryTaskArtifactCache;
    private final PersistentCache cache;

    public DefaultTaskHistoryStore(Gradle gradle, CacheRepository cacheRepository, InMemoryTaskArtifactCache inMemoryTaskArtifactCache) {
        this.inMemoryTaskArtifactCache = inMemoryTaskArtifactCache;
        this.cache = cacheRepository.cache(gradle, "taskArtifacts").withDisplayName("task history cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Class<K> keyType, Serializer<V> valueSerializer) {
        PersistentIndexedCacheParameters<K, V> parameters = new PersistentIndexedCacheParameters<K, V>(cacheName, keyType, valueSerializer).cacheDecorator(this.inMemoryTaskArtifactCache);
        return this.cache.createCache(parameters);
    }

    @Override
    public void flush() {
        this.cache.flush();
    }
}

