/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFileTree
extends CompositeFileCollection
implements FileTreeInternal {
    protected Collection<? extends FileTreeInternal> getSourceCollections() {
        return (Collection)Cast.uncheckedCast(super.getSourceCollections());
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, (FileTreeInternal)Cast.cast(FileTreeInternal.class, (Object)fileTree));
    }

    @Override
    public FileTree matching(Closure filterConfigClosure) {
        return this.matching((Action<? super PatternFilterable>)ClosureBackedAction.of((Closure)filterConfigClosure));
    }

    @Override
    public FileTree matching(Action<? super PatternFilterable> filterConfigAction) {
        return new FilteredFileTree(filterConfigAction);
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        return new FilteredFileTree(patterns);
    }

    @Override
    public FileTree visit(Closure visitor) {
        return this.visit((Action<? super FileVisitDetails>)ClosureBackedAction.of((Closure)visitor));
    }

    @Override
    public FileTree visit(Action<? super FileVisitDetails> visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTree visit(FileVisitor visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredFileTree
    extends CompositeFileTree {
        private final Action<? super PatternFilterable> action;
        private final PatternFilterable patterns;

        public FilteredFileTree(PatternFilterable patterns) {
            this.patterns = patterns;
            this.action = null;
        }

        public FilteredFileTree(Action<? super PatternFilterable> action) {
            this.action = action;
            this.patterns = null;
        }

        @Override
        public String getDisplayName() {
            return CompositeFileTree.this.getDisplayName();
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            ResolvableFileCollectionResolveContext nestedContext = context.newContext();
            CompositeFileTree.this.visitContents(nestedContext);
            for (FileTree fileTree : nestedContext.resolveAsFileTrees()) {
                if (this.action != null) {
                    context.add(fileTree.matching(this.action));
                    continue;
                }
                context.add(fileTree.matching(this.patterns));
            }
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            CompositeFileTree.this.visitDependencies(context);
        }
    }
}

