/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import com.fasterxml.jackson.core.io.CharTypes;

public final class JsonUtils {
    private static final char[] HC = CharTypes.copyHexChars();
    private static final ThreadLocal<char[]> _qbufLocal = new ThreadLocal();

    private static char[] getQBuf() {
        char[] _qbuf = _qbufLocal.get();
        if (_qbuf == null) {
            _qbuf = new char[6];
            _qbuf[0] = 92;
            _qbuf[2] = 48;
            _qbuf[3] = 48;
            _qbufLocal.set(_qbuf);
        }
        return _qbuf;
    }

    public static void quoteAsString(CharSequence input, StringBuilder output) {
        char[] qbuf = JsonUtils.getQBuf();
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        int inputLen = input.length();
        block0: while (inPtr < inputLen) {
            char c;
            while ((c = input.charAt(inPtr)) >= escCodeCount || escCodes[c] == 0) {
                output.append(c);
                if (++inPtr < inputLen) continue;
                break block0;
            }
            char d = input.charAt(inPtr++);
            int escCode = escCodes[d];
            int length = escCode < 0 ? JsonUtils._appendNumeric(d, qbuf) : JsonUtils._appendNamed(escCode, qbuf);
            output.append(qbuf, 0, length);
        }
    }

    private static int _appendNumeric(int value, char[] qbuf) {
        qbuf[1] = 117;
        qbuf[4] = HC[value >> 4];
        qbuf[5] = HC[value & 0xF];
        return 6;
    }

    private static int _appendNamed(int esc, char[] qbuf) {
        qbuf[1] = (char)esc;
        return 2;
    }
}

