/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import com.fasterxml.jackson.dataformat.cbor.CBORConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.cbor.CborXContent;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.smile.SmileXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;

public class XContentFactory {
    private static int GUESS_HEADER_LENGTH = 20;

    public static XContentBuilder jsonBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.JSON);
    }

    public static XContentBuilder jsonBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(JsonXContent.jsonXContent, os);
    }

    public static XContentBuilder smileBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.SMILE);
    }

    public static XContentBuilder smileBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(SmileXContent.smileXContent, os);
    }

    public static XContentBuilder yamlBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.YAML);
    }

    public static XContentBuilder yamlBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(YamlXContent.yamlXContent, os);
    }

    public static XContentBuilder cborBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.CBOR);
    }

    public static XContentBuilder cborBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(CborXContent.cborXContent, os);
    }

    public static XContentBuilder contentBuilder(XContentType type, OutputStream outputStream) throws IOException {
        if (type == XContentType.JSON) {
            return XContentFactory.jsonBuilder(outputStream);
        }
        if (type == XContentType.SMILE) {
            return XContentFactory.smileBuilder(outputStream);
        }
        if (type == XContentType.YAML) {
            return XContentFactory.yamlBuilder(outputStream);
        }
        if (type == XContentType.CBOR) {
            return XContentFactory.cborBuilder(outputStream);
        }
        throw new IllegalArgumentException("No matching content type for " + type);
    }

    public static XContentBuilder contentBuilder(XContentType type) throws IOException {
        if (type == XContentType.JSON) {
            return JsonXContent.contentBuilder();
        }
        if (type == XContentType.SMILE) {
            return SmileXContent.contentBuilder();
        }
        if (type == XContentType.YAML) {
            return YamlXContent.contentBuilder();
        }
        if (type == XContentType.CBOR) {
            return CborXContent.contentBuilder();
        }
        throw new IllegalArgumentException("No matching content type for " + type);
    }

    public static XContent xContent(XContentType type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot get xcontent for unknown type");
        }
        return type.xContent();
    }

    public static XContentType xContentType(CharSequence content) {
        int length;
        int n = length = content.length() < GUESS_HEADER_LENGTH ? content.length() : GUESS_HEADER_LENGTH;
        if (length == 0) {
            return null;
        }
        char first = content.charAt(0);
        if (first == '{') {
            return XContentType.JSON;
        }
        if (length > 2 && first == ':' && content.charAt(1) == ')' && content.charAt(2) == '\n') {
            return XContentType.SMILE;
        }
        if (length > 2 && first == '-' && content.charAt(1) == '-' && content.charAt(2) == '-') {
            return XContentType.YAML;
        }
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c == '{') {
                return XContentType.JSON;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return null;
    }

    public static XContent xContent(CharSequence content) {
        XContentType type = XContentFactory.xContentType(content);
        if (type == null) {
            throw new ElasticsearchParseException("Failed to derive xcontent", new Object[0]);
        }
        return XContentFactory.xContent(type);
    }

    public static XContent xContent(byte[] data) {
        return XContentFactory.xContent(data, 0, data.length);
    }

    public static XContent xContent(byte[] data, int offset, int length) {
        XContentType type = XContentFactory.xContentType(data, offset, length);
        if (type == null) {
            throw new ElasticsearchParseException("Failed to derive xcontent", new Object[0]);
        }
        return XContentFactory.xContent(type);
    }

    public static XContentType xContentType(byte[] data) {
        return XContentFactory.xContentType(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XContentType xContentType(InputStream si) throws IOException {
        if (!si.markSupported()) {
            throw new IllegalArgumentException("Cannot guess the xcontent type without mark/reset support on " + si.getClass());
        }
        si.mark(GUESS_HEADER_LENGTH);
        try {
            byte[] firstBytes = new byte[GUESS_HEADER_LENGTH];
            int read = Streams.readFully(si, firstBytes);
            XContentType xContentType = XContentFactory.xContentType(new BytesArray(firstBytes, 0, read));
            return xContentType;
        }
        finally {
            si.reset();
        }
    }

    public static XContentType xContentType(byte[] data, int offset, int length) {
        return XContentFactory.xContentType(new BytesArray(data, offset, length));
    }

    public static XContent xContent(BytesReference bytes) {
        XContentType type = XContentFactory.xContentType(bytes);
        if (type == null) {
            throw new ElasticsearchParseException("Failed to derive xcontent", new Object[0]);
        }
        return XContentFactory.xContent(type);
    }

    public static XContentType xContentType(BytesReference bytes) {
        int length = bytes.length();
        if (length == 0) {
            return null;
        }
        byte first = bytes.get(0);
        if (first == 123) {
            return XContentType.JSON;
        }
        if (length > 2 && first == 58 && bytes.get(1) == 41 && bytes.get(2) == 10) {
            return XContentType.SMILE;
        }
        if (length > 2 && first == 45 && bytes.get(1) == 45 && bytes.get(2) == 45) {
            return XContentType.YAML;
        }
        if (first == -65 && length > 1) {
            return XContentType.CBOR;
        }
        if (CBORConstants.hasMajorType((int)6, (byte)first) && length > 2 && first == -39 && bytes.get(1) == -39 && bytes.get(2) == -9) {
            return XContentType.CBOR;
        }
        if (CBORConstants.hasMajorType((int)5, (byte)first)) {
            return XContentType.CBOR;
        }
        int jsonStart = 0;
        if (length > 3 && first == -17 && bytes.get(1) == -69 && bytes.get(2) == -65) {
            jsonStart = 3;
        }
        for (int i = jsonStart; i < length; ++i) {
            byte b = bytes.get(i);
            if (b == 123) {
                return XContentType.JSON;
            }
            if (!Character.isWhitespace(b)) break;
        }
        return null;
    }
}

