/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.builder;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchExtParser;
import org.elasticsearch.search.SearchExtRegistry;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.rescore.RescoreBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.Suggesters;

public final class SearchSourceBuilder
extends ToXContentToBytes
implements Writeable {
    public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
    public static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
    public static final ParseField TIMEOUT_FIELD = new ParseField("timeout", new String[0]);
    public static final ParseField TERMINATE_AFTER_FIELD = new ParseField("terminate_after", new String[0]);
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField POST_FILTER_FIELD = new ParseField("post_filter", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    public static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    public static final ParseField EXPLAIN_FIELD = new ParseField("explain", new String[0]);
    public static final ParseField _SOURCE_FIELD = new ParseField("_source", new String[0]);
    public static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    public static final ParseField STORED_FIELDS_FIELD = new ParseField("stored_fields", new String[0]);
    public static final ParseField DOCVALUE_FIELDS_FIELD = new ParseField("docvalue_fields", "fielddata_fields");
    public static final ParseField SCRIPT_FIELDS_FIELD = new ParseField("script_fields", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField IGNORE_FAILURE_FIELD = new ParseField("ignore_failure", new String[0]);
    public static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
    public static final ParseField TRACK_SCORES_FIELD = new ParseField("track_scores", new String[0]);
    public static final ParseField INDICES_BOOST_FIELD = new ParseField("indices_boost", new String[0]);
    public static final ParseField AGGREGATIONS_FIELD = new ParseField("aggregations", new String[0]);
    public static final ParseField AGGS_FIELD = new ParseField("aggs", new String[0]);
    public static final ParseField HIGHLIGHT_FIELD = new ParseField("highlight", new String[0]);
    public static final ParseField SUGGEST_FIELD = new ParseField("suggest", new String[0]);
    public static final ParseField RESCORE_FIELD = new ParseField("rescore", new String[0]);
    public static final ParseField STATS_FIELD = new ParseField("stats", new String[0]);
    public static final ParseField EXT_FIELD = new ParseField("ext", new String[0]);
    public static final ParseField PROFILE_FIELD = new ParseField("profile", new String[0]);
    public static final ParseField SEARCH_AFTER = new ParseField("search_after", new String[0]);
    public static final ParseField SLICE = new ParseField("slice", new String[0]);
    public static final ParseField ALL_FIELDS_FIELDS = new ParseField("all_fields", new String[0]);
    private QueryBuilder queryBuilder;
    private QueryBuilder postQueryBuilder;
    private int from = -1;
    private int size = -1;
    private Boolean explain;
    private Boolean version;
    private List<SortBuilder<?>> sorts;
    private boolean trackScores = false;
    private SearchAfterBuilder searchAfterBuilder;
    private SliceBuilder sliceBuilder;
    private Float minScore;
    private TimeValue timeout = null;
    private int terminateAfter = 0;
    private StoredFieldsContext storedFieldsContext;
    private List<String> docValueFields;
    private List<ScriptField> scriptFields;
    private FetchSourceContext fetchSourceContext;
    private AggregatorFactories.Builder aggregations;
    private HighlightBuilder highlightBuilder;
    private SuggestBuilder suggestBuilder;
    private List<RescoreBuilder> rescoreBuilders;
    private ObjectFloatHashMap<String> indexBoost = null;
    private List<String> stats;
    private List<SearchExtBuilder> extBuilders = Collections.emptyList();
    private boolean profile = false;

    public static SearchSourceBuilder fromXContent(QueryParseContext context, AggregatorParsers aggParsers, Suggesters suggesters, SearchExtRegistry searchExtRegistry) throws IOException {
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.parseXContent(context, aggParsers, suggesters, searchExtRegistry);
        return builder;
    }

    public static SearchSourceBuilder searchSource() {
        return new SearchSourceBuilder();
    }

    public static HighlightBuilder highlight() {
        return new HighlightBuilder();
    }

    public SearchSourceBuilder() {
    }

    public SearchSourceBuilder(StreamInput in) throws IOException {
        this.aggregations = in.readOptionalWriteable(AggregatorFactories.Builder::new);
        this.explain = in.readOptionalBoolean();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
        this.docValueFields = (List)in.readGenericValue();
        this.storedFieldsContext = in.readOptionalWriteable(StoredFieldsContext::new);
        this.from = in.readVInt();
        this.highlightBuilder = in.readOptionalWriteable(HighlightBuilder::new);
        int indexBoostSize = in.readVInt();
        if (indexBoostSize > 0) {
            this.indexBoost = new ObjectFloatHashMap(indexBoostSize);
            for (int i = 0; i < indexBoostSize; ++i) {
                this.indexBoost.put((Object)in.readString(), in.readFloat());
            }
        }
        this.minScore = in.readOptionalFloat();
        this.postQueryBuilder = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.queryBuilder = in.readOptionalNamedWriteable(QueryBuilder.class);
        if (in.readBoolean()) {
            this.rescoreBuilders = in.readNamedWriteableList(RescoreBuilder.class);
        }
        if (in.readBoolean()) {
            this.scriptFields = in.readList(ScriptField::new);
        }
        this.size = in.readVInt();
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.sorts = new ArrayList();
            for (int i = 0; i < size; ++i) {
                this.sorts.add(in.readNamedWriteable(SortBuilder.class));
            }
        }
        if (in.readBoolean()) {
            this.stats = in.readList(StreamInput::readString);
        }
        this.suggestBuilder = in.readOptionalWriteable(SuggestBuilder::new);
        this.terminateAfter = in.readVInt();
        this.timeout = in.readOptionalWriteable(TimeValue::new);
        this.trackScores = in.readBoolean();
        this.version = in.readOptionalBoolean();
        this.extBuilders = in.readNamedWriteableList(SearchExtBuilder.class);
        this.profile = in.readBoolean();
        this.searchAfterBuilder = in.readOptionalWriteable(SearchAfterBuilder::new);
        this.sliceBuilder = in.readOptionalWriteable(SliceBuilder::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.aggregations);
        out.writeOptionalBoolean(this.explain);
        out.writeOptionalWriteable(this.fetchSourceContext);
        out.writeGenericValue(this.docValueFields);
        out.writeOptionalWriteable(this.storedFieldsContext);
        out.writeVInt(this.from);
        out.writeOptionalWriteable(this.highlightBuilder);
        int indexBoostSize = this.indexBoost == null ? 0 : this.indexBoost.size();
        out.writeVInt(indexBoostSize);
        if (indexBoostSize > 0) {
            this.writeIndexBoost(out);
        }
        out.writeOptionalFloat(this.minScore);
        out.writeOptionalNamedWriteable(this.postQueryBuilder);
        out.writeOptionalNamedWriteable(this.queryBuilder);
        boolean hasRescoreBuilders = this.rescoreBuilders != null;
        out.writeBoolean(hasRescoreBuilders);
        if (hasRescoreBuilders) {
            out.writeNamedWriteableList(this.rescoreBuilders);
        }
        boolean hasScriptFields = this.scriptFields != null;
        out.writeBoolean(hasScriptFields);
        if (hasScriptFields) {
            out.writeList(this.scriptFields);
        }
        out.writeVInt(this.size);
        boolean hasSorts = this.sorts != null;
        out.writeBoolean(hasSorts);
        if (hasSorts) {
            out.writeVInt(this.sorts.size());
            for (SortBuilder<?> sort : this.sorts) {
                out.writeNamedWriteable(sort);
            }
        }
        boolean hasStats = this.stats != null;
        out.writeBoolean(hasStats);
        if (hasStats) {
            out.writeStringList(this.stats);
        }
        out.writeOptionalWriteable(this.suggestBuilder);
        out.writeVInt(this.terminateAfter);
        out.writeOptionalWriteable(this.timeout);
        out.writeBoolean(this.trackScores);
        out.writeOptionalBoolean(this.version);
        out.writeNamedWriteableList(this.extBuilders);
        out.writeBoolean(this.profile);
        out.writeOptionalWriteable(this.searchAfterBuilder);
        out.writeOptionalWriteable(this.sliceBuilder);
    }

    private void writeIndexBoost(StreamOutput out) throws IOException {
        List ibs = StreamSupport.stream(this.indexBoost.spliterator(), false).map(i -> Tuple.tuple(i.key, Float.valueOf(i.value))).sorted((o1, o2) -> ((String)o1.v1()).compareTo((String)o2.v1())).collect(Collectors.toList());
        for (Tuple ib : ibs) {
            out.writeString((String)ib.v1());
            out.writeFloat(((Float)ib.v2()).floatValue());
        }
    }

    public SearchSourceBuilder query(QueryBuilder query) {
        this.queryBuilder = query;
        return this;
    }

    public QueryBuilder query() {
        return this.queryBuilder;
    }

    public SearchSourceBuilder postFilter(QueryBuilder postFilter) {
        this.postQueryBuilder = postFilter;
        return this;
    }

    public QueryBuilder postFilter() {
        return this.postQueryBuilder;
    }

    public SearchSourceBuilder from(int from) {
        this.from = from;
        return this;
    }

    public int from() {
        return this.from;
    }

    public SearchSourceBuilder size(int size) {
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    public SearchSourceBuilder minScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public Float minScore() {
        return this.minScore;
    }

    public SearchSourceBuilder explain(Boolean explain) {
        this.explain = explain;
        return this;
    }

    public Boolean explain() {
        return this.explain;
    }

    public SearchSourceBuilder version(Boolean version) {
        this.version = version;
        return this;
    }

    public Boolean version() {
        return this.version;
    }

    public SearchSourceBuilder timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public SearchSourceBuilder terminateAfter(int terminateAfter) {
        if (terminateAfter < 0) {
            throw new IllegalArgumentException("terminateAfter must be > 0");
        }
        this.terminateAfter = terminateAfter;
        return this;
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public SearchSourceBuilder sort(String name, SortOrder order) {
        if (name.equals("_score")) {
            return this.sort((SortBuilder<?>)SortBuilders.scoreSort().order(order));
        }
        return this.sort((SortBuilder<?>)SortBuilders.fieldSort(name).order(order));
    }

    public SearchSourceBuilder sort(String name) {
        if (name.equals("_score")) {
            return this.sort(SortBuilders.scoreSort());
        }
        return this.sort(SortBuilders.fieldSort(name));
    }

    public SearchSourceBuilder sort(SortBuilder<?> sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }
        this.sorts.add(sort);
        return this;
    }

    public List<SortBuilder<?>> sorts() {
        return this.sorts;
    }

    public SearchSourceBuilder trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public Object[] searchAfter() {
        if (this.searchAfterBuilder == null) {
            return null;
        }
        return this.searchAfterBuilder.getSortValues();
    }

    public SearchSourceBuilder searchAfter(Object[] values) {
        this.searchAfterBuilder = new SearchAfterBuilder().setSortValues(values);
        return this;
    }

    public SearchSourceBuilder slice(SliceBuilder builder) {
        this.sliceBuilder = builder;
        return this;
    }

    public SliceBuilder slice() {
        return this.sliceBuilder;
    }

    public SearchSourceBuilder aggregation(AggregationBuilder aggregation) {
        if (this.aggregations == null) {
            this.aggregations = AggregatorFactories.builder();
        }
        this.aggregations.addAggregator(aggregation);
        return this;
    }

    public SearchSourceBuilder aggregation(PipelineAggregationBuilder aggregation) {
        if (this.aggregations == null) {
            this.aggregations = AggregatorFactories.builder();
        }
        this.aggregations.addPipelineAggregator(aggregation);
        return this;
    }

    public AggregatorFactories.Builder aggregations() {
        return this.aggregations;
    }

    public SearchSourceBuilder highlighter(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public HighlightBuilder highlighter() {
        return this.highlightBuilder;
    }

    public SearchSourceBuilder suggest(SuggestBuilder suggestBuilder) {
        this.suggestBuilder = suggestBuilder;
        return this;
    }

    public SuggestBuilder suggest() {
        return this.suggestBuilder;
    }

    public SearchSourceBuilder addRescorer(RescoreBuilder<?> rescoreBuilder) {
        if (this.rescoreBuilders == null) {
            this.rescoreBuilders = new ArrayList<RescoreBuilder>();
        }
        this.rescoreBuilders.add(rescoreBuilder);
        return this;
    }

    public SearchSourceBuilder clearRescorers() {
        this.rescoreBuilders = null;
        return this;
    }

    public SearchSourceBuilder profile(boolean profile) {
        this.profile = profile;
        return this;
    }

    public boolean profile() {
        return this.profile;
    }

    public List<RescoreBuilder> rescores() {
        return this.rescoreBuilders;
    }

    public SearchSourceBuilder fetchSource(boolean fetch) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = new FetchSourceContext(fetch, fetchSourceContext.includes(), fetchSourceContext.excludes());
        return this;
    }

    public SearchSourceBuilder fetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        return this.fetchSource(stringArray2, stringArray);
    }

    public SearchSourceBuilder fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = new FetchSourceContext(fetchSourceContext.fetchSource(), includes, excludes);
        return this;
    }

    public SearchSourceBuilder fetchSource(@Nullable FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    public FetchSourceContext fetchSource() {
        return this.fetchSourceContext;
    }

    public SearchSourceBuilder storedField(String name) {
        return this.storedFields(Collections.singletonList(name));
    }

    public SearchSourceBuilder storedFields(List<String> fields) {
        if (this.storedFieldsContext == null) {
            this.storedFieldsContext = StoredFieldsContext.fromList(fields);
        } else {
            this.storedFieldsContext.addFieldNames(fields);
        }
        return this;
    }

    public SearchSourceBuilder storedFields(StoredFieldsContext context) {
        this.storedFieldsContext = context;
        return this;
    }

    public StoredFieldsContext storedFields() {
        return this.storedFieldsContext;
    }

    @Deprecated
    public SearchSourceBuilder fieldDataField(String name) {
        if (this.docValueFields == null) {
            this.docValueFields = new ArrayList<String>();
        }
        this.docValueFields.add(name);
        return this;
    }

    @Deprecated
    public List<String> fieldDataFields() {
        return this.docValueFields;
    }

    public List<String> docValueFields() {
        return this.docValueFields;
    }

    public SearchSourceBuilder docValueField(String name) {
        if (this.docValueFields == null) {
            this.docValueFields = new ArrayList<String>();
        }
        this.docValueFields.add(name);
        return this;
    }

    public SearchSourceBuilder scriptField(String name, Script script) {
        this.scriptField(name, script, false);
        return this;
    }

    public SearchSourceBuilder scriptField(String name, Script script, boolean ignoreFailure) {
        if (this.scriptFields == null) {
            this.scriptFields = new ArrayList<ScriptField>();
        }
        this.scriptFields.add(new ScriptField(name, script, ignoreFailure));
        return this;
    }

    public List<ScriptField> scriptFields() {
        return this.scriptFields;
    }

    public SearchSourceBuilder indexBoost(String index, float indexBoost) {
        if (this.indexBoost == null) {
            this.indexBoost = new ObjectFloatHashMap();
        }
        this.indexBoost.put((Object)index, indexBoost);
        return this;
    }

    public ObjectFloatHashMap<String> indexBoost() {
        return this.indexBoost;
    }

    public SearchSourceBuilder stats(List<String> statsGroups) {
        this.stats = statsGroups;
        return this;
    }

    public List<String> stats() {
        return this.stats;
    }

    public SearchSourceBuilder ext(List<SearchExtBuilder> searchExtBuilders) {
        this.extBuilders = Objects.requireNonNull(searchExtBuilders, "searchExtBuilders must not be null");
        return this;
    }

    public List<SearchExtBuilder> ext() {
        return this.extBuilders;
    }

    public boolean isSuggestOnly() {
        return this.suggestBuilder != null && this.queryBuilder == null && this.aggregations == null;
    }

    public SearchSourceBuilder rewrite(QueryShardContext context) throws IOException {
        boolean rewritten;
        assert (this.equals(this.shallowCopy(this.queryBuilder, this.postQueryBuilder, this.sliceBuilder)));
        QueryBuilder queryBuilder = null;
        if (this.queryBuilder != null) {
            queryBuilder = this.queryBuilder.rewrite(context);
        }
        QueryBuilder postQueryBuilder = null;
        if (this.postQueryBuilder != null) {
            postQueryBuilder = this.postQueryBuilder.rewrite(context);
        }
        boolean bl = rewritten = queryBuilder != this.queryBuilder || postQueryBuilder != this.postQueryBuilder;
        if (rewritten) {
            return this.shallowCopy(queryBuilder, postQueryBuilder, this.sliceBuilder);
        }
        return this;
    }

    public SearchSourceBuilder copyWithNewSlice(SliceBuilder slice) {
        return this.shallowCopy(this.queryBuilder, this.postQueryBuilder, slice);
    }

    private SearchSourceBuilder shallowCopy(QueryBuilder queryBuilder, QueryBuilder postQueryBuilder, SliceBuilder slice) {
        SearchSourceBuilder rewrittenBuilder = new SearchSourceBuilder();
        rewrittenBuilder.aggregations = this.aggregations;
        rewrittenBuilder.explain = this.explain;
        rewrittenBuilder.extBuilders = this.extBuilders;
        rewrittenBuilder.fetchSourceContext = this.fetchSourceContext;
        rewrittenBuilder.docValueFields = this.docValueFields;
        rewrittenBuilder.storedFieldsContext = this.storedFieldsContext;
        rewrittenBuilder.from = this.from;
        rewrittenBuilder.highlightBuilder = this.highlightBuilder;
        rewrittenBuilder.indexBoost = this.indexBoost;
        rewrittenBuilder.minScore = this.minScore;
        rewrittenBuilder.postQueryBuilder = postQueryBuilder;
        rewrittenBuilder.profile = this.profile;
        rewrittenBuilder.queryBuilder = queryBuilder;
        rewrittenBuilder.rescoreBuilders = this.rescoreBuilders;
        rewrittenBuilder.scriptFields = this.scriptFields;
        rewrittenBuilder.searchAfterBuilder = this.searchAfterBuilder;
        rewrittenBuilder.sliceBuilder = slice;
        rewrittenBuilder.size = this.size;
        rewrittenBuilder.sorts = this.sorts;
        rewrittenBuilder.stats = this.stats;
        rewrittenBuilder.suggestBuilder = this.suggestBuilder;
        rewrittenBuilder.terminateAfter = this.terminateAfter;
        rewrittenBuilder.timeout = this.timeout;
        rewrittenBuilder.trackScores = this.trackScores;
        rewrittenBuilder.version = this.version;
        return rewrittenBuilder;
    }

    public void parseXContent(QueryParseContext context, AggregatorParsers aggParsers, Suggesters suggesters, SearchExtRegistry searchExtRegistry) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        if (token != XContentParser.Token.START_OBJECT && (token = parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "] but found [" + (Object)((Object)token) + "]", parser.getTokenLocation());
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (context.getParseFieldMatcher().match(currentFieldName, FROM_FIELD)) {
                    this.from = parser.intValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SIZE_FIELD)) {
                    this.size = parser.intValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, TIMEOUT_FIELD)) {
                    this.timeout = TimeValue.parseTimeValue(parser.text(), null, TIMEOUT_FIELD.getPreferredName());
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, TERMINATE_AFTER_FIELD)) {
                    this.terminateAfter = parser.intValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, MIN_SCORE_FIELD)) {
                    this.minScore = Float.valueOf(parser.floatValue());
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, VERSION_FIELD)) {
                    this.version = parser.booleanValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, EXPLAIN_FIELD)) {
                    this.explain = parser.booleanValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, TRACK_SCORES_FIELD)) {
                    this.trackScores = parser.booleanValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, _SOURCE_FIELD)) {
                    this.fetchSourceContext = FetchSourceContext.parse(context.parser());
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, STORED_FIELDS_FIELD)) {
                    this.storedFieldsContext = StoredFieldsContext.fromXContent(STORED_FIELDS_FIELD.getPreferredName(), context);
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SORT_FIELD)) {
                    this.sort(parser.text());
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, PROFILE_FIELD)) {
                    this.profile = parser.booleanValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, FIELDS_FIELD)) {
                    throw new ParsingException(parser.getTokenLocation(), "Deprecated field [" + FIELDS_FIELD + "] used, expected [" + STORED_FIELDS_FIELD + "] instead", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (context.getParseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    this.queryBuilder = context.parseInnerQueryBuilder().orElse(null);
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, POST_FILTER_FIELD)) {
                    this.postQueryBuilder = context.parseInnerQueryBuilder().orElse(null);
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, _SOURCE_FIELD)) {
                    this.fetchSourceContext = FetchSourceContext.parse(context.parser());
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SCRIPT_FIELDS_FIELD)) {
                    this.scriptFields = new ArrayList<ScriptField>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        this.scriptFields.add(new ScriptField(context));
                    }
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, INDICES_BOOST_FIELD)) {
                    this.indexBoost = new ObjectFloatHashMap();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            this.indexBoost.put((Object)currentFieldName, parser.floatValue());
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                    }
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, AGGREGATIONS_FIELD) || context.getParseFieldMatcher().match(currentFieldName, AGGS_FIELD)) {
                    this.aggregations = aggParsers.parseAggregators(context);
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, HIGHLIGHT_FIELD)) {
                    this.highlightBuilder = HighlightBuilder.fromXContent(context);
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SUGGEST_FIELD)) {
                    this.suggestBuilder = SuggestBuilder.fromXContent(context, suggesters);
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SORT_FIELD)) {
                    this.sorts = new ArrayList(SortBuilder.fromXContent(context));
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, RESCORE_FIELD)) {
                    this.rescoreBuilders = new ArrayList<RescoreBuilder>();
                    this.rescoreBuilders.add(RescoreBuilder.parseFromXContent(context));
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, EXT_FIELD)) {
                    this.extBuilders = new ArrayList<SearchExtBuilder>();
                    String extSectionName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            extSectionName = parser.currentName();
                            continue;
                        }
                        SearchExtParser searchExtParser = (SearchExtParser)searchExtRegistry.lookup(extSectionName, context.getParseFieldMatcher(), parser.getTokenLocation());
                        Object searchExtBuilder = searchExtParser.fromXContent(parser);
                        if (!searchExtBuilder.getWriteableName().equals(extSectionName)) {
                            throw new IllegalStateException("The parsed [" + searchExtBuilder.getClass().getName() + "] object has a different writeable name compared to the name of the section that it was parsed from: found [" + searchExtBuilder.getWriteableName() + "] expected [" + extSectionName + "]");
                        }
                        this.extBuilders.add((SearchExtBuilder)searchExtBuilder);
                    }
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SLICE)) {
                    this.sliceBuilder = SliceBuilder.fromXContent(context);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (context.getParseFieldMatcher().match(currentFieldName, STORED_FIELDS_FIELD)) {
                    this.storedFieldsContext = StoredFieldsContext.fromXContent(STORED_FIELDS_FIELD.getPreferredName(), context);
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, DOCVALUE_FIELDS_FIELD)) {
                    this.docValueFields = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            this.docValueFields.add(parser.text());
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.VALUE_STRING) + "] in [" + currentFieldName + "] but found [" + (Object)((Object)token) + "]", parser.getTokenLocation());
                    }
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SORT_FIELD)) {
                    this.sorts = new ArrayList(SortBuilder.fromXContent(context));
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, RESCORE_FIELD)) {
                    this.rescoreBuilders = new ArrayList<RescoreBuilder>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        this.rescoreBuilders.add(RescoreBuilder.parseFromXContent(context));
                    }
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, STATS_FIELD)) {
                    this.stats = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            this.stats.add(parser.text());
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.VALUE_STRING) + "] in [" + currentFieldName + "] but found [" + (Object)((Object)token) + "]", parser.getTokenLocation());
                    }
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, _SOURCE_FIELD)) {
                    this.fetchSourceContext = FetchSourceContext.parse(context.parser());
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, SEARCH_AFTER)) {
                    this.searchAfterBuilder = SearchAfterBuilder.fromXContent(parser, context.getParseFieldMatcher());
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, FIELDS_FIELD)) {
                    throw new ParsingException(parser.getTokenLocation(), "The field [" + FIELDS_FIELD + "] is no longer supported, please use [" + STORED_FIELDS_FIELD + "] to retrieve stored fields or _source filtering if the field is not stored", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.from != -1) {
            builder.field(FROM_FIELD.getPreferredName(), this.from);
        }
        if (this.size != -1) {
            builder.field(SIZE_FIELD.getPreferredName(), this.size);
        }
        if (this.timeout != null && !this.timeout.equals(TimeValue.MINUS_ONE)) {
            builder.field(TIMEOUT_FIELD.getPreferredName(), this.timeout.getStringRep());
        }
        if (this.terminateAfter != 0) {
            builder.field(TERMINATE_AFTER_FIELD.getPreferredName(), this.terminateAfter);
        }
        if (this.queryBuilder != null) {
            builder.field(QUERY_FIELD.getPreferredName(), this.queryBuilder);
        }
        if (this.postQueryBuilder != null) {
            builder.field(POST_FILTER_FIELD.getPreferredName(), this.postQueryBuilder);
        }
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
        if (this.version != null) {
            builder.field(VERSION_FIELD.getPreferredName(), this.version);
        }
        if (this.explain != null) {
            builder.field(EXPLAIN_FIELD.getPreferredName(), this.explain);
        }
        if (this.profile) {
            builder.field("profile", true);
        }
        if (this.fetchSourceContext != null) {
            builder.field(_SOURCE_FIELD.getPreferredName(), this.fetchSourceContext);
        }
        if (this.storedFieldsContext != null) {
            this.storedFieldsContext.toXContent(STORED_FIELDS_FIELD.getPreferredName(), builder);
        }
        if (this.docValueFields != null) {
            builder.startArray(DOCVALUE_FIELDS_FIELD.getPreferredName());
            for (String string : this.docValueFields) {
                builder.value(string);
            }
            builder.endArray();
        }
        if (this.scriptFields != null) {
            builder.startObject(SCRIPT_FIELDS_FIELD.getPreferredName());
            for (ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray(SORT_FIELD.getPreferredName());
            for (SortBuilder sortBuilder : this.sorts) {
                sortBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.trackScores) {
            builder.field(TRACK_SCORES_FIELD.getPreferredName(), true);
        }
        if (this.searchAfterBuilder != null) {
            builder.array(SEARCH_AFTER.getPreferredName(), this.searchAfterBuilder.getSortValues());
        }
        if (this.sliceBuilder != null) {
            builder.field(SLICE.getPreferredName(), this.sliceBuilder);
        }
        if (this.indexBoost != null) {
            builder.startObject(INDICES_BOOST_FIELD.getPreferredName());
            assert (!this.indexBoost.containsKey(null));
            Object[] keys = this.indexBoost.keys;
            float[] fArray = this.indexBoost.values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                builder.field((String)keys[i], fArray[i]);
            }
            builder.endObject();
        }
        if (this.aggregations != null) {
            builder.field(AGGREGATIONS_FIELD.getPreferredName(), this.aggregations);
        }
        if (this.highlightBuilder != null) {
            builder.field(HIGHLIGHT_FIELD.getPreferredName(), this.highlightBuilder);
        }
        if (this.suggestBuilder != null) {
            builder.field(SUGGEST_FIELD.getPreferredName(), this.suggestBuilder);
        }
        if (this.rescoreBuilders != null) {
            builder.startArray(RESCORE_FIELD.getPreferredName());
            for (RescoreBuilder rescoreBuilder : this.rescoreBuilders) {
                rescoreBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.stats != null) {
            builder.field(STATS_FIELD.getPreferredName(), this.stats);
        }
        if (this.extBuilders != null) {
            builder.startObject(EXT_FIELD.getPreferredName());
            for (SearchExtBuilder searchExtBuilder : this.extBuilders) {
                searchExtBuilder.toXContent(builder, params);
            }
            builder.endObject();
        }
    }

    public int hashCode() {
        return Objects.hash(this.aggregations, this.explain, this.fetchSourceContext, this.docValueFields, this.storedFieldsContext, this.from, this.highlightBuilder, this.indexBoost, this.minScore, this.postQueryBuilder, this.queryBuilder, this.rescoreBuilders, this.scriptFields, this.size, this.sorts, this.searchAfterBuilder, this.sliceBuilder, this.stats, this.suggestBuilder, this.terminateAfter, this.timeout, this.trackScores, this.version, this.profile, this.extBuilders);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SearchSourceBuilder other = (SearchSourceBuilder)obj;
        return Objects.equals(this.aggregations, other.aggregations) && Objects.equals(this.explain, other.explain) && Objects.equals(this.fetchSourceContext, other.fetchSourceContext) && Objects.equals(this.docValueFields, other.docValueFields) && Objects.equals(this.storedFieldsContext, other.storedFieldsContext) && Objects.equals(this.from, other.from) && Objects.equals(this.highlightBuilder, other.highlightBuilder) && Objects.equals(this.indexBoost, other.indexBoost) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.postQueryBuilder, other.postQueryBuilder) && Objects.equals(this.queryBuilder, other.queryBuilder) && Objects.equals(this.rescoreBuilders, other.rescoreBuilders) && Objects.equals(this.scriptFields, other.scriptFields) && Objects.equals(this.size, other.size) && Objects.equals(this.sorts, other.sorts) && Objects.equals(this.searchAfterBuilder, other.searchAfterBuilder) && Objects.equals(this.sliceBuilder, other.sliceBuilder) && Objects.equals(this.stats, other.stats) && Objects.equals(this.suggestBuilder, other.suggestBuilder) && Objects.equals(this.terminateAfter, other.terminateAfter) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.trackScores, other.trackScores) && Objects.equals(this.version, other.version) && Objects.equals(this.profile, other.profile) && Objects.equals(this.extBuilders, other.extBuilders);
    }

    public static class ScriptField
    implements Writeable,
    ToXContent {
        private final boolean ignoreFailure;
        private final String fieldName;
        private final Script script;

        public ScriptField(String fieldName, Script script, boolean ignoreFailure) {
            this.fieldName = fieldName;
            this.script = script;
            this.ignoreFailure = ignoreFailure;
        }

        public ScriptField(StreamInput in) throws IOException {
            this.fieldName = in.readString();
            this.script = new Script(in);
            this.ignoreFailure = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.fieldName);
            this.script.writeTo(out);
            out.writeBoolean(this.ignoreFailure);
        }

        public ScriptField(QueryParseContext context) throws IOException {
            boolean ignoreFailure = false;
            XContentParser parser = context.parser();
            String scriptFieldName = parser.currentName();
            Script script = null;
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (context.getParseFieldMatcher().match(currentFieldName, SCRIPT_FIELD)) {
                            script = Script.parse(parser, context.getParseFieldMatcher(), context.getDefaultScriptLanguage());
                            continue;
                        }
                        if (context.getParseFieldMatcher().match(currentFieldName, IGNORE_FAILURE_FIELD)) {
                            ignoreFailure = parser.booleanValue();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        if (context.getParseFieldMatcher().match(currentFieldName, SCRIPT_FIELD)) {
                            script = Script.parse(parser, context.getParseFieldMatcher(), context.getDefaultScriptLanguage());
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                }
            } else {
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "] in [" + parser.currentName() + "] but found [" + (Object)((Object)token) + "]", parser.getTokenLocation());
            }
            this.ignoreFailure = ignoreFailure;
            this.fieldName = scriptFieldName;
            this.script = script;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Script script() {
            return this.script;
        }

        public boolean ignoreFailure() {
            return this.ignoreFailure;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.fieldName);
            builder.field(SCRIPT_FIELD.getPreferredName(), this.script);
            builder.field(IGNORE_FAILURE_FIELD.getPreferredName(), this.ignoreFailure);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.fieldName, this.script, this.ignoreFailure);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScriptField other = (ScriptField)obj;
            return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.script, other.script) && Objects.equals(this.ignoreFailure, other.ignoreFailure);
        }
    }
}

