/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.AFPTextDataInfo;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.PresentationTextData;
import org.apache.fop.afp.ptoca.LineDataInfoProducer;
import org.apache.fop.afp.ptoca.PtocaBuilder;
import org.apache.fop.afp.ptoca.PtocaProducer;
import org.apache.fop.afp.ptoca.TextDataInfoProducer;

public class PresentationTextObject
extends AbstractNamedAFPObject {
    private PresentationTextData currentPresentationTextData;
    private List presentationTextDataList;
    private PtocaBuilder builder = new DefaultBuilder();

    public PresentationTextObject(String name) {
        super(name);
    }

    public void createTextData(AFPTextDataInfo textDataInfo) throws UnsupportedEncodingException {
        this.createControlSequences(new TextDataInfoProducer(textDataInfo));
    }

    public void createControlSequences(PtocaProducer producer) throws UnsupportedEncodingException {
        if (this.currentPresentationTextData == null) {
            this.startPresentationTextData();
        }
        try {
            producer.produce(this.builder);
        }
        catch (UnsupportedEncodingException e) {
            this.endPresentationTextData();
            throw e;
        }
        catch (IOException ioe) {
            this.endPresentationTextData();
            this.handleUnexpectedIOError(ioe);
        }
    }

    public void createLineData(AFPLineDataInfo lineDataInfo) {
        try {
            this.createControlSequences(new LineDataInfoProducer(lineDataInfo));
        }
        catch (UnsupportedEncodingException e) {
            this.handleUnexpectedIOError(e);
        }
    }

    private void startPresentationTextData() {
        if (this.presentationTextDataList == null) {
            this.presentationTextDataList = new ArrayList();
        }
        this.currentPresentationTextData = this.presentationTextDataList.size() == 0 ? new PresentationTextData(true) : new PresentationTextData();
        this.presentationTextDataList.add(this.currentPresentationTextData);
    }

    private void endPresentationTextData() {
        this.currentPresentationTextData = null;
    }

    protected void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-88, (byte)-101);
        os.write(data);
    }

    protected void writeContent(OutputStream os) throws IOException {
        this.writeObjects(this.presentationTextDataList, os);
    }

    protected void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-87, (byte)-101);
        os.write(data);
    }

    public void endControlSequence() {
        if (this.currentPresentationTextData == null) {
            this.startPresentationTextData();
        }
        try {
            this.builder.endChainedControlSequence();
        }
        catch (IOException ioe) {
            this.endPresentationTextData();
            this.handleUnexpectedIOError(ioe);
        }
    }

    private void handleUnexpectedIOError(IOException ioe) {
        throw new RuntimeException("Unexpected I/O error: " + ioe.getMessage(), ioe);
    }

    public String toString() {
        if (this.presentationTextDataList != null) {
            return this.presentationTextDataList.toString();
        }
        return super.toString();
    }

    private class DefaultBuilder
    extends PtocaBuilder {
        private DefaultBuilder() {
        }

        protected OutputStream getOutputStreamForControlSequence(int length) {
            if (length > PresentationTextObject.this.currentPresentationTextData.getBytesAvailable()) {
                PresentationTextObject.this.endPresentationTextData();
                PresentationTextObject.this.startPresentationTextData();
            }
            return PresentationTextObject.this.currentPresentationTextData.getOutputStream();
        }
    }
}

