/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MindMapNodesSelection;
import freemind.controller.actions.generated.instance.PasteNodeAction;
import freemind.controller.actions.generated.instance.TransferableContent;
import freemind.controller.actions.generated.instance.TransferableFile;
import freemind.controller.actions.generated.instance.TransferableImage;
import freemind.controller.actions.generated.instance.UndoPasteNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.UndoPasteHandler;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class PasteAction
extends AbstractAction
implements ActorXml {
    private static Logger logger;
    private final MindMapController mMindMapController;
    private UndoPasteHandler mUndoPasteHandler;
    private static final Pattern HREF_PATTERN;
    static final Pattern nonLinkCharacter;

    public PasteAction(MindMapController pMindMapController) {
        super(pMindMapController.getText("paste"), new ImageIcon(pMindMapController.getResource("images/editpaste.png")));
        this.mMindMapController = pMindMapController;
        if (logger == null) {
            logger = this.mMindMapController.getFrame().getLogger(this.getClass().getName());
        }
        this.setEnabled(false);
        this.mMindMapController.getActionFactory().registerActor(this, this.getDoActionClass());
        this.mUndoPasteHandler = new UndoPasteHandler(this.mMindMapController);
        this.mMindMapController.getActionFactory().registerActor(this.mUndoPasteHandler, UndoPasteNodeAction.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transferable clipboardContents = this.mMindMapController.getClipboardContents();
        MindMapNode selectedNode = this.mMindMapController.getSelected();
        this.mMindMapController.paste(clipboardContents, selectedNode);
    }

    @Override
    public void act(XmlAction action) {
        PasteNodeAction pasteAction = (PasteNodeAction)action;
        this._paste(this.getTransferable(pasteAction.getTransferableContent()), this.mMindMapController.getNodeFromID(pasteAction.getNode()), pasteAction.getAsSibling(), pasteAction.getIsLeft());
    }

    @Override
    public Class getDoActionClass() {
        return PasteNodeAction.class;
    }

    public PasteNodeAction getPasteNodeAction(Transferable t, NodeCoordinate coord, UndoPasteNodeAction pUndoAction) {
        PasteNodeAction pasteAction = new PasteNodeAction();
        String targetId = this.mMindMapController.getNodeID(coord.target);
        pasteAction.setNode(targetId);
        pasteAction.setTransferableContent(this.getTransferableContent(t, pUndoAction));
        pasteAction.setAsSibling(coord.asSibling);
        pasteAction.setIsLeft(coord.isLeft);
        if (pUndoAction != null) {
            pUndoAction.setNode(targetId);
            pUndoAction.setAsSibling(coord.asSibling);
            pUndoAction.setIsLeft(coord.isLeft);
            String s = this.mMindMapController.marshall((XmlAction)pUndoAction);
            logger.fine("Undo action: " + s);
        }
        return pasteAction;
    }

    public void paste(MindMapNode node, MindMapNode parent) {
        if (node != null) {
            this.insertNodeInto(node, parent);
            this.mMindMapController.nodeStructureChanged(parent);
        }
    }

    public boolean paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        UndoPasteNodeAction undoAction = new UndoPasteNodeAction();
        PasteNodeAction pasteAction = this.getPasteNodeAction(t, new NodeCoordinate(target, asSibling, isLeft), undoAction);
        return this.mMindMapController.doTransaction("paste", new ActionPair((XmlAction)pasteAction, (XmlAction)undoAction));
    }

    private void _paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        if (t == null) {
            return;
        }
        DataFlavorHandler[] dataFlavorHandlerList = this.getFlavorHandlers();
        for (int i = 0; i < dataFlavorHandlerList.length; ++i) {
            DataFlavorHandler handler = dataFlavorHandlerList[i];
            DataFlavor flavor = handler.getDataFlavor();
            if (!t.isDataFlavorSupported(flavor)) continue;
            try {
                handler.paste(t.getTransferData(flavor), target, asSibling, isLeft, t);
                break;
            }
            catch (UnsupportedFlavorException e) {
                Resources.getInstance().logException(e);
                continue;
            }
            catch (IOException e) {
                Resources.getInstance().logException(e);
            }
        }
        this.mMindMapController.getFrame().setWaitingCursor(false);
    }

    private DataFlavorHandler[] getFlavorHandlers() {
        DataFlavorHandler[] dataFlavorHandlerList = new DataFlavorHandler[]{new FileListFlavorHandler(), new MindMapNodesFlavorHandler(), new DirectHtmlFlavorHandler(), new StringFlavorHandler(), new ImageFlavorHandler()};
        return dataFlavorHandlerList;
    }

    public MindMapNodeModel pasteXMLWithoutRedisplay(String pasted, MindMapNode target, boolean asSibling, boolean changeSide, boolean isLeft, HashMap pIDToTarget) throws XMLParseException {
        logger.fine("Pasting " + pasted + " to " + target);
        try {
            MindMapNodeModel node = (MindMapNodeModel)this.mMindMapController.createNodeTreeFromXml(new StringReader(pasted), pIDToTarget);
            this.insertNodeInto(node, target, asSibling, isLeft, changeSide);
            this.mMindMapController.invokeHooksRecursively(node, this.mMindMapController.getModel());
            this.mMindMapController.processUnfinishedLinksInHooks(node);
            return node;
        }
        catch (IOException ee) {
            Resources.getInstance().logException(ee);
            return null;
        }
    }

    private void insertNodeInto(MindMapNodeModel node, MindMapNode target, boolean asSibling, boolean isLeft, boolean changeSide) {
        MindMapNode parent = asSibling ? target.getParentNode() : target;
        if (changeSide) {
            node.setParent(parent);
            node.setLeft(isLeft);
        }
        if (asSibling) {
            this.insertNodeInto(node, parent, parent.getChildPosition(target));
        } else {
            this.insertNodeInto(node, target);
        }
    }

    private MindMapNode pasteStringWithoutRedisplay(Transferable t, MindMapNode parent, boolean asSibling, boolean isLeft) throws UnsupportedFlavorException, IOException {
        String textFromClipboard = (String)t.getTransferData(DataFlavor.stringFlavor);
        Pattern mailPattern = Pattern.compile("([^@ <>\\*']+@[^@ <>\\*']+)");
        String[] textLines = textFromClipboard.split("\n");
        if (textLines.length > 1) {
            this.mMindMapController.getFrame().setWaitingCursor(true);
        }
        MindMapNode realParent = null;
        if (asSibling) {
            realParent = parent;
            parent = new MindMapNodeModel(this.mMindMapController.getFrame(), this.mMindMapController.getMap());
        }
        ArrayList<MindMapNode> parentNodes = new ArrayList<MindMapNode>();
        ArrayList<Integer> parentNodesDepths = new ArrayList<Integer>();
        parentNodes.add(parent);
        parentNodesDepths.add(new Integer(-1));
        String[] linkPrefixes = new String[]{"http://", "ftp://", "https://"};
        MindMapNode pastedNode = null;
        block0: for (int i = 0; i < textLines.length; ++i) {
            int j;
            Matcher mailMatcher;
            int depth;
            String text = textLines[i];
            if ((text = text.replaceAll("\t", "        ")).matches(" *")) continue;
            for (depth = 0; depth < text.length() && text.charAt(depth) == ' '; ++depth) {
            }
            String visibleText = text.trim();
            if (visibleText.matches("^http://(www\\.)?[^ ]*$")) {
                visibleText = visibleText.replaceAll("^http://(www\\.)?", "").replaceAll("(/|\\.[^\\./\\?]*)$", "").replaceAll("((\\.[^\\./]*\\?)|\\?)[^/]*$", " ? ...").replaceAll("_|%20", " ");
                String[] textParts = visibleText.split("/");
                visibleText = "";
                for (int textPartIdx = 0; textPartIdx < textParts.length; ++textPartIdx) {
                    if (textPartIdx > 0) {
                        visibleText = visibleText + " > ";
                    }
                    visibleText = visibleText + (textPartIdx == 0 ? textParts[textPartIdx] : Tools.firstLetterCapitalized(textParts[textPartIdx].replaceAll("^~*", "")));
                }
            }
            MindMapNode node = this.mMindMapController.newNode(visibleText, parent.getMap());
            if (textLines.length == 1) {
                pastedNode = node;
            }
            if ((mailMatcher = mailPattern.matcher(visibleText)).find()) {
                node.setLink("mailto:" + mailMatcher.group());
            }
            for (j = 0; j < linkPrefixes.length; ++j) {
                int linkEnd;
                int linkStart = text.indexOf(linkPrefixes[j]);
                if (linkStart == -1) continue;
                for (linkEnd = linkStart; linkEnd < text.length() && !nonLinkCharacter.matcher(text.substring(linkEnd, linkEnd + 1)).matches(); ++linkEnd) {
                }
                node.setLink(text.substring(linkStart, linkEnd));
            }
            for (j = parentNodes.size() - 1; j >= 0; --j) {
                if (depth <= (Integer)parentNodesDepths.get(j)) continue;
                for (int k = j + 1; k < parentNodes.size(); ++k) {
                    MindMapNode n = (MindMapNode)parentNodes.get(k);
                    if (n.getParentNode() == parent) {
                        // empty if block
                    }
                    parentNodes.remove(k);
                    parentNodesDepths.remove(k);
                }
                MindMapNode target = (MindMapNode)parentNodes.get(j);
                node.setLeft(isLeft);
                this.insertNodeInto(node, target);
                parentNodes.add(node);
                parentNodesDepths.add(new Integer(depth));
                continue block0;
            }
        }
        for (int k = 0; k < parentNodes.size(); ++k) {
            MindMapNode n = (MindMapNode)parentNodes.get(k);
            if (n.getParentNode() != parent) continue;
        }
        return pastedNode;
    }

    private void insertNodeInto(MindMapNodeModel node, MindMapNode parent, int i) {
        this.mMindMapController.insertNodeInto(node, parent, i);
    }

    private void insertNodeInto(MindMapNode node, MindMapNode parent) {
        this.mMindMapController.insertNodeInto(node, parent);
    }

    private TransferableContent getTransferableContent(Transferable t, UndoPasteNodeAction pUndoAction) {
        boolean amountAlreadySet = false;
        try {
            int childCount;
            String textFromClipboard;
            TransferableContent trans = new TransferableContent();
            if (t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor)) {
                textFromClipboard = (String)t.getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
                trans.setTransferable(HtmlTools.makeValidXml(textFromClipboard));
                if (pUndoAction != null && !amountAlreadySet) {
                    pUndoAction.setNodeAmount(Tools.countOccurrences(textFromClipboard, "<nodeseparator>") + 1);
                    amountAlreadySet = true;
                }
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                textFromClipboard = (String)t.getTransferData(DataFlavor.stringFlavor);
                trans.setTransferableAsPlainText(HtmlTools.makeValidXml(textFromClipboard));
                if (pUndoAction != null && !amountAlreadySet) {
                    childCount = this.determineAmountOfNewNodes(t);
                    pUndoAction.setNodeAmount(childCount);
                    amountAlreadySet = true;
                }
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.rtfFlavor)) {
                // empty if block
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.htmlFlavor)) {
                textFromClipboard = (String)t.getTransferData(MindMapNodesSelection.htmlFlavor);
                trans.setTransferableAsHtml(HtmlTools.makeValidXml(textFromClipboard));
                if (pUndoAction != null && !amountAlreadySet) {
                    try {
                        childCount = this.determineAmountOfNewNodes(t);
                        pUndoAction.setNodeAmount(childCount);
                    }
                    catch (Exception e) {
                        Resources.getInstance().logException(e);
                        pUndoAction.setNodeAmount(1);
                    }
                    amountAlreadySet = true;
                }
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
                List fileList = (List)t.getTransferData(MindMapNodesSelection.fileListFlavor);
                for (File fileName : fileList) {
                    TransferableFile transferableFile = new TransferableFile();
                    transferableFile.setFileName(fileName.getAbsolutePath());
                    trans.addTransferableFile(transferableFile);
                }
                if (pUndoAction != null && !amountAlreadySet) {
                    pUndoAction.setNodeAmount(fileList.size());
                    amountAlreadySet = true;
                }
            }
            if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                logger.info("image...");
                try {
                    BufferedImage image = (BufferedImage)t.getTransferData(DataFlavor.imageFlavor);
                    TransferableImage timg = new TransferableImage();
                    File mindmapFile = this.mMindMapController.getMap().getFile();
                    if (mindmapFile == null) {
                        JOptionPane.showMessageDialog(this.mMindMapController.getView(), this.mMindMapController.getText("map_not_saved"), "FreeMind", 0);
                        return null;
                    }
                    File tempFile = File.createTempFile(mindmapFile.getName().replace(".mm", "_"), ".jpeg", mindmapFile.getParentFile());
                    String imgfilepath = tempFile.getName();
                    timg.setImage(imgfilepath);
                    trans.addTransferableImage(timg);
                    logger.info("Starting to write clipboard image " + image + " to " + tempFile);
                    ImageIO.write((RenderedImage)image, "jpg", tempFile);
                    trans.setTransferableAsImage(imgfilepath);
                    if (pUndoAction != null && !amountAlreadySet) {
                        pUndoAction.setNodeAmount(1);
                        amountAlreadySet = true;
                    }
                }
                catch (UnsupportedFlavorException ufe) {
                    Resources.getInstance().logException(ufe);
                }
                catch (IOException ioe) {
                    Resources.getInstance().logException(ioe);
                }
            }
            return trans;
        }
        catch (UnsupportedFlavorException e) {
            Resources.getInstance().logException(e);
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        return null;
    }

    protected int determineAmountOfNewNodes(Transferable t) throws UnsupportedFlavorException, IOException {
        MindMapNodeModel parent = new MindMapNodeModel(this.mMindMapController.getFrame(), this.mMindMapController.getMap());
        this.pasteStringWithoutRedisplay(t, parent, false, false);
        int childCount = parent.getChildCount();
        return childCount;
    }

    private Transferable getTransferable(TransferableContent trans) {
        Vector<File> fileList = new Vector<File>();
        for (TransferableFile tFile : trans.getListTransferableFileList()) {
            fileList.add(new File(tFile.getFileName()));
        }
        MindMapNodesSelection copy = new MindMapNodesSelection(trans.getTransferable(), trans.getTransferableAsImage(), trans.getTransferableAsPlainText(), trans.getTransferableAsRTF(), trans.getTransferableAsHtml(), trans.getTransferableAsDrop(), fileList, null);
        return copy;
    }

    static {
        HREF_PATTERN = Pattern.compile("<html>\\s*<body>\\s*<a\\s+href=\"([^>]+)\">(.*)</a>\\s*</body>\\s*</html>");
        nonLinkCharacter = Pattern.compile("[ \n()'\",;]");
    }

    private class ImageFlavorHandler
    implements DataFlavorHandler {
        private ImageFlavorHandler() {
        }

        @Override
        public void paste(Object transferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            logger.info("imageFlavor");
            PasteAction.this.mMindMapController.getFrame().setWaitingCursor(true);
            String imgfile = "" + transferData;
            String strText = "<html><body><img src=\"" + imgfile + "\"/></body></html>";
            MindMapNode node = PasteAction.this.mMindMapController.newNode(strText, PasteAction.this.mMindMapController.getMap());
            PasteAction.this.insertNodeInto(node, target);
            PasteAction.this.mMindMapController.getFrame().setWaitingCursor(false);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return DataFlavor.imageFlavor;
        }
    }

    private class StringFlavorHandler
    implements DataFlavorHandler {
        private StringFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            PasteAction.this.pasteStringWithoutRedisplay(t, target, asSibling, isLeft);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return DataFlavor.stringFlavor;
        }
    }

    private class HtmlFlavorHandler
    implements DataFlavorHandler {
        private HtmlFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            String textFromClipboard = (String)TransferData;
            MindMapNode pastedNode = PasteAction.this.pasteStringWithoutRedisplay(t, target, asSibling, isLeft);
            textFromClipboard = textFromClipboard.replaceAll("<!--.*?-->", "");
            String[] links = textFromClipboard.split("<[aA][^>]*[hH][rR][eE][fF]=\"");
            MindMapNode linkParentNode = null;
            URL referenceURL = null;
            boolean baseUrlCanceled = false;
            for (int i = 1; i < links.length; ++i) {
                String link = links[i].substring(0, links[i].indexOf("\""));
                String textWithHtml = links[i].replaceAll("^[^>]*>", "").replaceAll("</[aA]>[\\s\\S]*", "");
                String text = HtmlTools.toXMLUnescapedText(textWithHtml.replaceAll("\\n", "").replaceAll("<[^>]*>", "").trim());
                if (text.equals("")) {
                    text = link;
                }
                URL linkURL = null;
                try {
                    linkURL = new URL(link);
                }
                catch (MalformedURLException ex) {
                    try {
                        if (referenceURL == null && !baseUrlCanceled) {
                            String referenceURLString = JOptionPane.showInputDialog(PasteAction.this.mMindMapController.getView().getSelected(), (Object)PasteAction.this.mMindMapController.getText("enter_base_url"));
                            if (referenceURLString == null) {
                                baseUrlCanceled = true;
                            } else {
                                referenceURL = new URL(referenceURLString);
                            }
                        }
                        linkURL = new URL(referenceURL, link);
                    }
                    catch (MalformedURLException ex2) {
                        // empty catch block
                    }
                }
                if (linkURL == null) continue;
                if (links.length == 2 & pastedNode != null) {
                    ((MindMapNodeModel)pastedNode).setLink(linkURL.toString());
                    break;
                }
                if (linkParentNode == null) {
                    linkParentNode = PasteAction.this.mMindMapController.newNode("Links", target.getMap());
                    linkParentNode.setLeft(target.isNewChildLeft());
                    PasteAction.this.insertNodeInto(linkParentNode, target);
                    ((NodeAdapter)linkParentNode).setBold(true);
                }
                MindMapNode linkNode = PasteAction.this.mMindMapController.newNode(text, target.getMap());
                linkNode.setLink(linkURL.toString());
                PasteAction.this.insertNodeInto(linkNode, linkParentNode);
            }
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.htmlFlavor;
        }
    }

    private class DirectHtmlFlavorHandler
    implements DataFlavorHandler {
        private DirectHtmlFlavorHandler() {
        }

        @Override
        public void paste(Object transferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            String body;
            String textFromClipboard = (String)transferData;
            if (textFromClipboard.charAt(0) == '\ufffd') {
                throw new UnsupportedFlavorException(MindMapNodesSelection.htmlFlavor);
            }
            PasteAction.this.mMindMapController.getFrame().setWaitingCursor(true);
            textFromClipboard = textFromClipboard.replaceFirst("(?i)(?s)<head>.*</head>", "").replaceFirst("(?i)(?s)^.*<html[^>]*>", "<html>").replaceFirst("(?i)(?s)<body [^>]*>", "<body>").replaceAll("(?i)(?s)<script.*?>.*?</script>", "").replaceAll("(?i)(?s)</?tbody.*?>", "").replaceAll("(?i)(?s)<!--.*?-->", "").replaceAll("(?i)(?s)</?o[^>]*>", "");
            if (Tools.safeEquals(PasteAction.this.mMindMapController.getFrame().getProperty("cut_out_pictures_when_pasting_html"), "true")) {
                textFromClipboard = textFromClipboard.replaceAll("(?i)(?s)<img[^>]*>", "");
            }
            textFromClipboard = HtmlTools.unescapeHTMLUnicodeEntity(textFromClipboard);
            MindMapNode node = PasteAction.this.mMindMapController.newNode(textFromClipboard, PasteAction.this.mMindMapController.getMap());
            Matcher m = HREF_PATTERN.matcher(textFromClipboard);
            if (m.matches() && !(body = m.group(2)).matches(".*<\\s*a.*")) {
                String href = m.group(1);
                node.setLink(href);
            }
            PasteAction.this.insertNodeInto(node, target);
            PasteAction.this.mMindMapController.getFrame().setWaitingCursor(false);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.htmlFlavor;
        }
    }

    private class MindMapNodesFlavorHandler
    implements DataFlavorHandler {
        private MindMapNodesFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) {
            String textFromClipboard = (String)TransferData;
            if (textFromClipboard != null) {
                String[] textLines = textFromClipboard.split("<nodeseparator>");
                if (textLines.length > 1) {
                    PasteAction.this.mMindMapController.getFrame().setWaitingCursor(true);
                }
                String mapContent = "<map version=\"1.0.1\"><node TEXT=\"DUMMY\">";
                for (int j = 0; j < textLines.length; ++j) {
                    mapContent = mapContent + textLines[j];
                }
                mapContent = mapContent + "</node></map>";
                try {
                    MindMapNodeModel importNode;
                    MindMapNodeModel node = PasteAction.this.mMindMapController.getMindMapMapModel().loadTree(new MindMapMapModel.StringReaderCreator(mapContent), false);
                    ListIterator i = node.childrenUnfolded();
                    while (i.hasNext()) {
                        importNode = (MindMapNodeModel)i.next();
                        PasteAction.this.insertNodeInto(importNode, target, asSibling, isLeft, true);
                    }
                    i = node.childrenUnfolded();
                    while (i.hasNext()) {
                        importNode = (MindMapNodeModel)i.next();
                        PasteAction.this.mMindMapController.invokeHooksRecursively(importNode, PasteAction.this.mMindMapController.getModel());
                    }
                    i = node.childrenUnfolded();
                    while (i.hasNext()) {
                        importNode = (MindMapNodeModel)i.next();
                        PasteAction.this.mMindMapController.processUnfinishedLinksInHooks(importNode);
                    }
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
            }
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.mindMapNodesFlavor;
        }
    }

    private class FileListFlavorHandler
    implements DataFlavorHandler {
        private FileListFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) {
            List fileList = (List)TransferData;
            ListIterator it = fileList.listIterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                MindMapNode node = PasteAction.this.mMindMapController.newNode(file.getName(), target.getMap());
                node.setLeft(isLeft);
                node.setLink(Tools.fileToRelativeUrlString(file, PasteAction.this.mMindMapController.getModel().getFile()));
                PasteAction.this.insertNodeInto((MindMapNodeModel)node, target, asSibling, isLeft, false);
            }
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.fileListFlavor;
        }
    }

    private static interface DataFlavorHandler {
        public void paste(Object var1, MindMapNode var2, boolean var3, boolean var4, Transferable var5) throws UnsupportedFlavorException, IOException;

        public DataFlavor getDataFlavor();
    }

    public static class NodeCoordinate {
        public MindMapNode target;
        public boolean asSibling;
        public boolean isLeft;

        public NodeCoordinate(MindMapNode target, boolean asSibling, boolean isLeft) {
            this.target = target;
            this.asSibling = asSibling;
            this.isLeft = isLeft;
        }

        public MindMapNode getNode() {
            if (this.asSibling) {
                MindMapNode parentNode = this.target.getParentNode();
                return (MindMapNode)parentNode.getChildAt(parentNode.getChildPosition(this.target) - 1);
            }
            logger.finest("getChildCount = " + this.target.getChildCount() + ", target = " + this.target);
            return (MindMapNode)this.target.getChildAt(this.target.getChildCount() - 1);
        }

        public NodeCoordinate(MindMapNode node, boolean isLeft) {
            this.isLeft = isLeft;
            MindMapNode parentNode = node.getParentNode();
            int childPosition = parentNode.getChildPosition(node);
            if (childPosition == parentNode.getChildCount() - 1) {
                this.target = parentNode;
                this.asSibling = false;
            } else {
                this.target = (MindMapNode)parentNode.getChildAt(childPosition + 1);
                this.asSibling = true;
            }
        }
    }
}

