/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.attributes.AttributeValue;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.internal.attributes.AttributeMatchingRules;
import org.gradle.api.internal.attributes.CompatibilityRuleChainInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompatibilityRuleChain<T>
implements CompatibilityRuleChainInternal<T> {
    private final List<Action<? super CompatibilityCheckDetails<T>>> rules = Lists.newArrayList();

    @Override
    public void ordered(Comparator<? super T> comparator) {
        Action<CompatibilityCheckDetails<? super T>> rule = AttributeMatchingRules.orderedCompatibility(comparator, false);
        this.add(rule);
    }

    @Override
    public void reverseOrdered(Comparator<? super T> comparator) {
        Action<CompatibilityCheckDetails<? super T>> rule = AttributeMatchingRules.orderedCompatibility(comparator, true);
        this.add(rule);
    }

    @Override
    public void add(Action<? super CompatibilityCheckDetails<T>> rule) {
        this.rules.add(rule);
    }

    @Override
    public void assumeCompatibleWhenMissing() {
        Action rule = AttributeMatchingRules.assumeCompatibleWhenMissing();
        this.add(rule);
    }

    public void execute(CompatibilityCheckDetails<T> details) {
        State state = new State(details);
        for (Action<? super CompatibilityCheckDetails<T>> action : this.rules) {
            action.execute(state);
            if (!state.determined) continue;
            return;
        }
        if (!state.determined) {
            AttributeMatchingRules.equalityCompatibility().execute(state);
            if (state.determined) {
                return;
            }
        }
        details.incompatible();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class State<T>
    implements CompatibilityCheckDetails<T> {
        private final CompatibilityCheckDetails<T> delegate;
        private boolean determined;

        private State(CompatibilityCheckDetails<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public AttributeValue<T> getConsumerValue() {
            return this.delegate.getConsumerValue();
        }

        @Override
        public AttributeValue<T> getProducerValue() {
            return this.delegate.getProducerValue();
        }

        @Override
        public void compatible() {
            this.determined = true;
            this.delegate.compatible();
        }

        @Override
        public void incompatible() {
            this.determined = true;
            this.delegate.incompatible();
        }
    }
}

