/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipUpToDateTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipUpToDateTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        LOGGER.debug("Determining if {} is up-to-date", (Object)task);
        Timer clock = Timers.startTimer();
        TaskArtifactState taskArtifactState = context.getTaskArtifactState();
        try {
            ArrayList<String> messages;
            ArrayList<String> arrayList = messages = LOGGER.isInfoEnabled() ? new ArrayList<String>() : null;
            if (taskArtifactState.isUpToDate(messages)) {
                LOGGER.info("Skipping {} as it is up-to-date (took {}).", (Object)task, (Object)clock.getElapsed());
                state.setOutcome(TaskExecutionOutcome.UP_TO_DATE);
                return;
            }
            this.logOutOfDateMessages(messages, task, clock.getElapsed());
            task.getOutputs().setHistory(taskArtifactState.getExecutionHistory());
            taskArtifactState.beforeTask();
            try {
                this.executer.execute(task, state, context);
                if (state.getFailure() == null) {
                    taskArtifactState.afterTask();
                }
            }
            finally {
                task.getOutputs().setHistory(null);
            }
        }
        finally {
            taskArtifactState.finished();
        }
    }

    private void logOutOfDateMessages(List<String> messages, TaskInternal task, String took) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("Executing %s (up-to-date check took %s) due to:", task, took);
            for (String message : messages) {
                formatter.format("%n  %s", message);
            }
            LOGGER.info(formatter.toString());
        }
    }
}

