/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.execution.internal.TaskOperationDescriptor;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.progress.BuildOperationInternal;
import org.gradle.internal.progress.InternalBuildListener;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.events.AbstractTestResult;
import org.gradle.tooling.internal.provider.events.DefaultFailure;
import org.gradle.tooling.internal.provider.events.DefaultTestDescriptor;
import org.gradle.tooling.internal.provider.events.DefaultTestFailureResult;
import org.gradle.tooling.internal.provider.events.DefaultTestFinishedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTestSkippedResult;
import org.gradle.tooling.internal.provider.events.DefaultTestStartedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTestSuccessResult;

class ClientForwardingTestListener
implements TestListenerInternal,
InternalBuildListener {
    private final BuildEventConsumer eventConsumer;
    private final BuildClientSubscriptions clientSubscriptions;
    private Map<Object, String> runningTasks = Maps.newHashMap();

    ClientForwardingTestListener(BuildEventConsumer eventConsumer, BuildClientSubscriptions clientSubscriptions) {
        this.eventConsumer = eventConsumer;
        this.clientSubscriptions = clientSubscriptions;
    }

    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
        this.eventConsumer.dispatch((Object)new DefaultTestStartedProgressEvent(startEvent.getStartTime(), this.adapt(testDescriptor)));
    }

    public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
        this.eventConsumer.dispatch((Object)new DefaultTestFinishedProgressEvent(completeEvent.getEndTime(), this.adapt(testDescriptor), ClientForwardingTestListener.adapt(testResult)));
    }

    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
    }

    private DefaultTestDescriptor adapt(TestDescriptorInternal testDescriptor) {
        return testDescriptor.isComposite() ? this.toTestDescriptorForSuite(testDescriptor) : this.toTestDescriptorForTest(testDescriptor);
    }

    private DefaultTestDescriptor toTestDescriptorForSuite(TestDescriptorInternal suite) {
        Object id = suite.getId();
        String name = suite.getName();
        String displayName = suite.toString();
        String testKind = "SUITE";
        String suiteName = suite.getName();
        String className = suite.getClassName();
        String methodName = null;
        Object parentId = this.getParentId(suite);
        String testTaskPath = this.getTaskPath(suite);
        return new DefaultTestDescriptor(id, name, displayName, testKind, suiteName, className, methodName, parentId, testTaskPath);
    }

    private DefaultTestDescriptor toTestDescriptorForTest(TestDescriptorInternal test) {
        Object id = test.getId();
        String name = test.getName();
        String displayName = test.toString();
        String testKind = "ATOMIC";
        String suiteName = null;
        String className = test.getClassName();
        String methodName = test.getName();
        Object parentId = this.getParentId(test);
        String taskPath = this.getTaskPath(test);
        return new DefaultTestDescriptor(id, name, displayName, testKind, suiteName, className, methodName, parentId, taskPath);
    }

    private String getTaskPath(TestDescriptorInternal givenDescriptor) {
        TestDescriptorInternal descriptor = givenDescriptor;
        while (descriptor.getOwnerBuildOperationId() == null && descriptor.getParent() != null) {
            descriptor = descriptor.getParent();
        }
        return this.runningTasks.get(descriptor.getOwnerBuildOperationId());
    }

    private Object getParentId(TestDescriptorInternal descriptor) {
        TestDescriptorInternal parent = descriptor.getParent();
        if (parent != null) {
            return parent.getId();
        }
        if (this.clientSubscriptions.isSendTaskProgressEvents()) {
            return descriptor.getOwnerBuildOperationId();
        }
        return null;
    }

    private static AbstractTestResult adapt(TestResult result) {
        TestResult.ResultType resultType = result.getResultType();
        switch (resultType) {
            case SUCCESS: {
                return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
            }
            case SKIPPED: {
                return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
            }
            case FAILURE: {
                return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), ClientForwardingTestListener.convertExceptions(result.getExceptions()));
            }
        }
        throw new IllegalStateException("Unknown test result type: " + resultType);
    }

    private static List<DefaultFailure> convertExceptions(List<Throwable> exceptions) {
        ArrayList<DefaultFailure> failures = new ArrayList<DefaultFailure>(exceptions.size());
        for (Throwable exception : exceptions) {
            failures.add(DefaultFailure.fromThrowable((Throwable)exception));
        }
        return failures;
    }

    public void started(BuildOperationInternal buildOperation, OperationStartEvent startEvent) {
        if (!(buildOperation.getOperationDescriptor() instanceof TaskOperationDescriptor)) {
            return;
        }
        TaskInternal task = ((TaskOperationDescriptor)buildOperation.getOperationDescriptor()).getTask();
        if (!(task instanceof Test)) {
            return;
        }
        this.runningTasks.put(buildOperation.getId(), task.getPath());
    }

    public void finished(BuildOperationInternal buildOperation, OperationResult finishEvent) {
        if (!(buildOperation.getOperationDescriptor() instanceof TaskOperationDescriptor)) {
            return;
        }
        this.runningTasks.remove(buildOperation.getId());
    }
}

