/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.gradle.foundation.output.FileLink;
import org.gradle.foundation.output.FileLinkDefinitionLord;
import org.gradle.foundation.output.LiveOutputParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputTextPane {
    private JScrollPane scroll;
    private final TextPane textPane;
    private DefaultStyledDocument document;
    private Font font;
    private AttributeSet defaultStyle;
    private AttributeSet fileStyle;
    private LiveOutputParser liveOutputParser;
    private Interaction interaction;
    private boolean allowsClickingFiles;
    private boolean hasClickableLinks;
    private JPopupMenu popupMenu;

    public OutputTextPane(Interaction interaction, boolean allowsClickingFiles, Font font, FileLinkDefinitionLord fileLinkDefinitionLord) {
        this.interaction = interaction;
        this.allowsClickingFiles = allowsClickingFiles;
        this.font = font;
        this.document = new DefaultStyledDocument();
        this.textPane = new TextPane(this.document);
        this.textPane.setEditable(false);
        this.textPane.setAutoscrolls(false);
        this.scroll = new JScrollPane(this.textPane);
        this.scroll.setAutoscrolls(false);
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(20);
        DefaultCaret caret = new DefaultCaret();
        caret.setUpdatePolicy(1);
        this.textPane.setCaret(caret);
        Color background = Color.white;
        this.textPane.setBackground(background);
        this.scroll.setBackground(background);
        this.scroll.getViewport().setBackground(background);
        this.resetFontStyles();
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                OutputTextPane.this.handleClick(e.getButton() == 3, e.getPoint());
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    OutputTextPane.this.showPopup(e.getPoint());
                }
            }
        });
        this.textPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                OutputTextPane.this.handleKeyPress(e.getKeyCode());
            }
        });
        this.liveOutputParser = new LiveOutputParser(fileLinkDefinitionLord, true);
    }

    private void resetFontStyles() {
        this.defaultStyle = this.createDefaultAttributeSet();
        StyleContext styleContent = StyleContext.getDefaultStyleContext();
        this.fileStyle = this.createDefaultAttributeSet();
        this.fileStyle = styleContent.addAttribute(this.fileStyle, StyleConstants.Foreground, Color.blue);
        this.fileStyle = styleContent.addAttribute(this.fileStyle, StyleConstants.Underline, true);
    }

    private AttributeSet createDefaultAttributeSet() {
        StyleContext styleContent = StyleContext.getDefaultStyleContext();
        AttributeSet attributeSet = styleContent.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.FontFamily, this.font.getName());
        attributeSet = styleContent.addAttribute(attributeSet, StyleConstants.FontSize, this.font.getSize());
        return attributeSet;
    }

    public AttributeSet getDefaultStyle() {
        return this.defaultStyle;
    }

    public JComponent asComponent() {
        return this.scroll;
    }

    public JTextPane getTextComponent() {
        return this.textPane;
    }

    public String getText() {
        return this.textPane.getText();
    }

    private void handleClick(boolean isRightButton, Point point) {
        FileLink fileLink;
        if (!isRightButton && this.allowsClickingFiles && (fileLink = this.getFileLinkAt(point)) != null) {
            this.interaction.fileClicked(fileLink.getFile(), fileLink.getLineNumber());
        }
    }

    private void handleKeyPress(int keyCode) {
        FileLink fileLink;
        int caretLocation;
        if (this.allowsClickingFiles && keyCode == 10 && (caretLocation = this.textPane.getCaretPosition()) != -1 && (fileLink = this.liveOutputParser.getFileLink(caretLocation)) != null) {
            this.interaction.fileClicked(fileLink.getFile(), fileLink.getLineNumber());
        }
    }

    private void showPopup(Point point) {
        this.buildPopup();
        this.popupMenu.show(this.textPane, point.x, point.y);
    }

    private void buildPopup() {
        if (this.popupMenu != null) {
            return;
        }
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent e) {
                String text = OutputTextPane.this.textPane.getSelectedText();
                if (text != null) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
                }
            }
        });
        this.popupMenu.add(new AbstractAction("Select All"){

            public void actionPerformed(ActionEvent e) {
                OutputTextPane.this.textPane.selectAll();
            }
        });
    }

    public void appendText(String text) {
        this.appendText(text, false);
    }

    public void setText(String text) {
        this.liveOutputParser.reset();
        this.appendText(text, true);
    }

    private void appendText(String text, boolean replaceExisting) {
        Rectangle viewBounds = this.scroll.getViewport().getViewRect();
        Dimension viewSize = this.scroll.getViewport().getViewSize();
        int maxViewBoundsY = viewBounds.y + viewBounds.height;
        boolean shouldScroll = viewSize.height - maxViewBoundsY < 20;
        try {
            if (replaceExisting) {
                this.hasClickableLinks = false;
                this.document.remove(0, this.document.getLength());
            }
            this.document.insertString(this.document.getLength(), text, this.defaultStyle);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (this.allowsClickingFiles) {
            List<FileLink> fileLinks = this.liveOutputParser.appendText(text);
            this.highlightFileLinks(fileLinks);
        }
        if (shouldScroll) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputTextPane.this.scrollToBottom();
                }
            });
        }
    }

    private void highlightFileLinks(List<FileLink> fileLinks) {
        for (FileLink fileLink : fileLinks) {
            this.document.setCharacterAttributes(fileLink.getStartingIndex(), fileLink.getLength(), this.fileStyle, false);
            this.hasClickableLinks = true;
        }
    }

    private void scrollToBottom() {
        int height = this.scroll.getVerticalScrollBar().getHeight();
        int maximum = this.scroll.getVerticalScrollBar().getMaximum();
        int newValue = maximum - height;
        this.scroll.getVerticalScrollBar().setValue(newValue);
    }

    public FileLink getFileLinkAt(Point point) {
        int index = this.textPane.viewToModel(point);
        return this.liveOutputParser.getFileLink(index);
    }

    public void setFont(Font font) {
        this.font = font;
        this.resetFontStyles();
        this.resetText();
    }

    private void resetText() {
        String text = this.liveOutputParser.getText();
        this.liveOutputParser.reset();
        this.appendText(text, true);
    }

    public boolean hasClickableLinks() {
        return this.hasClickableLinks;
    }

    public boolean allowsClickingFiles() {
        return this.allowsClickingFiles;
    }

    public void selectFileLink(FileLink fileLink) {
        if (fileLink == null) {
            return;
        }
        this.textPane.setCaretPosition(fileLink.getStartingIndex());
        this.textPane.select(fileLink.getStartingIndex(), fileLink.getEndingIndex());
        try {
            Rectangle startingRectangle = this.textPane.modelToView(fileLink.getStartingIndex());
            Rectangle endDingRectangle = this.textPane.modelToView(fileLink.getEndingIndex());
            Rectangle totalBounds = startingRectangle.union(endDingRectangle);
            this.textPane.scrollRectToVisible(totalBounds);
            this.textPane.requestFocus();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public FileLink getPreviousFileLink() {
        return this.liveOutputParser.getPreviousFileLink(this.textPane.getCaretPosition());
    }

    public FileLink getNextFileLink() {
        return this.liveOutputParser.getNextFileLink(this.textPane.getCaretPosition());
    }

    public void resetHighlights() {
        this.document.setCharacterAttributes(0, this.document.getLength(), this.defaultStyle, true);
        if (this.allowsClickingFiles) {
            List<FileLink> fileLinks = this.liveOutputParser.getFileLinks();
            this.highlightFileLinks(fileLinks);
        }
    }

    private class TextPane
    extends JTextPane {
        private TextPane(DefaultStyledDocument doc) {
            super(doc);
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }

    public static interface Interaction {
        public void fileClicked(File var1, int var2);
    }
}

