/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.openapi.wrappers.foundation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.openapi.external.foundation.ProjectVersion1;
import org.gradle.openapi.external.foundation.TaskVersion1;
import org.gradle.openapi.wrappers.foundation.TaskWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectWrapper
implements ProjectVersion1 {
    private ProjectView projectView;

    public ProjectWrapper(ProjectView projectView) {
        this.projectView = projectView;
    }

    public String getName() {
        return this.projectView.getName();
    }

    public File getFile() {
        return this.projectView.getBuildFile();
    }

    public List<TaskVersion1> getTasks() {
        return TaskWrapper.convertTasks(this.projectView.getTasks());
    }

    public List<ProjectVersion1> getSubProjects() {
        return ProjectWrapper.convertProjects(this.projectView.getSubProjects());
    }

    public ProjectVersion1 getParentProject() {
        return new ProjectWrapper(this.projectView.getParentProject());
    }

    public List<ProjectVersion1> getDependantProjects() {
        return Collections.emptyList();
    }

    public ProjectVersion1 getSubProject(String name) {
        ProjectView subProject = this.projectView.getSubProject(name);
        if (subProject == null) {
            return null;
        }
        return new ProjectWrapper(subProject);
    }

    public String getFullProjectName() {
        return this.projectView.getFullProjectName();
    }

    public ProjectVersion1 getSubProjectFromFullPath(String fullProjectName) {
        ProjectView projectFromFullPath = this.projectView.getSubProjectFromFullPath(fullProjectName);
        if (projectFromFullPath == null) {
            return null;
        }
        return new ProjectWrapper(projectFromFullPath);
    }

    public TaskVersion1 getTask(String name) {
        TaskView taskView = this.projectView.getTask(name);
        if (taskView == null) {
            return null;
        }
        return new TaskWrapper(taskView);
    }

    public List<TaskVersion1> getDefaultTasks() {
        return TaskWrapper.convertTasks(this.projectView.getDefaultTasks());
    }

    public TaskVersion1 getTaskFromFullPath(String fullTaskName) {
        TaskView taskView = this.projectView.getTaskFromFullPath(fullTaskName);
        if (taskView == null) {
            return null;
        }
        return new TaskWrapper(taskView);
    }

    public static List<ProjectVersion1> convertProjects(List<ProjectView> projectViewList) {
        ArrayList<ProjectVersion1> returnProjects = new ArrayList<ProjectVersion1>();
        if (projectViewList != null) {
            for (ProjectView projectView : projectViewList) {
                returnProjects.add(new ProjectWrapper(projectView));
            }
        }
        return returnProjects;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProjectWrapper)) {
            return false;
        }
        ProjectWrapper otherProjectWrapper = (ProjectWrapper)obj;
        return otherProjectWrapper.projectView.equals(this.projectView);
    }

    public int hashCode() {
        return this.projectView.hashCode();
    }

    public String toString() {
        return this.projectView.toString();
    }
}

