/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.internal.Transformers;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.AbstractPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultCommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultMutableCommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.MutableCommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativeplatform.toolchain.internal.PCHUtils;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.WindowsResourceCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Assembler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CppCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CppPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LibExeStaticLibraryArchiver;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LinkExeLinker;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Ucrt;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppToolChain;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsResourceCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolConfigurationInternal;
import org.gradle.process.internal.ExecActionFactory;

class VisualCppPlatformToolProvider
extends AbstractPlatformToolProvider {
    private final Map<ToolType, CommandLineToolConfigurationInternal> commandLineToolConfigurations;
    private final VisualCppInstall visualCpp;
    private final WindowsSdk sdk;
    private final Ucrt ucrt;
    private final NativePlatformInternal targetPlatform;
    private final ExecActionFactory execActionFactory;

    VisualCppPlatformToolProvider(BuildOperationProcessor buildOperationProcessor, OperatingSystemInternal operatingSystem, Map<ToolType, CommandLineToolConfigurationInternal> commandLineToolConfigurations, VisualCppInstall visualCpp, WindowsSdk sdk, Ucrt ucrt, NativePlatformInternal targetPlatform, ExecActionFactory execActionFactory) {
        super(buildOperationProcessor, operatingSystem);
        this.commandLineToolConfigurations = commandLineToolConfigurations;
        this.visualCpp = visualCpp;
        this.sdk = sdk;
        this.ucrt = ucrt;
        this.targetPlatform = targetPlatform;
        this.execActionFactory = execActionFactory;
    }

    @Override
    public String getSharedLibraryLinkFileName(String libraryName) {
        return this.getSharedLibraryName(libraryName).replaceFirst("\\.dll$", ".lib");
    }

    protected Compiler<CppCompileSpec> createCppCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C++ compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CppCompiler cppCompiler = new CppCompiler(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.CPP_COMPILER)), this.addIncludePathAndDefinitions(CppCompileSpec.class), this.getObjectFileExtension(), true);
        return new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, this.getObjectFileExtension());
    }

    @Override
    protected Compiler<?> createCppPCHCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C++ PCH compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CppPCHCompiler cppPCHCompiler = new CppPCHCompiler(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.CPP_COMPILER)), this.pchSpecTransforms(CppPCHCompileSpec.class), this.getPCHFileExtension(), true);
        return new OutputCleaningCompiler<CppPCHCompileSpec>(cppPCHCompiler, this.getPCHFileExtension());
    }

    protected Compiler<CCompileSpec> createCCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CCompiler cCompiler = new CCompiler(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.C_COMPILER)), this.addIncludePathAndDefinitions(CCompileSpec.class), this.getObjectFileExtension(), true);
        return new OutputCleaningCompiler<CCompileSpec>(cCompiler, this.getObjectFileExtension());
    }

    @Override
    protected Compiler<?> createCPCHCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C PCH compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CPCHCompiler cpchCompiler = new CPCHCompiler(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.C_COMPILER)), this.pchSpecTransforms(CPCHCompileSpec.class), this.getPCHFileExtension(), true);
        return new OutputCleaningCompiler<CPCHCompileSpec>(cpchCompiler, this.getPCHFileExtension());
    }

    protected Compiler<AssembleSpec> createAssembler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Assembler", this.visualCpp.getAssembler(this.targetPlatform));
        return new Assembler(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.ASSEMBLER)), this.addIncludePathAndDefinitions(AssembleSpec.class), this.getObjectFileExtension(), false);
    }

    @Override
    protected Compiler<?> createObjectiveCppCompiler() {
        throw this.unavailableTool("Objective-C++ is not available on the Visual C++ toolchain");
    }

    @Override
    protected Compiler<?> createObjectiveCCompiler() {
        throw this.unavailableTool("Objective-C is not available on the Visual C++ toolchain");
    }

    protected Compiler<WindowsResourceCompileSpec> createWindowsResourceCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Windows resource compiler", this.sdk.getResourceCompiler(this.targetPlatform));
        String objectFileExtension = ".res";
        WindowsResourceCompiler windowsResourceCompiler = new WindowsResourceCompiler(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.WINDOW_RESOURCES_COMPILER)), this.addIncludePathAndDefinitions(WindowsResourceCompileSpec.class), objectFileExtension, false);
        return new OutputCleaningCompiler<WindowsResourceCompileSpec>(windowsResourceCompiler, objectFileExtension);
    }

    protected Compiler<LinkerSpec> createLinker() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Linker", this.visualCpp.getLinker(this.targetPlatform));
        return new LinkExeLinker(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.LINKER)), this.addLibraryPath());
    }

    protected Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Static library archiver", this.visualCpp.getArchiver(this.targetPlatform));
        return new LibExeStaticLibraryArchiver(this.buildOperationProcessor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.STATIC_LIB_ARCHIVER)), (Transformer<StaticLibraryArchiverSpec, StaticLibraryArchiverSpec>)Transformers.noOpTransformer());
    }

    private CommandLineToolInvocationWorker tool(String toolName, File exe) {
        return new DefaultCommandLineToolInvocationWorker(toolName, exe, this.execActionFactory);
    }

    private CommandLineToolContext context(CommandLineToolConfigurationInternal commandLineToolConfiguration) {
        DefaultMutableCommandLineToolContext invocationContext = new DefaultMutableCommandLineToolContext();
        invocationContext.addPath(this.visualCpp.getPath(this.targetPlatform));
        invocationContext.addPath(this.sdk.getBinDir(this.targetPlatform));
        this.clearEnvironmentVars(invocationContext, "INCLUDE", "CL", "LIBPATH", "LINK", "LIB");
        invocationContext.setArgAction(commandLineToolConfiguration.getArgAction());
        return invocationContext;
    }

    private void clearEnvironmentVars(MutableCommandLineToolContext invocation, String ... names) {
        Map environmentVariables = Jvm.current().getInheritableEnvironmentVariables(System.getenv());
        for (String name : names) {
            Object value = environmentVariables.get(name);
            if (value == null) continue;
            VisualCppToolChain.LOGGER.warn("Ignoring value '{}' set for environment variable '{}'.", value, (Object)name);
            invocation.addEnvironmentVar(name, "");
        }
    }

    private <T extends NativeCompileSpec> Transformer<T, T> pchSpecTransforms(final Class<T> type) {
        return new Transformer<T, T>(){

            public T transform(T original) {
                ArrayList transformers = Lists.newArrayList();
                transformers.add(PCHUtils.getHeaderToSourceFileTransformer(type));
                transformers.add(VisualCppPlatformToolProvider.this.addIncludePathAndDefinitions(type));
                Object next = original;
                for (Transformer transformer : transformers) {
                    next = (NativeCompileSpec)transformer.transform(next);
                }
                return next;
            }
        };
    }

    private <T extends NativeCompileSpec> Transformer<T, T> addIncludePathAndDefinitions(Class<T> type) {
        return new Transformer<T, T>(){

            public T transform(T original) {
                original.include(VisualCppPlatformToolProvider.this.visualCpp.getIncludePath(VisualCppPlatformToolProvider.this.targetPlatform));
                original.include(VisualCppPlatformToolProvider.this.sdk.getIncludeDirs());
                if (VisualCppPlatformToolProvider.this.ucrt != null) {
                    original.include(VisualCppPlatformToolProvider.this.ucrt.getIncludeDirs());
                }
                for (Map.Entry<String, String> definition : VisualCppPlatformToolProvider.this.visualCpp.getDefinitions(VisualCppPlatformToolProvider.this.targetPlatform).entrySet()) {
                    original.define(definition.getKey(), definition.getValue());
                }
                return original;
            }
        };
    }

    private Transformer<LinkerSpec, LinkerSpec> addLibraryPath() {
        return new Transformer<LinkerSpec, LinkerSpec>(){

            public LinkerSpec transform(LinkerSpec original) {
                if (VisualCppPlatformToolProvider.this.ucrt == null) {
                    original.libraryPath(VisualCppPlatformToolProvider.this.visualCpp.getLibraryPath(VisualCppPlatformToolProvider.this.targetPlatform), VisualCppPlatformToolProvider.this.sdk.getLibDir(VisualCppPlatformToolProvider.this.targetPlatform));
                } else {
                    original.libraryPath(VisualCppPlatformToolProvider.this.visualCpp.getLibraryPath(VisualCppPlatformToolProvider.this.targetPlatform), VisualCppPlatformToolProvider.this.sdk.getLibDir(VisualCppPlatformToolProvider.this.targetPlatform), VisualCppPlatformToolProvider.this.ucrt.getLibDir(VisualCppPlatformToolProvider.this.targetPlatform));
                }
                return original;
            }
        };
    }

    public String getPCHFileExtension() {
        return ".pch";
    }
}

