/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.NoBuildDependenciesArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;

public class DefaultResolvedArtifactResults
implements VisitedArtifactsResults {
    private final Map<Long, ArtifactSet> artifactsById;
    private final Set<Long> buildableArtifacts;

    public DefaultResolvedArtifactResults(Map<Long, ArtifactSet> artifactsById, Set<Long> buildableArtifacts) {
        this.artifactsById = artifactsById;
        this.buildableArtifacts = buildableArtifacts;
    }

    @Override
    public SelectedArtifactResults select(Transformer<HasAttributes, Collection<? extends HasAttributes>> selector) {
        LinkedHashSet allArtifactSets = Sets.newLinkedHashSet();
        LinkedHashMap resolvedArtifactsById = Maps.newLinkedHashMap();
        for (Map.Entry<Long, ArtifactSet> entry : this.artifactsById.entrySet()) {
            ResolvedArtifactSet resolvedArtifacts;
            Set<? extends ResolvedVariant> variants = entry.getValue().getVariants();
            ResolvedVariant selected = (ResolvedVariant)selector.transform(variants);
            if (selected == null) {
                resolvedArtifacts = ResolvedArtifactSet.EMPTY;
            } else {
                resolvedArtifacts = selected.getArtifacts();
                if (!this.buildableArtifacts.contains(entry.getValue().getId())) {
                    resolvedArtifacts = NoBuildDependenciesArtifactSet.of(resolvedArtifacts);
                }
                allArtifactSets.add(resolvedArtifacts);
            }
            resolvedArtifactsById.put(entry.getKey(), resolvedArtifacts);
        }
        return new DefaultSelectedArtifactResults(CompositeArtifactSet.of(allArtifactSets), resolvedArtifactsById);
    }

    private static class DefaultSelectedArtifactResults
    implements SelectedArtifactResults {
        private final ResolvedArtifactSet allArtifacts;
        private final Map<Long, ResolvedArtifactSet> resolvedArtifactsById;

        DefaultSelectedArtifactResults(ResolvedArtifactSet allArtifacts, Map<Long, ResolvedArtifactSet> resolvedArtifactsById) {
            this.allArtifacts = allArtifacts;
            this.resolvedArtifactsById = resolvedArtifactsById;
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this.allArtifacts;
        }

        @Override
        public ResolvedArtifactSet getArtifacts(long id) {
            return this.resolvedArtifactsById.get(id);
        }
    }
}

