/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributeValue;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.attributes.CompatibilityRuleChainInternal;
import org.gradle.api.internal.attributes.DisambiguationRuleChainInternal;
import org.gradle.internal.Cast;

public class ComponentAttributeMatcher {
    private final AttributesSchema consumerAttributeSchema;
    private final AttributesSchema producerAttributeSchema;
    private final Map<HasAttributes, MatchDetails> matchDetails = Maps.newHashMap();
    private final AttributeContainer consumerAttributesContainer;
    private final AttributeContainer attributesToConsider;

    public ComponentAttributeMatcher(AttributesSchema consumerAttributeSchema, AttributesSchema producerAttributeSchema, Iterable<HasAttributes> candidates, AttributeContainer consumerAttributesContainer, AttributeContainer attributesToConsider) {
        this.consumerAttributeSchema = consumerAttributeSchema;
        this.producerAttributeSchema = producerAttributeSchema;
        for (HasAttributes cand : candidates) {
            if (cand.getAttributes().isEmpty()) continue;
            this.matchDetails.put(cand, new MatchDetails());
        }
        this.consumerAttributesContainer = consumerAttributesContainer;
        this.attributesToConsider = attributesToConsider;
        this.doMatch();
    }

    private void doMatch() {
        Set requestedAttributes = (Set)Cast.uncheckedCast((Object)this.consumerAttributesContainer.keySet());
        for (Map.Entry<HasAttributes, MatchDetails> entry : this.matchDetails.entrySet()) {
            HasAttributes key = entry.getKey();
            MatchDetails details = entry.getValue();
            AttributeContainer producerAttributesContainer = key.getAttributes();
            Set dependencyAttributes = (Set)Cast.uncheckedCast((Object)producerAttributesContainer.keySet());
            Set filter = (Set)Cast.uncheckedCast(this.attributesToConsider != null ? this.attributesToConsider.keySet() : null);
            Set allAttributes = filter != null ? filter : Sets.union((Set)requestedAttributes, (Set)dependencyAttributes);
            for (Attribute attribute : allAttributes) {
                AttributeValue<Object> consumerValue = ComponentAttributeMatcher.attributeValue((Attribute<Object>)attribute, this.consumerAttributeSchema, this.consumerAttributesContainer);
                AttributeValue<Object> producerValue = ComponentAttributeMatcher.attributeValue((Attribute<Object>)attribute, this.producerAttributeSchema, producerAttributesContainer);
                details.update((Attribute<Object>)attribute, this.consumerAttributeSchema, this.producerAttributeSchema, (AttributeValue<Object>)consumerValue, (AttributeValue<Object>)producerValue);
            }
        }
    }

    private static AttributeValue<Object> attributeValue(Attribute<Object> attribute, AttributesSchema schema, AttributeContainer container) {
        AttributeValue attributeValue = schema.hasAttribute(attribute) ? (container.contains(attribute) ? AttributeValue.of((Object)container.getAttribute(attribute)) : AttributeValue.missing()) : AttributeValue.unknown();
        return attributeValue;
    }

    public List<? extends HasAttributes> getMatchs() {
        ArrayList<HasAttributes> matchs = new ArrayList<HasAttributes>(1);
        for (Map.Entry<HasAttributes, MatchDetails> entry : this.matchDetails.entrySet()) {
            MatchDetails details = entry.getValue();
            if (!details.compatible) continue;
            matchs.add(entry.getKey());
        }
        return this.disambiguateUsingClosestMatch(matchs);
    }

    private List<HasAttributes> disambiguateUsingClosestMatch(List<HasAttributes> matchs) {
        List<HasAttributes> remainingMatches;
        if (matchs.size() > 1 && (remainingMatches = this.selectClosestMatches(matchs)) != null) {
            return this.disambiguateUsingProducerSchema(remainingMatches);
        }
        return matchs;
    }

    private List<HasAttributes> disambiguateUsingProducerSchema(List<HasAttributes> matchs) {
        if (matchs.size() < 2 || this.producerAttributeSchema == null) {
            return matchs;
        }
        HashSet producerOnlyAttributes = Sets.newHashSet();
        for (HasAttributes match : matchs) {
            AttributeContainer attributes = match.getAttributes();
            for (Attribute attribute : attributes.keySet()) {
                if (this.consumerAttributesContainer.contains(attribute)) continue;
                producerOnlyAttributes.add(attribute);
            }
        }
        Set consumerAttributes = this.consumerAttributeSchema.getAttributes();
        ArrayList remainingMatches = Lists.newArrayList(matchs);
        ArrayList best = Lists.newArrayListWithCapacity((int)matchs.size());
        ArrayListMultimap candidatesByValue = ArrayListMultimap.create();
        for (Attribute attribute : producerOnlyAttributes) {
            for (HasAttributes match : matchs) {
                Object maybeProvided = match.getAttributes().getAttribute(attribute);
                if (maybeProvided == null) continue;
                candidatesByValue.put((Object)AttributeValue.of((Object)maybeProvided), (Object)match);
            }
            if (candidatesByValue.isEmpty()) continue;
            AttributeValue absent = consumerAttributes.contains(attribute) ? AttributeValue.missing() : AttributeValue.unknown();
            ComponentAttributeMatcher.disambiguate(remainingMatches, (ListMultimap<AttributeValue<Object>, HasAttributes>)candidatesByValue, (AttributeValue<Object>)absent, this.producerAttributeSchema.getMatchingStrategy(attribute), best);
            if (remainingMatches.isEmpty()) {
                return matchs;
            }
            candidatesByValue.clear();
            best.clear();
        }
        if (!remainingMatches.isEmpty()) {
            return remainingMatches;
        }
        return matchs;
    }

    private List<HasAttributes> selectClosestMatches(List<HasAttributes> fullMatches) {
        Set requestedAttributes = this.consumerAttributesContainer.keySet();
        ArrayList remainingMatches = Lists.newArrayList(fullMatches);
        ArrayList best = Lists.newArrayListWithCapacity((int)fullMatches.size());
        ArrayListMultimap candidatesByValue = ArrayListMultimap.create();
        for (Attribute attribute : requestedAttributes) {
            Object requestedValue = this.consumerAttributesContainer.getAttribute(attribute);
            for (HasAttributes match : fullMatches) {
                Map matchedAttributes = this.matchDetails.get(match).matchesByAttribute;
                candidatesByValue.put(matchedAttributes.get(attribute), (Object)match);
            }
            AttributeValue requested = AttributeValue.of((Object)requestedValue);
            ComponentAttributeMatcher.disambiguate(remainingMatches, (ListMultimap<AttributeValue<Object>, HasAttributes>)candidatesByValue, (AttributeValue<Object>)requested, this.consumerAttributeSchema.getMatchingStrategy(attribute), best);
            if (remainingMatches.isEmpty()) {
                return fullMatches;
            }
            candidatesByValue.clear();
            best.clear();
        }
        if (!remainingMatches.isEmpty()) {
            return remainingMatches;
        }
        return null;
    }

    private static void disambiguate(List<HasAttributes> remainingMatches, ListMultimap<AttributeValue<Object>, HasAttributes> candidatesByValue, AttributeValue<Object> requested, AttributeMatchingStrategy<?> matchingStrategy, List<HasAttributes> best) {
        AttributeMatchingStrategy ms = (AttributeMatchingStrategy)Cast.uncheckedCast(matchingStrategy);
        CandidateDetails details = new CandidateDetails(requested, candidatesByValue, best);
        DisambiguationRuleChainInternal disambiguationRules = (DisambiguationRuleChainInternal)ms.getDisambiguationRules();
        disambiguationRules.execute((Object)details);
        remainingMatches.retainAll(best);
    }

    private static class CandidateDetails
    implements MultipleCandidatesDetails<Object> {
        private final AttributeValue<Object> consumerValue;
        private final ListMultimap<AttributeValue<Object>, HasAttributes> candidatesByValue;
        private final List<HasAttributes> best;

        public CandidateDetails(AttributeValue<Object> consumerValue, ListMultimap<AttributeValue<Object>, HasAttributes> candidatesByValue, List<HasAttributes> best) {
            this.consumerValue = consumerValue;
            this.candidatesByValue = candidatesByValue;
            this.best = best;
        }

        public AttributeValue<Object> getConsumerValue() {
            return this.consumerValue;
        }

        public Set<AttributeValue<Object>> getCandidateValues() {
            return this.candidatesByValue.keySet();
        }

        public void closestMatch(AttributeValue<Object> candidate) {
            List hasAttributes = this.candidatesByValue.get(candidate);
            for (HasAttributes attributes : hasAttributes) {
                this.best.add(attributes);
            }
        }
    }

    private static class MatchDetails {
        private final Map<Attribute<Object>, AttributeValue<Object>> matchesByAttribute = Maps.newHashMap();
        private boolean compatible = true;

        private MatchDetails() {
        }

        private void update(final Attribute<Object> attribute, AttributesSchema consumerSchema, AttributesSchema producerSchema, final AttributeValue<Object> consumerValue, final AttributeValue<Object> producerValue) {
            AttributesSchema schemaToUse = consumerSchema;
            if (consumerValue.isUnknown() || consumerValue.isMissing()) {
                schemaToUse = producerSchema;
            }
            CompatibilityCheckDetails<Object> details = new CompatibilityCheckDetails<Object>(){

                public AttributeValue<Object> getConsumerValue() {
                    return consumerValue;
                }

                public AttributeValue<Object> getProducerValue() {
                    return producerValue;
                }

                public void compatible() {
                    MatchDetails.this.matchesByAttribute.put(attribute, producerValue);
                }

                public void incompatible() {
                    MatchDetails.this.compatible = false;
                }
            };
            AttributeMatchingStrategy strategy = schemaToUse.getMatchingStrategy(attribute);
            CompatibilityRuleChainInternal compatibilityRules = (CompatibilityRuleChainInternal)strategy.getCompatibilityRules();
            try {
                compatibilityRules.execute((Object)details);
            }
            catch (Exception ex) {
                throw new GradleException("Unexpected error thrown when trying to match attribute values with " + strategy, (Throwable)ex);
            }
        }
    }
}

