/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiledEvaluator;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiler;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.jvm.repl.GenericRepl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u001a,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"logger", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "compileAndEval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "replCompiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "replCompiledEvaluator", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiledEvaluator;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "history", "", "kotlin-compiler"})
public final class GenericReplKt {
    private static final Logger logger = Logger.getInstance(GenericRepl.class);

    @NotNull
    public static final ReplEvalResult compileAndEval(@NotNull ReplCompiler replCompiler2, @NotNull ReplCompiledEvaluator replCompiledEvaluator, @NotNull ReplCodeLine codeLine, @NotNull Iterable<ReplCodeLine> history) {
        ReplEvalResult replEvalResult;
        ReplCompileResult it;
        Intrinsics.checkParameterIsNotNull(replCompiler2, "replCompiler");
        Intrinsics.checkParameterIsNotNull(replCompiledEvaluator, "replCompiledEvaluator");
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        Intrinsics.checkParameterIsNotNull(history, "history");
        ReplCompileResult replCompileResult = replCompiler2.compile(codeLine, history);
        ReplCompileResult replCompileResult2 = it = replCompileResult;
        if (Intrinsics.areEqual(replCompileResult2, ReplCompileResult.Incomplete.INSTANCE)) {
            replEvalResult = ReplEvalResult.Incomplete.INSTANCE;
        } else if (replCompileResult2 instanceof ReplCompileResult.HistoryMismatch) {
            replEvalResult = new ReplEvalResult.HistoryMismatch(((ReplCompileResult.HistoryMismatch)it).getLineNo());
        } else if (replCompileResult2 instanceof ReplCompileResult.Error) {
            replEvalResult = new ReplEvalResult.Error.CompileTime(((ReplCompileResult.Error)it).getMessage(), ((ReplCompileResult.Error)it).getLocation());
        } else if (replCompileResult2 instanceof ReplCompileResult.CompiledClasses) {
            replEvalResult = replCompiledEvaluator.eval(codeLine, history, ((ReplCompileResult.CompiledClasses)it).getClasses(), ((ReplCompileResult.CompiledClasses)it).getHasResult(), ((ReplCompileResult.CompiledClasses)it).getNewClasspath());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return replEvalResult;
    }
}

