/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.MutableClassDescriptor;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public class JvmRuntimeTypes {
    private final ClassDescriptor lambda;
    private final ClassDescriptor functionReference;
    private final List<ClassDescriptor> propertyReferences;
    private final List<ClassDescriptor> mutablePropertyReferences;
    private final ClassDescriptor localVariableReference;
    private final ClassDescriptor mutableLocalVariableReference;
    private final KotlinType defaultContinuationSupertype;

    public JvmRuntimeTypes(@NotNull ModuleDescriptor module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "<init>"));
        }
        MutablePackageFragmentDescriptor kotlinJvmInternal = new MutablePackageFragmentDescriptor(module, new FqName("kotlin.jvm.internal"));
        this.lambda = JvmRuntimeTypes.createClass(kotlinJvmInternal, "Lambda");
        this.functionReference = JvmRuntimeTypes.createClass(kotlinJvmInternal, "FunctionReference");
        this.localVariableReference = JvmRuntimeTypes.createClass(kotlinJvmInternal, "LocalVariableReference");
        this.mutableLocalVariableReference = JvmRuntimeTypes.createClass(kotlinJvmInternal, "MutableLocalVariableReference");
        this.propertyReferences = new ArrayList<ClassDescriptor>(3);
        this.mutablePropertyReferences = new ArrayList<ClassDescriptor>(3);
        for (int i = 0; i <= 2; ++i) {
            this.propertyReferences.add(JvmRuntimeTypes.createClass(kotlinJvmInternal, "PropertyReference" + i));
            this.mutablePropertyReferences.add(JvmRuntimeTypes.createClass(kotlinJvmInternal, "MutablePropertyReference" + i));
        }
        this.defaultContinuationSupertype = JvmRuntimeTypes.createNullableAnyContinuation(module);
    }

    @NotNull
    private static KotlinType createNullableAnyContinuation(@NotNull ModuleDescriptor module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createNullableAnyContinuation"));
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.resolveTopLevelClass(module, DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME, NoLookupLocation.FROM_BACKEND);
        assert (classDescriptor != null) : DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME + " was not found in built-ins";
        KotlinType kotlinType = TypeConstructorSubstitution.createByParametersMap(Collections.singletonMap(classDescriptor.getDeclaredTypeParameters().get(0), new TypeProjectionImpl(module.getBuiltIns().getNullableAnyType()))).buildSubstitutor().substitute(classDescriptor.getDefaultType(), Variance.INVARIANT);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createNullableAnyContinuation"));
        }
        return kotlinType;
    }

    @NotNull
    private static ClassDescriptor createClass(@NotNull PackageFragmentDescriptor packageFragment, @NotNull String name2) {
        if (packageFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragment", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        MutableClassDescriptor descriptor2 = new MutableClassDescriptor(packageFragment, ClassKind.CLASS, false, Name.identifier(name2), SourceElement.NO_SOURCE);
        descriptor2.setModality(Modality.FINAL);
        descriptor2.setVisibility(Visibilities.PUBLIC);
        descriptor2.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        descriptor2.createTypeConstructor();
        MutableClassDescriptor mutableClassDescriptor = descriptor2;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        return mutableClassDescriptor;
    }

    @NotNull
    public Collection<KotlinType> getSupertypesForClosure(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForClosure"));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        SimpleType functionType = FunctionTypeResolveUtilsKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(descriptor2), Annotations.Companion.getEMPTY(), receiverParameter == null ? null : receiverParameter.getType(), ExpressionTypingUtils.getValueParametersTypes(parameters2), null, descriptor2.getReturnType());
        KotlinType coroutineControllerType = CoroutineUtilKt.getControllerTypeIfCoroutine(descriptor2);
        if (coroutineControllerType != null) {
            List<KotlinType> list2 = Arrays.asList(this.lambda.getDefaultType(), functionType, this.defaultContinuationSupertype);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForClosure"));
            }
            return list2;
        }
        List<KotlinType> list3 = Arrays.asList(this.lambda.getDefaultType(), functionType);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForClosure"));
        }
        return list3;
    }

    @NotNull
    public Collection<KotlinType> getSupertypesForFunctionReference(@NotNull FunctionDescriptor descriptor2, boolean isBound) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForFunctionReference"));
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor2.getExtensionReceiverParameter();
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        KotlinType receiverType = extensionReceiver2 != null ? extensionReceiver2.getType() : (dispatchReceiver != null ? dispatchReceiver.getType() : null);
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        SimpleType functionType = FunctionTypeResolveUtilsKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(descriptor2), Annotations.Companion.getEMPTY(), isBound ? null : receiverType, ExpressionTypingUtils.getValueParametersTypes(parameters2), null, descriptor2.getReturnType());
        List<KotlinType> list2 = Arrays.asList(this.functionReference.getDefaultType(), functionType);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForFunctionReference"));
        }
        return list2;
    }

    @NotNull
    public KotlinType getSupertypeForPropertyReference(@NotNull VariableDescriptorWithAccessors descriptor2, boolean isMutable, boolean isBound) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypeForPropertyReference"));
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            SimpleType simpleType2 = (isMutable ? this.mutableLocalVariableReference : this.localVariableReference).getDefaultType();
            if (simpleType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypeForPropertyReference"));
            }
            return simpleType2;
        }
        int arity = (descriptor2.getExtensionReceiverParameter() != null ? 1 : 0) + (descriptor2.getDispatchReceiverParameter() != null ? 1 : 0) - (isBound ? 1 : 0);
        SimpleType simpleType3 = (isMutable ? this.mutablePropertyReferences : this.propertyReferences).get(arity).getDefaultType();
        if (simpleType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypeForPropertyReference"));
        }
        return simpleType3;
    }
}

