/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import java.io.File;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.util.PathUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class LibrarySourcesConfig
extends JsConfig {
    public static final List<String> JS_STDLIB = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    public static final Key<String> EXTERNAL_MODULE_NAME = Key.create("externalModule");
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";

    public LibrarySourcesConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        super(project, configuration);
    }

    @NotNull
    public List<String> getLibraries() {
        List<String> list2 = this.getConfiguration().getList(JSConfigurationKeys.LIBRARY_FILES);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "getLibraries"));
        }
        return list2;
    }

    @Override
    protected void init(final @NotNull List<KtFile> sourceFilesInLibraries, final @NotNull List<KotlinJavascriptMetadata> metadata) {
        if (sourceFilesInLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilesInLibraries", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "init"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "init"));
        }
        if (this.getLibraries().isEmpty()) {
            return;
        }
        final PsiManager psiManager = PsiManager.getInstance(this.getProject());
        Function1<String, Unit> report2 = new Function1<String, Unit>(){

            @Override
            public Unit invoke(String message) {
                throw new IllegalStateException(message);
            }
        };
        Function2<String, VirtualFile, Unit> action = new Function2<String, VirtualFile, Unit>(){

            @Override
            public Unit invoke(String moduleName, VirtualFile file2) {
                if (moduleName != null) {
                    JetFileCollector jetFileCollector = new JetFileCollector(sourceFilesInLibraries, moduleName, psiManager);
                    VfsUtilCore.visitChildrenRecursively(file2, jetFileCollector);
                } else {
                    String libraryPath = PathUtil.getLocalPath(file2);
                    assert (libraryPath != null) : "libraryPath for " + file2 + " should not be null";
                    metadata.addAll(KotlinJavascriptMetadataUtils.loadMetadata(libraryPath));
                }
                return Unit.INSTANCE;
            }
        };
        boolean hasErrors = this.checkLibFilesAndReportErrors(report2, action);
        assert (!hasErrors) : "hasErrors should be false";
    }

    @Override
    public boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> report2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        return this.checkLibFilesAndReportErrors(report2, null);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> report2, @Nullable Function2<String, VirtualFile, Unit> action) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        List<String> libraries = this.getLibraries();
        if (libraries.isEmpty()) {
            return false;
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        for (String path : libraries) {
            String moduleName;
            File filePath = new File(path);
            if (!filePath.exists()) {
                report2.invoke("Path '" + path + "' does not exist");
                return true;
            }
            VirtualFile file2 = path.endsWith(".jar") || path.endsWith(".zip") ? jarFileSystem.findFileByPath(path + "!/") : fileSystem.findFileByPath(path);
            if (file2 == null) {
                report2.invoke("File '" + path + "' does not exist or could not be read");
                return true;
            }
            if (LibraryUtils.isOldKotlinJavascriptLibrary(filePath)) {
                moduleName = LibraryUtils.getKotlinJsModuleName(filePath);
            } else {
                List<KotlinJavascriptMetadata> metadataList = KotlinJavascriptMetadataUtils.loadMetadata(filePath);
                if (metadataList.isEmpty()) {
                    report2.invoke("'" + path + "' is not a valid Kotlin Javascript library");
                    return true;
                }
                for (KotlinJavascriptMetadata metadata : metadataList) {
                    if (metadata.isAbiVersionCompatible()) continue;
                    report2.invoke("File '" + path + "' was compiled with an incompatible version of Kotlin. " + "Its ABI version is " + metadata.getAbiVersion() + ", expected ABI version is " + KotlinJavascriptMetadataUtils.ABI_VERSION);
                    return true;
                }
                moduleName = null;
            }
            if (action == null) continue;
            action.invoke(moduleName, file2);
        }
        return false;
    }

    private static KtFile getJetFileByVirtualFile(VirtualFile file2, String moduleName, PsiManager psiManager) {
        PsiFile psiFile = psiManager.findFile(file2);
        assert (psiFile != null);
        LibrarySourcesConfig.setupPsiFile(psiFile, moduleName);
        return (KtFile)psiFile;
    }

    private static void setupPsiFile(PsiFile psiFile, String moduleName) {
        psiFile.putUserData(EXTERNAL_MODULE_NAME, moduleName);
    }

    private static class JetFileCollector
    extends VirtualFileVisitor {
        private final List<KtFile> jetFiles;
        private final String moduleName;
        private final PsiManager psiManager;

        private JetFileCollector(List<KtFile> files, String name2, PsiManager manager) {
            super(new VirtualFileVisitor.Option[0]);
            this.moduleName = name2;
            this.psiManager = manager;
            this.jetFiles = files;
        }

        @Override
        public boolean visitFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$JetFileCollector", "visitFile"));
            }
            if (!file2.isDirectory() && StringUtil.notNullize(file2.getExtension()).equalsIgnoreCase("kt")) {
                this.jetFiles.add(LibrarySourcesConfig.getJetFileByVirtualFile(file2, this.moduleName, this.psiManager));
            }
            return true;
        }
    }
}

