/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;

public class UndoManager {
    private JEditBuffer buffer;
    private Edit undosFirst;
    private Edit undosLast;
    private Edit redosFirst;
    private int limit;
    private int undoCount;
    private int compoundEditCount;
    private CompoundEdit compoundEdit;
    private Edit undoClearDirty;
    private Edit redoClearDirty;
    private Object undoId;

    public UndoManager(JEditBuffer jEditBuffer) {
        this.buffer = jEditBuffer;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void clear() {
        this.redosFirst = null;
        this.undosLast = null;
        this.undosFirst = null;
        this.undoCount = 0;
    }

    public boolean canUndo() {
        return this.undosLast != null;
    }

    public Selection[] undo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.undosLast == null) {
            return null;
        }
        this.reviseUndoId();
        --this.undoCount;
        Selection[] selectionArray = this.undosLast.undo(this);
        this.redosFirst = this.undosLast;
        this.undosLast = this.undosLast.prev;
        if (this.undosLast == null) {
            this.undosFirst = null;
        }
        return selectionArray;
    }

    public boolean canRedo() {
        return this.redosFirst != null;
    }

    public Selection[] redo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.redosFirst == null) {
            return null;
        }
        this.reviseUndoId();
        ++this.undoCount;
        Selection[] selectionArray = this.redosFirst.redo(this);
        this.undosLast = this.redosFirst;
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast;
        }
        this.redosFirst = this.redosFirst.next;
        return selectionArray;
    }

    public void beginCompoundEdit() {
        if (this.compoundEditCount == 0) {
            this.compoundEdit = new CompoundEdit();
            this.reviseUndoId();
        }
        ++this.compoundEditCount;
    }

    public void endCompoundEdit() {
        if (this.compoundEditCount == 0) {
            Log.log(7, this, new Exception("Unbalanced begin/endCompoundEdit()"));
            return;
        }
        if (this.compoundEditCount == 1) {
            if (this.compoundEdit.first != null) {
                if (this.compoundEdit.first == this.compoundEdit.last) {
                    this.addEdit(this.compoundEdit.first);
                } else {
                    this.addEdit(this.compoundEdit);
                }
            }
            this.compoundEdit = null;
        }
        --this.compoundEditCount;
    }

    public boolean insideCompoundEdit() {
        return this.compoundEditCount != 0;
    }

    public Object getUndoId() {
        return this.undoId;
    }

    public void contentInserted(int n, int n2, String string, boolean bl) {
        Insert insert;
        Edit edit = this.getMergeEdit();
        if (!bl && edit instanceof Insert && this.redosFirst == null) {
            insert = (Insert)edit;
            if (insert.offset == n) {
                insert.str = string.concat(insert.str);
                return;
            }
            if (insert.offset + insert.str.length() == n) {
                insert.str = insert.str.concat(string);
                return;
            }
        }
        insert = new Insert(n, string);
        if (bl) {
            this.redoClearDirty = this.getLastEdit();
            this.undoClearDirty = insert;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(this, insert);
        } else {
            this.reviseUndoId();
            this.addEdit(insert);
        }
    }

    public void contentRemoved(int n, int n2, String string, boolean bl) {
        Remove remove;
        Edit edit = this.getMergeEdit();
        if (!bl && edit instanceof Remove && this.redosFirst == null) {
            remove = (Remove)edit;
            if (remove.offset == n) {
                String string2 = remove.str.concat(string);
                KillRing.getInstance().changed(remove.str, string2);
                remove.str = string2;
                return;
            }
            if (n + n2 == remove.offset) {
                String string3 = string.concat(remove.str);
                KillRing.getInstance().changed(remove.str, string3);
                remove.offset = n;
                remove.str = string3;
                return;
            }
        }
        remove = new Remove(n, string.intern());
        if (bl) {
            this.redoClearDirty = this.getLastEdit();
            this.undoClearDirty = remove;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(this, remove);
        } else {
            this.reviseUndoId();
            this.addEdit(remove);
        }
        KillRing.getInstance().add(remove.str);
    }

    public void resetClearDirty() {
        this.redoClearDirty = this.getLastEdit();
        this.undoClearDirty = this.redosFirst instanceof CompoundEdit ? ((CompoundEdit)this.redosFirst).first : this.redosFirst;
    }

    private void addEdit(Edit edit) {
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast = edit;
        } else {
            this.undosLast.next = edit;
            edit.prev = this.undosLast;
            this.undosLast = edit;
        }
        this.redosFirst = null;
        ++this.undoCount;
        while (this.undoCount > this.limit) {
            --this.undoCount;
            if (this.undosFirst == this.undosLast) {
                this.undosLast = null;
                this.undosFirst = null;
                continue;
            }
            this.undosFirst.next.prev = null;
            this.undosFirst = this.undosFirst.next;
        }
    }

    private Edit getMergeEdit() {
        return this.compoundEdit != null ? this.compoundEdit.last : this.getLastEdit();
    }

    private Edit getLastEdit() {
        if (this.undosLast instanceof CompoundEdit) {
            return ((CompoundEdit)this.undosLast).last;
        }
        return this.undosLast;
    }

    private void reviseUndoId() {
        this.undoId = new Object();
    }

    private Replace getReplaceFromRemoveInsert(Edit edit, Edit edit2) {
        if (edit instanceof Remove && edit2 instanceof Insert) {
            if (edit == this.undoClearDirty || edit2 == this.undoClearDirty) {
                return null;
            }
            assert (edit2 != this.redoClearDirty);
            assert (edit != this.redoClearDirty);
            Remove remove = (Remove)edit;
            Insert insert = (Insert)edit2;
            if (remove.offset == insert.offset) {
                return new Replace(remove.offset, remove.str, insert.str);
            }
        }
        return null;
    }

    private CompressedReplace getCompressedReplaceFromReplaceReplace(Edit edit, Edit edit2) {
        if (edit2 instanceof Replace) {
            CompressedReplace compressedReplace = null;
            if (edit instanceof CompressedReplace) {
                compressedReplace = (CompressedReplace)edit;
                return compressedReplace.add((Replace)edit2);
            }
            if (edit instanceof Replace) {
                compressedReplace = new CompressedReplace((Replace)edit);
                return compressedReplace.add((Replace)edit2);
            }
        }
        return null;
    }

    private static class CompoundEdit
    extends Edit {
        Edit first;
        Edit last;

        private CompoundEdit() {
        }

        @Override
        public Selection[] undo(UndoManager undoManager) {
            Selection[] selectionArray = null;
            Edit edit = this.last;
            while (edit != null) {
                selectionArray = edit.undo(undoManager);
                edit = edit.prev;
            }
            return selectionArray;
        }

        @Override
        public Selection[] redo(UndoManager undoManager) {
            Selection[] selectionArray = null;
            Edit edit = this.first;
            while (edit != null) {
                selectionArray = edit.redo(undoManager);
                edit = edit.next;
            }
            return selectionArray;
        }

        private void _add(Edit edit) {
            if (this.first == null) {
                this.first = this.last = edit;
            } else {
                edit.prev = this.last;
                this.last.next = edit;
                this.last = edit;
            }
        }

        public void add(UndoManager undoManager, Edit edit) {
            Replace replace;
            this._add(edit);
            if (this.last.prev != null && (replace = undoManager.getReplaceFromRemoveInsert(this.last.prev, this.last)) != null) {
                this.exchangeLastElement(replace);
            }
            if (this.last.prev != null && (replace = undoManager.getCompressedReplaceFromReplaceReplace(this.last.prev, this.last)) != null) {
                this.exchangeLastElement(replace);
            }
            if (this.last.prev != null && (replace = undoManager.getCompressedReplaceFromReplaceReplace(this.last.prev, this.last)) != null) {
                this.exchangeLastElement(replace);
            }
        }

        private void exchangeLastElement(Edit edit) {
            if (this.first == this.last) {
                this.last = null;
                this.first = null;
            } else {
                this.last.prev.next = null;
                this.last = this.last.prev;
            }
            if (this.first == null || this.first == this.last) {
                this.first = this.last = edit;
            } else {
                edit.prev = this.last.prev;
                this.last.prev.next = edit;
                this.last = edit;
            }
        }
    }

    private static class CompressedReplace
    extends Replace {
        IntegerArray offsets = new IntegerArray(4);

        CompressedReplace(Replace replace) {
            super(replace.offset, replace.strRemove, replace.strInsert);
            this.offsets.add(replace.offset);
        }

        CompressedReplace add(Replace replace) {
            if (this.strInsert.equals(replace.strInsert) && this.strRemove.equals(replace.strRemove)) {
                this.offsets.add(replace.offset);
                return this;
            }
            return null;
        }

        @Override
        Selection[] undo(UndoManager undoManager) {
            Selection[] selectionArray = null;
            for (int i = this.offsets.getSize() - 1; i >= 0; --i) {
                this.offset = this.offsets.get(i);
                selectionArray = super.undo(undoManager);
            }
            return selectionArray;
        }

        @Override
        Selection[] redo(UndoManager undoManager) {
            Selection[] selectionArray = null;
            for (int i = 0; i < this.offsets.getSize(); ++i) {
                this.offset = this.offsets.get(i);
                selectionArray = super.redo(undoManager);
            }
            return selectionArray;
        }
    }

    private static class Replace
    extends Edit {
        int offset;
        String strRemove;
        String strInsert;

        Replace(int n, String string, String string2) {
            this.offset = n;
            this.strRemove = string;
            this.strInsert = string2;
        }

        @Override
        Selection[] undo(UndoManager undoManager) {
            undoManager.buffer.remove(this.offset, this.strInsert.length());
            undoManager.buffer.insert(this.offset, this.strRemove);
            assert (undoManager.undoClearDirty != this);
            return new Selection[]{new Selection.Range(this.offset, this.offset + this.strRemove.length())};
        }

        @Override
        Selection[] redo(UndoManager undoManager) {
            undoManager.buffer.remove(this.offset, this.strRemove.length());
            undoManager.buffer.insert(this.offset, this.strInsert);
            if (undoManager.redoClearDirty == this) {
                undoManager.buffer.setDirty(false);
            }
            int n = this.offset + this.strInsert.length();
            return new Selection[]{new Selection.Range(n, n)};
        }
    }

    private static class Remove
    extends Edit {
        int offset;
        String str;

        Remove(int n, String string) {
            this.offset = n;
            this.str = string;
        }

        @Override
        Selection[] undo(UndoManager undoManager) {
            undoManager.buffer.insert(this.offset, this.str);
            if (undoManager.undoClearDirty == this) {
                undoManager.buffer.setDirty(false);
            }
            return new Selection[]{new Selection.Range(this.offset, this.offset + this.str.length())};
        }

        @Override
        Selection[] redo(UndoManager undoManager) {
            undoManager.buffer.remove(this.offset, this.str.length());
            if (undoManager.redoClearDirty == this) {
                undoManager.buffer.setDirty(false);
            }
            return new Selection[]{new Selection.Range(this.offset, this.offset)};
        }
    }

    private static class Insert
    extends Edit {
        int offset;
        String str;

        Insert(int n, String string) {
            this.offset = n;
            this.str = string;
        }

        @Override
        Selection[] undo(UndoManager undoManager) {
            undoManager.buffer.remove(this.offset, this.str.length());
            if (undoManager.undoClearDirty == this) {
                undoManager.buffer.setDirty(false);
            }
            return new Selection[]{new Selection.Range(this.offset, this.offset)};
        }

        @Override
        Selection[] redo(UndoManager undoManager) {
            undoManager.buffer.insert(this.offset, this.str);
            if (undoManager.redoClearDirty == this) {
                undoManager.buffer.setDirty(false);
            }
            int n = this.offset + this.str.length();
            return new Selection[]{new Selection.Range(n, n)};
        }
    }

    private static abstract class Edit {
        Edit prev;
        Edit next;

        private Edit() {
        }

        abstract Selection[] undo(UndoManager var1);

        abstract Selection[] redo(UndoManager var1);
    }
}

