/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Objects;
import org.openstreetmap.josm.gui.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.gui.io.UploadStrategy;

public class UploadStrategySpecification {
    public static final int UNSPECIFIED_CHUNK_SIZE = -1;
    private UploadStrategy strategy;
    private int chunkSize;
    private MaxChangesetSizeExceededPolicy policy;
    private boolean closeChangesetAfterUpload;

    public UploadStrategySpecification() {
        this.strategy = UploadStrategy.DEFAULT_UPLOAD_STRATEGY;
        this.chunkSize = -1;
        this.policy = null;
        this.closeChangesetAfterUpload = true;
    }

    public UploadStrategySpecification(UploadStrategySpecification uploadStrategySpecification) {
        if (uploadStrategySpecification != null) {
            this.strategy = uploadStrategySpecification.strategy;
            this.chunkSize = uploadStrategySpecification.chunkSize;
            this.policy = uploadStrategySpecification.policy;
            this.closeChangesetAfterUpload = uploadStrategySpecification.closeChangesetAfterUpload;
        }
    }

    public UploadStrategy getStrategy() {
        return this.strategy;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public static int getUnspecifiedChunkSize() {
        return -1;
    }

    public MaxChangesetSizeExceededPolicy getPolicy() {
        return this.policy;
    }

    public UploadStrategySpecification setStrategy(UploadStrategy uploadStrategy) {
        this.strategy = uploadStrategy;
        return this;
    }

    public UploadStrategySpecification setChunkSize(int n) {
        this.chunkSize = n;
        return this;
    }

    public UploadStrategySpecification setPolicy(MaxChangesetSizeExceededPolicy maxChangesetSizeExceededPolicy) {
        this.policy = maxChangesetSizeExceededPolicy;
        return this;
    }

    public UploadStrategySpecification setCloseChangesetAfterUpload(boolean bl) {
        this.closeChangesetAfterUpload = bl;
        return this;
    }

    public boolean isCloseChangesetAfterUpload() {
        return this.closeChangesetAfterUpload;
    }

    public int getNumRequests(int n) {
        if (n <= 0) {
            return 0;
        }
        switch (this.strategy) {
            case INDIVIDUAL_OBJECTS_STRATEGY: {
                return n;
            }
            case SINGLE_REQUEST_STRATEGY: {
                return 1;
            }
            case CHUNKED_DATASET_STRATEGY: {
                if (this.chunkSize == -1) {
                    return 0;
                }
                return (int)Math.ceil((double)n / (double)this.chunkSize);
            }
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.strategy, this.chunkSize, this.policy, this.closeChangesetAfterUpload});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UploadStrategySpecification uploadStrategySpecification = (UploadStrategySpecification)object;
        return this.chunkSize == uploadStrategySpecification.chunkSize && this.closeChangesetAfterUpload == uploadStrategySpecification.closeChangesetAfterUpload && this.strategy == uploadStrategySpecification.strategy && this.policy == uploadStrategySpecification.policy;
    }
}

