/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class JLifeFormattedTextField
extends JFormattedTextField {
    private Object value;
    private DocumentHandler documentHandler;
    private int updatingDepth;

    @Override
    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        super.setDocument(document);
        if (this.documentHandler == null) {
            this.documentHandler = new DocumentHandler();
        }
        if (document2 != null) {
            document2.removeDocumentListener(this.documentHandler);
        }
        if (document != null) {
            document.addDocumentListener(this.documentHandler);
        }
        this.updateValue();
    }

    @Override
    public void setValue(Object object) {
        Object object2 = this.value;
        if (object2 != null && object != null && object2.equals(object)) {
            return;
        }
        if (object != null && this.getFormatterFactory() == null) {
            this.setFormatterFactory(this.getDefaultFormatterFactory(object));
        }
        this.value = object;
        this.firePropertyChange("value", object2, object);
        this.updateText();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    protected void updateValue() {
        if (this.updatingDepth++ == 0 && this.getFormatter() != null) {
            try {
                Object object = this.getFormatter().stringToValue(this.getText());
                this.setValue(object);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        --this.updatingDepth;
    }

    protected void updateText() {
        if (this.updatingDepth++ == 0 && this.getFormatter() != null) {
            try {
                String string = this.getFormatter().valueToString(this.getValue());
                this.setText(string);
                if (!this.isFocusOwner()) {
                    this.setCaretPosition(this.getDocument().getLength());
                    this.moveCaretPosition(0);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        --this.updatingDepth;
    }

    private JFormattedTextField.AbstractFormatterFactory getDefaultFormatterFactory(Object object) {
        if (object instanceof DateFormat) {
            return new DefaultFormatterFactory(new DateFormatter((DateFormat)object));
        }
        if (object instanceof NumberFormat) {
            return new DefaultFormatterFactory(new NumberFormatter((NumberFormat)object));
        }
        if (object instanceof Format) {
            return new DefaultFormatterFactory(new InternationalFormatter((Format)object));
        }
        if (object instanceof Date) {
            return new DefaultFormatterFactory(new DateFormatter());
        }
        if (object instanceof Number) {
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setValueClass(object.getClass());
            NumberFormatter numberFormatter2 = new NumberFormatter(new DecimalFormat("#.#"));
            numberFormatter2.setValueClass(object.getClass());
            return new DefaultFormatterFactory(numberFormatter, numberFormatter, numberFormatter2);
        }
        return new DefaultFormatterFactory(new DefaultFormatter());
    }

    private void initComponents() {
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JLifeFormattedTextField.this.updateValue();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JLifeFormattedTextField.this.updateValue();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JLifeFormattedTextField.this.updateValue();
        }
    }
}

