/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DeclarationFactory;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMISchema;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class UML2Schema {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    private static void addToEntries(Data data, List list) {
        Object object;
        Namespace namespace = data.getXMINamespace();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (FileEntry)iterator.next();
            if (!((FileEntry)object).getNamespace().equals(namespace)) continue;
            if (!UML2Schema.isContained(data, ((FileEntry)object).getData())) {
                ((FileEntry)object).getData().add(data);
            }
            return;
        }
        object = new ArrayList();
        ((ArrayList)object).add(data);
        FileEntry fileEntry = new FileEntry(null, namespace, (Collection)object);
        list.add(fileEntry);
    }

    private static Collection getNamespaces(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            UML2Schema.processData(data, arrayList);
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isContained(Data var0, Collection var1_1) {
        if (!var1_1.contains(var0)) ** GOTO lbl6
        return true;
lbl-1000:
        // 1 sources

        {
            if (var1_1.contains(var0.getXMIOwner())) {
                return true;
            }
            var0 = var0.getXMIOwner();
lbl6:
            // 2 sources

            ** while (var0 != null && var0.getXMIOwner() != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 6) {
            System.out.println("");
            System.out.println("The following parameters are required: ");
            System.out.println("   -in        -- XMI file conforming to UML 1.1");
            System.out.println("   -version   -- XMI version, either 1.1 or 2.0");
            System.out.println("The following parameters identify the file or files to put the schemas in");
            System.out.println("   -out       -- Name of schema file");
            System.out.println("   -directory -- Output directory for schema files");
            System.out.println("The following parameters contain the namespaces to add to the model.");
            System.out.println("   -namespaces -- File containing the namespaces for the model");
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-in") && n + 1 < stringArray.length) {
                string = stringArray[++n];
            } else if (stringArray[n].equals("-out") && n + 1 < stringArray.length) {
                string2 = stringArray[++n];
            } else if (stringArray[n].equals("-version") && n + 1 < stringArray.length) {
                string3 = stringArray[++n];
            } else if (stringArray[n].equals("-directory") && n + 1 < stringArray.length) {
                string4 = stringArray[++n];
            } else if (stringArray[n].equals("-namespaces") && n + 1 < stringArray.length) {
                string5 = stringArray[++n];
            } else {
                System.out.println("Unknown option.....");
                return;
            }
            ++n;
        }
        if (string == null) {
            System.out.println("Must specify input UML XMI file.");
        }
        if (string == null) {
            return;
        }
        try {
            XMIFiles xMIFiles = new XMIFiles();
            XMIFile xMIFile = xMIFiles.load(string, 1, false);
            xMIFiles.loadAll();
            DeclarationFactory declarationFactory = new DeclarationFactory(string5);
            Collection collection = declarationFactory.makeDeclarations(xMIFiles.getContainer());
            Collection collection2 = UML2Schema.makeFileEntries(collection, string2, string4);
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                FileEntry fileEntry = (FileEntry)iterator.next();
                XMISchema xMISchema = new XMISchema(fileEntry.getFile());
                xMISchema.setTargetNamespace(fileEntry.getNamespace());
                if (string3 != null) {
                    xMISchema.setVersion(string3);
                }
                xMISchema.write(fileEntry.getData().iterator());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Collection makeFileEntries(Collection collection, String string, String string2) {
        Collection collection2 = UML2Schema.getNamespaces(collection);
        if (collection2.size() == 0) {
            String string3 = string;
            File file = new File(string);
            if (!file.isAbsolute() && string2 != null) {
                string3 = string2 + File.separator + string;
            }
            FileEntry fileEntry = new FileEntry(string3, null, collection);
            collection2.add(fileEntry);
        } else if (collection2.size() == 1) {
            String string4 = string;
            File file = new File(string);
            if (!file.isAbsolute() && string2 != null) {
                string4 = string2 + File.separator + string;
            }
            FileEntry fileEntry = (FileEntry)collection2.iterator().next();
            fileEntry.setFile(string4);
        } else {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                FileEntry fileEntry = (FileEntry)iterator.next();
                Data data = (Data)fileEntry.getData().iterator().next();
                String string5 = UML2Schema.stripNamespace(data.getXMIName()) + ".xsd";
                if (string2 != null) {
                    string5 = string2 + File.separator + string5;
                }
                fileEntry.setFile(string5);
            }
        }
        return collection2;
    }

    public static void processData(Data data, List list) {
        if (data.getXMINamespace() != null) {
            UML2Schema.addToEntries(data, list);
        }
        if (data instanceof Package) {
            Iterator iterator = ((Package)data).getXMIContents().iterator();
            while (iterator.hasNext()) {
                UML2Schema.processData((Data)iterator.next(), list);
            }
        }
    }

    private static String stripNamespace(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static class FileEntry {
        private String file;
        private Namespace namespace;
        private Collection data;

        FileEntry(String string, Namespace namespace, Collection collection) {
            this.file = string;
            this.namespace = namespace;
            this.data = collection;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String string) {
            this.file = string;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public Collection getData() {
            return this.data;
        }
    }
}

