/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;

public class ViewMenu
extends ExtensionPopupMenu {
    private static final long serialVersionUID = -6295434374221271825L;
    private static final String MENU_LABEL = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.label");
    private static final String ANTI_ALIASING = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.antiAliasing");
    private static final String SHOW_LINE_NUMBERS = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.showLineNumbers");
    private static final String WORD_WRAP = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.wordWrap");
    private static final String HIGHLIGHT_CURRENT_LINE = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.highlightCurrentLine");
    private static final String FADE_CURRENT_HIGHLIGHT_LINE = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.fadeCurrentHighlightLine");
    private static final String SHOW_WHITESPACE_CHARACTERS = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.showWhitespaceCharacters");
    private static final String SHOW_NEWLINE_CHARACTERS = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.showNewlineCharacters");
    private static final String MARK_OCCURRENCES = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.markOccurrences");
    private static final String ROUNDED_SELECTION_EDGES = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.roundedSelectionEdges");
    private static final String BRACKET_MATCHING = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.bracketMatching");
    private static final String ANIMATED_BRACKET_MATCHING = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.animatedBracketMatching");
    private JCheckBoxMenuItem antiAliasingOption = this.createAndAddOption(new ChangeAntiAliasingAction(ANTI_ALIASING), this);
    private JCheckBoxMenuItem lineNumbersOption = this.createAndAddOption(new ChangeLineNumbersAction(SHOW_LINE_NUMBERS), this);
    private JCheckBoxMenuItem wordWrapOption = this.createAndAddOption(new ChangeWordWrapAction(WORD_WRAP), this);
    private JCheckBoxMenuItem highlightCurrentLineOption;
    private JCheckBoxMenuItem fadeCurrentHighlightLineOption;
    private JCheckBoxMenuItem showWhitespacesOption;
    private JCheckBoxMenuItem showNewlinesOption;
    private JCheckBoxMenuItem markOccurrencesOption;
    private JCheckBoxMenuItem roundedSelectionEdgesOption;
    private JCheckBoxMenuItem bracketMatchingOption;
    private JCheckBoxMenuItem animatedBracketMatchingOption;

    public ViewMenu() {
        super(MENU_LABEL);
        this.addSeparator();
        this.highlightCurrentLineOption = this.createAndAddOption(new ChangeHighlightCurrentLineAction(HIGHLIGHT_CURRENT_LINE), this);
        this.fadeCurrentHighlightLineOption = this.createAndAddOption(new ChangeFadeCurrentHighlightLineAction(FADE_CURRENT_HIGHLIGHT_LINE), this);
        this.addSeparator();
        this.showWhitespacesOption = this.createAndAddOption(new ChangeShowWhitespacesAction(SHOW_WHITESPACE_CHARACTERS), this);
        this.showNewlinesOption = this.createAndAddOption(new ChangeShowNewlinesAction(SHOW_NEWLINE_CHARACTERS), this);
        this.addSeparator();
        this.markOccurrencesOption = this.createAndAddOption(new ChangeMarkOccurrencesAction(MARK_OCCURRENCES), this);
        this.addSeparator();
        this.roundedSelectionEdgesOption = this.createAndAddOption(new ChangeRoundedSelectionEdgesAction(ROUNDED_SELECTION_EDGES), this);
        this.addSeparator();
        this.bracketMatchingOption = this.createAndAddOption(new ChangeBracketMatchingAction(BRACKET_MATCHING), this);
        this.animatedBracketMatchingOption = this.createAndAddOption(new ChangeAnimatedBracketMatchingAction(ANIMATED_BRACKET_MATCHING), this);
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        if (component instanceof HttpPanelSyntaxHighlightTextArea) {
            HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)component);
            this.updateState(httpPanelSyntaxHighlightTextArea);
            return true;
        }
        return false;
    }

    public void updateState(HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea) {
        this.antiAliasingOption.setSelected(httpPanelSyntaxHighlightTextArea.getAntiAliasingEnabled());
        boolean bl = false;
        boolean bl2 = false;
        Container container = httpPanelSyntaxHighlightTextArea.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof RTextScrollPane) {
            bl2 = true;
            RTextScrollPane rTextScrollPane = (RTextScrollPane)container;
            bl = rTextScrollPane.getLineNumbersEnabled();
        }
        this.lineNumbersOption.setVisible(bl2);
        this.lineNumbersOption.setSelected(bl);
        this.wordWrapOption.setSelected(httpPanelSyntaxHighlightTextArea.getLineWrap());
        this.highlightCurrentLineOption.setSelected(httpPanelSyntaxHighlightTextArea.getHighlightCurrentLine());
        this.fadeCurrentHighlightLineOption.setSelected(httpPanelSyntaxHighlightTextArea.getFadeCurrentLineHighlight());
        this.showWhitespacesOption.setSelected(httpPanelSyntaxHighlightTextArea.isWhitespaceVisible());
        this.showNewlinesOption.setSelected(httpPanelSyntaxHighlightTextArea.getEOLMarkersVisible());
        this.markOccurrencesOption.setSelected(httpPanelSyntaxHighlightTextArea.getMarkOccurrences());
        this.roundedSelectionEdgesOption.setSelected(httpPanelSyntaxHighlightTextArea.getRoundedSelectionEdges());
        this.bracketMatchingOption.setSelected(httpPanelSyntaxHighlightTextArea.isBracketMatchingEnabled());
        this.animatedBracketMatchingOption.setSelected(httpPanelSyntaxHighlightTextArea.getAnimateBracketMatching());
    }

    private JCheckBoxMenuItem createAndAddOption(TextAction textAction, JMenu jMenu) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(textAction);
        jCheckBoxMenuItem.setSelected(false);
        jMenu.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    private static class ChangeAnimatedBracketMatchingAction
    extends TextAction {
        private static final long serialVersionUID = -4394901099442863189L;

        public ChangeAnimatedBracketMatchingAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setAnimateBracketMatching(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getAnimateBracketMatching());
            }
        }
    }

    private static class ChangeBracketMatchingAction
    extends TextAction {
        private static final long serialVersionUID = 7913147909802331579L;

        public ChangeBracketMatchingAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setBracketMatchingEnabled(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).isBracketMatchingEnabled());
            }
        }
    }

    private static class ChangeRoundedSelectionEdgesAction
    extends TextAction {
        private static final long serialVersionUID = 6117454234529550001L;

        public ChangeRoundedSelectionEdgesAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setRoundedSelectionEdges(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getRoundedSelectionEdges());
            }
        }
    }

    private static class ChangeMarkOccurrencesAction
    extends TextAction {
        private static final long serialVersionUID = 4264667901630036382L;

        public ChangeMarkOccurrencesAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setMarkOccurrences(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getMarkOccurrences());
            }
        }
    }

    private static class ChangeShowNewlinesAction
    extends TextAction {
        private static final long serialVersionUID = -4769295127472728093L;

        public ChangeShowNewlinesAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setEOLMarkersVisible(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getEOLMarkersVisible());
            }
        }
    }

    private static class ChangeShowWhitespacesAction
    extends TextAction {
        private static final long serialVersionUID = 1658351146973083837L;

        public ChangeShowWhitespacesAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setWhitespaceVisible(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).isWhitespaceVisible());
            }
        }
    }

    private static class ChangeFadeCurrentHighlightLineAction
    extends TextAction {
        private static final long serialVersionUID = -1430399597611245037L;

        public ChangeFadeCurrentHighlightLineAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setFadeCurrentLineHighlight(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getFadeCurrentLineHighlight());
            }
        }
    }

    private static class ChangeHighlightCurrentLineAction
    extends TextAction {
        private static final long serialVersionUID = -1464472023983865781L;

        public ChangeHighlightCurrentLineAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setHighlightCurrentLine(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getHighlightCurrentLine());
            }
        }
    }

    private static class ChangeWordWrapAction
    extends TextAction {
        private static final long serialVersionUID = -8654200226170189435L;

        public ChangeWordWrapAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setLineWrap(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getLineWrap());
            }
        }
    }

    private static class ChangeLineNumbersAction
    extends TextAction {
        private static final long serialVersionUID = 7253500343033234417L;

        public ChangeLineNumbersAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
            Container container;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea && (container = (httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getParent()) instanceof JViewport && (container = container.getParent()) instanceof RTextScrollPane) {
                RTextScrollPane rTextScrollPane;
                rTextScrollPane.setLineNumbersEnabled(!(rTextScrollPane = (RTextScrollPane)container).getLineNumbersEnabled());
            }
        }
    }

    private static class ChangeAntiAliasingAction
    extends TextAction {
        private static final long serialVersionUID = 5408392183841188837L;

        public ChangeAntiAliasingAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea;
                httpPanelSyntaxHighlightTextArea.setAntiAliasingEnabled(!(httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent)).getAntiAliasingEnabled());
            }
        }
    }
}

