/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.NameClassPairEnumeration;
import com.sun.jndi.dns.NameNode;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.DirectoryManager;

class BindingEnumeration
extends NameClassPairEnumeration {
    BindingEnumeration(DnsContext ctx, Hashtable nodes) {
        super(ctx, nodes);
    }

    @Override
    public Object next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        NameNode nnode = (NameNode)this.nodes.nextElement();
        String label = nnode.getLabel();
        Name compName = new DnsName().add(label);
        String compNameStr = compName.toString();
        Name cname = new CompositeName().add(compNameStr);
        String cnameStr = cname.toString();
        DnsName fqdn = this.ctx.fullyQualify(compName);
        DnsContext child = new DnsContext(this.ctx, fqdn);
        try {
            Object obj = DirectoryManager.getObjectInstance(child, cname, this.ctx, child.environment, null);
            Binding binding = new Binding(cnameStr, obj);
            binding.setNameInNamespace(this.ctx.fullyQualify(cname).toString());
            return binding;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Problem generating object using object factory");
            ne.setRootCause(e);
            throw ne;
        }
    }
}

