/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Arrays;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;
import javax.net.ssl.SSLSocket;
import sun.misc.IOUtils;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private final Thread worker;
    private boolean v3 = true;
    public final String host;
    public final int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private final LdapClient parent;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    volatile IOException closureReason = null;
    volatile boolean useable = true;
    int readTimeout;
    int connectTimeout;
    private Object pauseLock = new Object();
    private boolean paused = false;

    void setV3(boolean v) {
        this.v3 = v;
    }

    void setBound() {
        this.bound = true;
    }

    Connection(LdapClient parent, String host, int port, String socketFactory, int connectTimeout, int readTimeout, OutputStream trace) throws NamingException {
        this.host = host;
        this.port = port;
        this.parent = parent;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        if (trace != null) {
            this.traceFile = trace;
            this.traceTagIn = "<- " + host + ":" + port + "\n\n";
            this.traceTagOut = "-> " + host + ":" + port + "\n\n";
        }
        try {
            this.sock = this.createSocket(host, port, socketFactory, connectTimeout);
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            CommunicationException ce = new CommunicationException(host + ":" + port);
            ce.setRootCause(realException);
            throw ce;
        }
        catch (Exception e) {
            CommunicationException ce = new CommunicationException(host + ":" + port);
            ce.setRootCause(e);
            throw ce;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    private Object createInetSocketAddress(String host, int port) throws NoSuchMethodException {
        try {
            Class<?> inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
            Constructor<?> inetSocketAddressCons = inetSocketAddressClass.getConstructor(String.class, Integer.TYPE);
            return inetSocketAddressCons.newInstance(host, new Integer(port));
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchMethodException();
        }
        catch (InstantiationException e) {
            throw new NoSuchMethodException();
        }
        catch (InvocationTargetException e) {
            throw new NoSuchMethodException();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchMethodException();
        }
    }

    private Socket createSocket(String host, int port, String socketFactory, int connectTimeout) throws Exception {
        Socket socket = null;
        if (socketFactory != null) {
            Class socketFactoryClass = Obj.helper.loadClass(socketFactory);
            Method getDefault = socketFactoryClass.getMethod("getDefault", new Class[0]);
            Object factory = getDefault.invoke(null, new Object[0]);
            Method createSocket = null;
            if (connectTimeout > 0) {
                try {
                    createSocket = socketFactoryClass.getMethod("createSocket", new Class[0]);
                    Method connect = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object endpoint = this.createInetSocketAddress(host, port);
                    socket = (Socket)createSocket.invoke(factory, new Object[0]);
                    connect.invoke(socket, endpoint, new Integer(connectTimeout));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                createSocket = socketFactoryClass.getMethod("createSocket", String.class, Integer.TYPE);
                socket = (Socket)createSocket.invoke(factory, host, new Integer(port));
            }
        } else {
            if (connectTimeout > 0) {
                try {
                    Constructor socketCons = Socket.class.getConstructor(new Class[0]);
                    Method connect = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object endpoint = this.createInetSocketAddress(host, port);
                    socket = (Socket)socketCons.newInstance(new Object[0]);
                    connect.invoke(socket, endpoint, new Integer(connectTimeout));
                }
                catch (NoSuchMethodException socketCons) {
                    // empty catch block
                }
            }
            if (socket == null) {
                socket = new Socket(host, port);
            }
        }
        if (connectTimeout > 0 && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            int socketTimeout = sslSocket.getSoTimeout();
            sslSocket.setSoTimeout(connectTimeout);
            sslSocket.startHandshake();
            sslSocket.setSoTimeout(socketTimeout);
        }
        return socket;
    }

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    LdapRequest writeRequest(BerEncoder ber, int msgId) throws IOException {
        return this.writeRequest(ber, msgId, false, -1);
    }

    LdapRequest writeRequest(BerEncoder ber, int msgId, boolean pauseAfterReceipt) throws IOException {
        return this.writeRequest(ber, msgId, pauseAfterReceipt, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapRequest writeRequest(BerEncoder ber, int msgId, boolean pauseAfterReceipt, int replyQueueCapacity) throws IOException {
        LdapRequest req = new LdapRequest(msgId, pauseAfterReceipt, replyQueueCapacity);
        this.addRequest(req);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, ber.getBuf(), 0, ber.getDataLen());
        }
        this.unpauseReader();
        try {
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(ber.getBuf(), 0, ber.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException e) {
            this.cleanup(null, true);
            this.closureReason = e;
            throw this.closureReason;
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BerDecoder readReply(LdapRequest ldr) throws IOException, NamingException {
        BerDecoder rber;
        long elapsedMilli = 0L;
        long elapsedNano = 0L;
        while ((rber = ldr.getReplyBer()) == null && (this.readTimeout <= 0 || elapsedMilli < (long)this.readTimeout)) {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.sock == null) {
                        throw new ServiceUnavailableException(this.host + ":" + this.port + "; socket closed");
                    }
                }
                object = ldr;
                synchronized (object) {
                    rber = ldr.getReplyBer();
                    if (rber != null) {
                        break;
                    }
                    if (this.readTimeout > 0) {
                        long beginNano = System.nanoTime();
                        ldr.wait((long)this.readTimeout - elapsedMilli);
                        elapsedMilli += (elapsedNano += System.nanoTime() - beginNano) / 1000000L;
                        elapsedNano %= 1000000L;
                    } else {
                        ldr.wait();
                    }
                }
            }
            catch (InterruptedException ex) {
                throw new InterruptedNamingException("Interrupted during LDAP operation");
            }
        }
        if (rber == null && elapsedMilli >= (long)this.readTimeout) {
            this.abandonRequest(ldr, null);
            throw new NamingException("LDAP response read timed out, timeout used:" + this.readTimeout + "ms.");
        }
        return rber;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldr = this.pendingRequests;
        if (ldr == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized LdapRequest findRequest(int msgId) {
        LdapRequest ldr = this.pendingRequests;
        while (ldr != null) {
            if (ldr.msgId == msgId) {
                return ldr;
            }
            ldr = ldr.next;
        }
        return null;
    }

    synchronized void removeRequest(LdapRequest req) {
        LdapRequest ldr = this.pendingRequests;
        LdapRequest ldrprev = null;
        while (ldr != null) {
            if (ldr == req) {
                ldr.cancel();
                if (ldrprev != null) {
                    ldrprev.next = ldr.next;
                } else {
                    this.pendingRequests = ldr.next;
                }
                ldr.next = null;
            }
            ldrprev = ldr;
            ldr = ldr.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonRequest(LdapRequest ldr, Control[] reqCtls) {
        this.removeRequest(ldr);
        BerEncoder ber = new BerEncoder(256);
        int abandonMsgId = this.getMsgId();
        try {
            ber.beginSeq(48);
            ber.encodeInt(abandonMsgId);
            ber.encodeInt(ldr.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(ber, reqCtls);
            }
            ber.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, ber.getBuf(), 0, ber.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(ber.getBuf(), 0, ber.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void abandonOutstandingReqs(Control[] reqCtls) {
        LdapRequest ldr = this.pendingRequests;
        while (ldr != null) {
            this.abandonRequest(ldr, reqCtls);
            this.pendingRequests = ldr = ldr.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapUnbind(Control[] reqCtls) {
        BerEncoder ber = new BerEncoder(256);
        int unbindMsgId = this.getMsgId();
        try {
            ber.beginSeq(48);
            ber.encodeInt(unbindMsgId);
            ber.encodeByte(66);
            ber.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(ber, reqCtls);
            }
            ber.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, ber.getBuf(), 0, ber.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(ber.getBuf(), 0, ber.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void cleanup(Control[] reqCtls, boolean notifyParent) {
        boolean nparent = false;
        Connection connection = this;
        synchronized (connection) {
            LdapRequest ldr;
            block21: {
                block22: {
                    block20: {
                        this.useable = false;
                        if (this.sock == null) break block21;
                        if (!notifyParent) {
                            this.abandonOutstandingReqs(reqCtls);
                        }
                        if (!this.bound) break block20;
                        this.ldapUnbind(reqCtls);
                    }
                    try {
                        this.outStream.flush();
                        this.sock.close();
                        this.unpauseReader();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!notifyParent) {
                        ldr = this.pendingRequests;
                        while (ldr != null) {
                            ldr.cancel();
                            ldr = ldr.next;
                        }
                    }
                    break block22;
                    catch (Throwable throwable) {
                        try {
                            this.outStream.flush();
                            this.sock.close();
                            this.unpauseReader();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!notifyParent) {
                            LdapRequest ldr2 = this.pendingRequests;
                            while (ldr2 != null) {
                                ldr2.cancel();
                                ldr2 = ldr2.next;
                            }
                        }
                        this.sock = null;
                        throw throwable;
                    }
                }
                this.sock = null;
                nparent = notifyParent;
            }
            if (nparent) {
                ldr = this.pendingRequests;
                while (ldr != null) {
                    LdapRequest ldapRequest = ldr;
                    synchronized (ldapRequest) {
                        ldr.notify();
                        ldr = ldr.next;
                    }
                }
            }
        }
        if (nparent) {
            this.parent.processConnectionClosure();
        }
    }

    public synchronized void replaceStreams(InputStream newIn, OutputStream newOut) {
        this.inStream = newIn;
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = newOut;
    }

    private synchronized InputStream getInputStream() {
        return this.inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                this.pauseLock.notify();
            }
        }
    }

    private void pauseReader() throws IOException {
        this.paused = true;
        try {
            while (this.paused) {
                this.pauseLock.wait();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Pause/unpause reader has problems.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            InputStream in = null;
            block12: while (true) {
                try {
                    while (true) {
                        try {
                            while (true) {
                                byte[] inbuf = new byte[129];
                                int offset = 0;
                                int seqlen = 0;
                                int seqlenlen = 0;
                                in = this.getInputStream();
                                int bytesread = in.read(inbuf, offset, 1);
                                if (bytesread < 0) {
                                    if (in != this.getInputStream()) {
                                        continue;
                                    }
                                    break block25;
                                }
                                if (inbuf[offset++] != 48) continue;
                                bytesread = in.read(inbuf, offset, 1);
                                if (bytesread < 0) {
                                    break block25;
                                }
                                if (((seqlen = inbuf[offset++]) & 0x80) == 128) {
                                    int br;
                                    seqlenlen = seqlen & 0x7F;
                                    boolean eos = false;
                                    for (bytesread = 0; bytesread < seqlenlen; bytesread += br) {
                                        br = in.read(inbuf, offset + bytesread, seqlenlen - bytesread);
                                        if (br >= 0) continue;
                                        eos = true;
                                        break;
                                    }
                                    if (eos) {
                                        break block25;
                                    }
                                    seqlen = 0;
                                    for (int i = 0; i < seqlenlen; ++i) {
                                        seqlen = (seqlen << 8) + (inbuf[offset + i] & 0xFF);
                                    }
                                    offset += bytesread;
                                }
                                byte[] left = IOUtils.readFully(in, seqlen, false);
                                inbuf = Arrays.copyOf(inbuf, offset + left.length);
                                System.arraycopy(left, 0, inbuf, offset, left.length);
                                offset += left.length;
                                try {
                                    BerDecoder retBer = new BerDecoder(inbuf, 0, offset);
                                    if (this.traceFile != null) {
                                        Ber.dumpBER(this.traceFile, this.traceTagIn, inbuf, 0, offset);
                                    }
                                    retBer.parseSeq(null);
                                    int inMsgId = retBer.parseInt();
                                    retBer.reset();
                                    boolean needPause = false;
                                    if (inMsgId == 0) {
                                        this.parent.processUnsolicited(retBer);
                                        continue block12;
                                    }
                                    LdapRequest ldr = this.findRequest(inMsgId);
                                    if (ldr == null) continue block12;
                                    Object object = this.pauseLock;
                                    synchronized (object) {
                                        needPause = ldr.addReplyBer(retBer);
                                        if (needPause) {
                                            this.pauseReader();
                                        }
                                        continue block12;
                                    }
                                }
                                catch (Ber.DecodeException decodeException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException ie) {
                            if (in != this.getInputStream()) continue;
                            throw ie;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    this.closureReason = ex;
                    break block25;
                }
            }
            finally {
                this.cleanup(null, true);
            }
        }
    }
}

