/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.ReferralEnumeration;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.NamingManager;

final class LdapReferralContext
implements DirContext,
LdapContext {
    private DirContext refCtx = null;
    private Name urlName = null;
    private String urlAttrs = null;
    private String urlScope = null;
    private String urlFilter = null;
    private LdapReferralException refEx = null;
    private boolean skipThisReferral = false;
    private int hopCount = 1;
    private NamingException previousEx = null;

    LdapReferralContext(LdapReferralException ex, Hashtable env, Control[] connCtls, Control[] reqCtls, String nextName, boolean skipThisReferral, int handleReferrals) throws NamingException {
        Object obj;
        String referral;
        this.refEx = ex;
        this.skipThisReferral = skipThisReferral;
        if (this.skipThisReferral) {
            return;
        }
        if (env != null) {
            env = (Hashtable)env.clone();
            if (connCtls == null) {
                env.remove("java.naming.ldap.control.connect");
            }
        } else if (connCtls != null) {
            env = new Hashtable<String, Control[]>(5);
        }
        if (connCtls != null) {
            Control[] copiedCtls = new Control[connCtls.length];
            System.arraycopy(connCtls, 0, copiedCtls, 0, connCtls.length);
            env.put("java.naming.ldap.control.connect", copiedCtls);
        }
        while (true) {
            try {
                referral = this.refEx.getNextReferral();
                if (referral == null) {
                    throw (NamingException)this.previousEx.fillInStackTrace();
                }
            }
            catch (LdapReferralException e) {
                if (handleReferrals == 2) {
                    throw e;
                }
                this.refEx = e;
                continue;
            }
            Reference ref = new Reference("javax.naming.directory.DirContext", new StringRefAddr("URL", referral));
            try {
                obj = NamingManager.getObjectInstance(ref, null, null, env);
            }
            catch (NamingException e) {
                if (handleReferrals == 2) {
                    throw e;
                }
                this.previousEx = e;
                continue;
            }
            catch (Exception e) {
                NamingException e2 = new NamingException("problem generating object using object factory");
                e2.setRootCause(e);
                throw e2;
            }
            break;
        }
        if (obj instanceof DirContext) {
            this.refCtx = (DirContext)obj;
            if (this.refCtx instanceof LdapContext && reqCtls != null) {
                ((LdapContext)this.refCtx).setRequestControls(reqCtls);
            }
        } else {
            NotContextException ne = new NotContextException("Cannot create context for: " + referral);
            ne.setRemainingName(new CompositeName().add(nextName));
            throw ne;
        }
        this.initDefaults(referral, nextName);
    }

    private void initDefaults(String referral, String nextName) throws NamingException {
        String urlString;
        try {
            LdapURL url = new LdapURL(referral);
            urlString = url.getDN();
            this.urlAttrs = url.getAttributes();
            this.urlScope = url.getScope();
            this.urlFilter = url.getFilter();
        }
        catch (NamingException e) {
            urlString = referral;
            this.urlFilter = null;
            this.urlScope = null;
            this.urlAttrs = null;
        }
        urlString = urlString == null ? nextName : "";
        this.urlName = urlString == null ? null : (urlString.equals("") ? new CompositeName() : new CompositeName().add(urlString));
    }

    @Override
    public void close() throws NamingException {
        if (this.refCtx != null) {
            this.refCtx.close();
            this.refCtx = null;
        }
        this.refEx = null;
    }

    void setHopCount(int hopCount) {
        this.hopCount = hopCount;
        if (this.refCtx != null && this.refCtx instanceof LdapCtx) {
            ((LdapCtx)this.refCtx).setHopCount(hopCount);
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.toName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.lookup(this.overrideName(name));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.toName(name), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.bind(this.overrideName(name), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.toName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rebind(this.overrideName(name), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.toName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.unbind(this.overrideName(name));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this.toName(oldName), this.toName(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rename(this.overrideName(oldName), this.toName(this.refEx.getNewRdn()));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.toName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<NameClassPair> ne = null;
            if (this.urlScope != null && this.urlScope.equals("base")) {
                SearchControls cons = new SearchControls();
                cons.setReturningObjFlag(true);
                cons.setSearchScope(0);
                ne = this.refCtx.search(this.overrideName(name), "(objectclass=*)", cons);
            } else {
                ne = this.refCtx.list(this.overrideName(name));
            }
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)ne).appendUnprocessedReferrals(this.refEx);
            return ne;
        }
        catch (LdapReferralException e) {
            e.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)e.fillInStackTrace();
        }
        catch (NamingException e) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(e);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw e;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.toName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<Binding> be = null;
            if (this.urlScope != null && this.urlScope.equals("base")) {
                SearchControls cons = new SearchControls();
                cons.setReturningObjFlag(true);
                cons.setSearchScope(0);
                be = this.refCtx.search(this.overrideName(name), "(objectclass=*)", cons);
            } else {
                be = this.refCtx.listBindings(this.overrideName(name));
            }
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)be).appendUnprocessedReferrals(this.refEx);
            return be;
        }
        catch (LdapReferralException e) {
            e.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)e.fillInStackTrace();
        }
        catch (NamingException e) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(e);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw e;
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.toName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.destroySubcontext(this.overrideName(name));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.toName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.createSubcontext(this.overrideName(name));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.toName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.lookupLink(this.overrideName(name));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(this.toName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getNameParser(this.overrideName(name));
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this.toName(name), this.toName(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getEnvironment();
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(this.toName(name));
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getAttributes(this.overrideName(name));
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(this.toName(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getAttributes(this.overrideName(name), attrIds);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(this.toName(name), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.modifyAttributes(this.overrideName(name), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(this.toName(name), mods);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.modifyAttributes(this.overrideName(name), mods);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind(this.toName(name), obj, attrs);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.bind(this.overrideName(name), obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(this.toName(name), obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rebind(this.overrideName(name), obj, attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext(this.toName(name), attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.createSubcontext(this.overrideName(name), attrs);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return this.getSchema(this.toName(name));
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getSchema(this.overrideName(name));
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.getSchemaClassDefinition(this.toName(name));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getSchemaClassDefinition(this.overrideName(name));
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(this.toName(name), SearchFilter.format(matchingAttributes), new SearchControls());
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, SearchFilter.format(matchingAttributes), new SearchControls());
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        SearchControls cons = new SearchControls();
        cons.setReturningAttributes(attributesToReturn);
        return this.search(this.toName(name), SearchFilter.format(matchingAttributes), cons);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        SearchControls cons = new SearchControls();
        cons.setReturningAttributes(attributesToReturn);
        return this.search(name, SearchFilter.format(matchingAttributes), cons);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search(this.toName(name), filter, cons);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<SearchResult> se = this.refCtx.search(this.overrideName(name), this.overrideFilter(filter), this.overrideAttributesAndScope(cons));
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)se).appendUnprocessedReferrals(this.refEx);
            return se;
        }
        catch (LdapReferralException e) {
            e.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)e.fillInStackTrace();
        }
        catch (NamingException e) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(e);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw e;
        }
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(this.toName(name), filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<SearchResult> se = this.urlFilter != null ? this.refCtx.search(this.overrideName(name), this.urlFilter, this.overrideAttributesAndScope(cons)) : this.refCtx.search(this.overrideName(name), filterExpr, filterArgs, this.overrideAttributesAndScope(cons));
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)se).appendUnprocessedReferrals(this.refEx);
            return se;
        }
        catch (LdapReferralException e) {
            e.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)e.fillInStackTrace();
        }
        catch (NamingException e) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(e);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw e;
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.urlName != null && !this.urlName.isEmpty() ? this.urlName.get(0) : "";
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).extendedOperation(request);
    }

    @Override
    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).newInstance(requestControls);
    }

    @Override
    public void reconnect(Control[] connCtls) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        ((LdapContext)this.refCtx).reconnect(connCtls);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).getConnectControls();
    }

    @Override
    public void setRequestControls(Control[] requestControls) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        ((LdapContext)this.refCtx).setRequestControls(requestControls);
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).getRequestControls();
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).getResponseControls();
    }

    private Name toName(String name) throws InvalidNameException {
        return name.equals("") ? new CompositeName() : new CompositeName().add(name);
    }

    private Name overrideName(Name name) throws InvalidNameException {
        return this.urlName == null ? name : this.urlName;
    }

    private SearchControls overrideAttributesAndScope(SearchControls cons) {
        if (this.urlScope != null || this.urlAttrs != null) {
            SearchControls urlCons = new SearchControls(cons.getSearchScope(), cons.getCountLimit(), cons.getTimeLimit(), cons.getReturningAttributes(), cons.getReturningObjFlag(), cons.getDerefLinkFlag());
            if (this.urlScope != null) {
                if (this.urlScope.equals("base")) {
                    urlCons.setSearchScope(0);
                } else if (this.urlScope.equals("one")) {
                    urlCons.setSearchScope(1);
                } else if (this.urlScope.equals("sub")) {
                    urlCons.setSearchScope(2);
                }
            }
            if (this.urlAttrs != null) {
                StringTokenizer tokens = new StringTokenizer(this.urlAttrs, ",");
                int count = tokens.countTokens();
                String[] attrs = new String[count];
                for (int i = 0; i < count; ++i) {
                    attrs[i] = tokens.nextToken();
                }
                urlCons.setReturningAttributes(attrs);
            }
            return urlCons;
        }
        return cons;
    }

    private String overrideFilter(String filter) {
        return this.urlFilter == null ? filter : this.urlFilter;
    }
}

