/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import sun.awt.im.CompositionAreaHandler;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodWindow;

public final class CompositionArea
extends JPanel
implements InputMethodListener {
    private CompositionAreaHandler handler;
    private TextLayout composedTextLayout;
    private TextHitInfo caret = null;
    private JFrame compositionWindow;
    private static final int TEXT_ORIGIN_X = 5;
    private static final int TEXT_ORIGIN_Y = 15;
    private static final int PASSIVE_WIDTH = 480;
    private static final int WIDTH_MARGIN = 10;
    private static final int HEIGHT_MARGIN = 3;

    CompositionArea() {
        String windowTitle = Toolkit.getProperty("AWT.CompositionWindowTitle", "Input Window");
        this.compositionWindow = (JFrame)InputMethodContext.createInputMethodWindow(windowTitle, null, true);
        this.setOpaque(true);
        this.setBorder(LineBorder.createGrayLineBorder());
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.enableInputMethods(true);
        this.enableEvents(8L);
        this.compositionWindow.getContentPane().add(this);
        this.compositionWindow.addWindowListener(new FrameWindowAdapter());
        this.addInputMethodListener(this);
        this.compositionWindow.enableInputMethods(false);
        this.compositionWindow.pack();
        Dimension windowSize = this.compositionWindow.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.compositionWindow.setLocation(screenSize.width - windowSize.width - 20, screenSize.height - windowSize.height - 100);
        this.compositionWindow.setVisible(false);
    }

    synchronized void setHandlerInfo(CompositionAreaHandler handler, InputContext inputContext) {
        this.handler = handler;
        ((InputMethodWindow)((Object)this.compositionWindow)).setInputContext(inputContext);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getCaretRectangle(TextHitInfo caret) {
        int caretLocation = 0;
        TextLayout layout = this.composedTextLayout;
        if (layout != null) {
            caretLocation = Math.round(layout.getCaretInfo(caret)[0]);
        }
        Graphics g = this.getGraphics();
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        finally {
            g.dispose();
        }
        return new Rectangle(5 + caretLocation, 15 - metrics.getAscent(), 0, metrics.getAscent() + metrics.getDescent());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getForeground());
        TextLayout layout = this.composedTextLayout;
        if (layout != null) {
            layout.draw((Graphics2D)g, 5.0f, 15.0f);
        }
        if (this.caret != null) {
            Rectangle rectangle = this.getCaretRectangle(this.caret);
            g.setXORMode(this.getBackground());
            g.fillRect(rectangle.x, rectangle.y, 1, rectangle.height);
            g.setPaintMode();
        }
    }

    void setCompositionAreaVisible(boolean visible) {
        this.compositionWindow.setVisible(visible);
    }

    boolean isCompositionAreaVisible() {
        return this.compositionWindow.isVisible();
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        this.handler.inputMethodTextChanged(event);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        this.handler.caretPositionChanged(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText(AttributedCharacterIterator composedText, TextHitInfo caret) {
        this.composedTextLayout = null;
        if (composedText == null) {
            this.compositionWindow.setVisible(false);
            this.caret = null;
        } else {
            Graphics g;
            if (!this.compositionWindow.isVisible()) {
                this.compositionWindow.setVisible(true);
            }
            if ((g = this.getGraphics()) == null) {
                return;
            }
            try {
                this.updateWindowLocation();
                FontRenderContext context = ((Graphics2D)g).getFontRenderContext();
                this.composedTextLayout = new TextLayout(composedText, context);
                Rectangle2D bounds = this.composedTextLayout.getBounds();
                this.caret = caret;
                FontMetrics metrics = g.getFontMetrics();
                Rectangle2D maxCharBoundsRec = metrics.getMaxCharBounds(g);
                int newHeight = (int)maxCharBoundsRec.getHeight() + 3;
                int newFrameHeight = newHeight + this.compositionWindow.getInsets().top + this.compositionWindow.getInsets().bottom;
                InputMethodRequests req = this.handler.getClientInputMethodRequests();
                int newWidth = req == null ? 480 : (int)bounds.getWidth() + 10;
                int newFrameWidth = newWidth + this.compositionWindow.getInsets().left + this.compositionWindow.getInsets().right;
                this.setPreferredSize(new Dimension(newWidth, newHeight));
                this.compositionWindow.setSize(new Dimension(newFrameWidth, newFrameHeight));
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCaret(TextHitInfo caret) {
        this.caret = caret;
        if (this.compositionWindow.isVisible()) {
            Graphics g = this.getGraphics();
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    void updateWindowLocation() {
        InputMethodRequests req = this.handler.getClientInputMethodRequests();
        if (req == null) {
            return;
        }
        Point windowLocation = new Point();
        Rectangle caretRect = req.getTextLocation(null);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.compositionWindow.getSize();
        int SPACING = 2;
        windowLocation.x = caretRect.x + windowSize.width > screenSize.width ? screenSize.width - windowSize.width : caretRect.x;
        windowLocation.y = caretRect.y + caretRect.height + 2 + windowSize.height > screenSize.height ? caretRect.y - 2 - windowSize.height : caretRect.y + caretRect.height + 2;
        this.compositionWindow.setLocation(windowLocation);
    }

    Rectangle getTextLocation(TextHitInfo offset) {
        Rectangle rectangle = this.getCaretRectangle(offset);
        Point location = this.getLocationOnScreen();
        rectangle.translate(location.x, location.y);
        return rectangle;
    }

    TextHitInfo getLocationOffset(int x, int y) {
        TextLayout layout = this.composedTextLayout;
        if (layout == null) {
            return null;
        }
        Point location = this.getLocationOnScreen();
        if (layout.getBounds().contains(x -= location.x + 5, y -= location.y + 15)) {
            return layout.hitTestChar(x, y);
        }
        return null;
    }

    void setCompositionAreaUndecorated(boolean setUndecorated) {
        if (this.compositionWindow.isDisplayable()) {
            this.compositionWindow.removeNotify();
        }
        this.compositionWindow.setUndecorated(setUndecorated);
        this.compositionWindow.pack();
    }

    class FrameWindowAdapter
    extends WindowAdapter {
        FrameWindowAdapter() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            CompositionArea.this.requestFocus();
        }
    }
}

