/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetBooleanAction;
import sun.security.provider.certpath.AdaptableX509CertSelector;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.DistributionPointName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IssuingDistributionPointExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RDN;
import sun.security.x509.ReasonFlags;
import sun.security.x509.SerialNumber;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean USE_CRLDP = AccessController.doPrivileged(new GetBooleanAction("com.sun.security.enableCRLDP"));

    private DistributionPointFetcher() {
    }

    public static Collection<X509CRL> getCRLs(X509CRLSelector selector, boolean signFlag, PublicKey prevKey, String provider, List<CertStore> certStores, boolean[] reasonsMask, Set<TrustAnchor> trustAnchors, Date validity) throws CertStoreException {
        if (!USE_CRLDP) {
            return Collections.emptySet();
        }
        X509Certificate cert = selector.getCertificateChecking();
        if (cert == null) {
            return Collections.emptySet();
        }
        try {
            CRLDistributionPointsExtension ext;
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            if (debug != null) {
                debug.println("DistributionPointFetcher.getCRLs: Checking CRLDPs for " + certImpl.getSubjectX500Principal());
            }
            if ((ext = certImpl.getCRLDistributionPointsExtension()) == null) {
                if (debug != null) {
                    debug.println("No CRLDP ext");
                }
                return Collections.emptySet();
            }
            List points = (List)ext.get("points");
            HashSet<X509CRL> results = new HashSet<X509CRL>();
            Iterator t = points.iterator();
            while (t.hasNext() && !Arrays.equals(reasonsMask, ALL_REASONS)) {
                DistributionPoint point = (DistributionPoint)t.next();
                Collection<X509CRL> crls = DistributionPointFetcher.getCRLs(selector, certImpl, point, reasonsMask, signFlag, prevKey, provider, certStores, trustAnchors, validity);
                results.addAll(crls);
            }
            if (debug != null) {
                debug.println("Returning " + results.size() + " CRLs");
            }
            return results;
        }
        catch (CertificateException e) {
            return Collections.emptySet();
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    private static Collection<X509CRL> getCRLs(X509CRLSelector selector, X509CertImpl certImpl, DistributionPoint point, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, String provider, List<CertStore> certStores, Set<TrustAnchor> trustAnchors, Date validity) {
        GeneralNames fullName = point.getFullName();
        if (fullName == null) {
            RDN relativeName = point.getRelativeName();
            if (relativeName == null) {
                return Collections.emptySet();
            }
            try {
                GeneralNames crlIssuers = point.getCRLIssuer();
                if (crlIssuers == null) {
                    fullName = DistributionPointFetcher.getFullNames((X500Name)certImpl.getIssuerDN(), relativeName);
                } else {
                    if (crlIssuers.size() != 1) {
                        return Collections.emptySet();
                    }
                    fullName = DistributionPointFetcher.getFullNames((X500Name)crlIssuers.get(0).getName(), relativeName);
                }
            }
            catch (IOException ioe) {
                return Collections.emptySet();
            }
        }
        ArrayList<X509CRL> possibleCRLs = new ArrayList<X509CRL>();
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(2);
        Iterator<GeneralName> t = fullName.iterator();
        while (t.hasNext()) {
            URIName uriName;
            X509CRL crl;
            GeneralName name = t.next();
            if (name.getType() == 4) {
                X500Name x500Name = (X500Name)name.getName();
                possibleCRLs.addAll(DistributionPointFetcher.getCRLs(x500Name, certImpl.getIssuerX500Principal(), certStores));
                continue;
            }
            if (name.getType() != 6 || (crl = DistributionPointFetcher.getCRL(uriName = (URIName)name.getName())) == null) continue;
            possibleCRLs.add(crl);
        }
        for (X509CRL crl : possibleCRLs) {
            try {
                selector.setIssuerNames(null);
                if (!selector.match(crl) || !DistributionPointFetcher.verifyCRL(certImpl, point, crl, reasonsMask, signFlag, prevKey, provider, trustAnchors, certStores, validity)) continue;
                crls.add(crl);
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.println("Exception verifying CRL: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return crls;
    }

    private static X509CRL getCRL(URIName name) {
        URI uri = name.getURI();
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + uri);
        }
        try {
            CertStore ucs = URICertStore.getInstance(new URICertStore.URICertStoreParameters(uri));
            Collection<? extends CRL> crls = ucs.getCRLs(null);
            if (crls.isEmpty()) {
                return null;
            }
            return (X509CRL)crls.iterator().next();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("Exception getting CRL from CertStore: " + e);
                e.printStackTrace();
            }
            return null;
        }
    }

    private static Collection<X509CRL> getCRLs(X500Name name, X500Principal certIssuer, List<CertStore> certStores) {
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + name);
        }
        X509CRLSelector xcs = new X509CRLSelector();
        xcs.addIssuer(name.asX500Principal());
        xcs.addIssuer(certIssuer);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        for (CertStore store : certStores) {
            try {
                for (CRL cRL : store.getCRLs(xcs)) {
                    crls.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException cse) {
                if (debug == null) continue;
                debug.println("Non-fatal exception while retrieving CRLs: " + cse);
                cse.printStackTrace();
            }
        }
        return crls;
    }

    static boolean verifyCRL(X509CertImpl certImpl, DistributionPoint point, X509CRL crl, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, String provider, Set<TrustAnchor> trustAnchors, List<CertStore> certStores, Date validity) throws CRLException, IOException {
        Iterator<Object> i;
        boolean indirectCRL = false;
        X509CRLImpl crlImpl = X509CRLImpl.toImpl(crl);
        IssuingDistributionPointExtension idpExt = crlImpl.getIssuingDistributionPointExtension();
        X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
        X500Name crlIssuer = (X500Name)crlImpl.getIssuerDN();
        GeneralNames pointCrlIssuers = point.getCRLIssuer();
        X500Name pointCrlIssuer = null;
        if (pointCrlIssuers != null) {
            if (idpExt == null || ((Boolean)idpExt.get("indirect_crl")).equals(Boolean.FALSE)) {
                return false;
            }
            boolean match = false;
            Iterator<GeneralName> t = pointCrlIssuers.iterator();
            while (!match && t.hasNext()) {
                GeneralNameInterface name = t.next().getName();
                if (!crlIssuer.equals(name)) continue;
                pointCrlIssuer = (X500Name)name;
                match = true;
            }
            if (!match) {
                return false;
            }
            if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                prevKey = certImpl.getPublicKey();
            } else {
                indirectCRL = true;
            }
        } else {
            if (!crlIssuer.equals(certIssuer)) {
                if (debug != null) {
                    debug.println("crl issuer does not equal cert issuer");
                }
                return false;
            }
            byte[] certAKID = certImpl.getExtensionValue(PKIXExtensions.AuthorityKey_Id.toString());
            byte[] crlAKID = crlImpl.getExtensionValue(PKIXExtensions.AuthorityKey_Id.toString());
            if (certAKID == null || crlAKID == null) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                }
            } else if (!Arrays.equals(certAKID, crlAKID)) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                } else {
                    indirectCRL = true;
                }
            }
        }
        if (!indirectCRL && !signFlag) {
            return false;
        }
        if (idpExt != null) {
            Boolean b;
            DistributionPointName idpPoint = (DistributionPointName)idpExt.get("point");
            if (idpPoint != null) {
                GeneralNames idpNames = idpPoint.getFullName();
                if (idpNames == null) {
                    RDN relativeName = idpPoint.getRelativeName();
                    if (relativeName == null) {
                        if (debug != null) {
                            debug.println("IDP must be relative or full DN");
                        }
                        return false;
                    }
                    if (debug != null) {
                        debug.println("IDP relativeName:" + relativeName);
                    }
                    idpNames = DistributionPointFetcher.getFullNames(crlIssuer, relativeName);
                }
                if (point.getFullName() != null || point.getRelativeName() != null) {
                    GeneralNames pointNames = point.getFullName();
                    if (pointNames == null) {
                        RDN relativeName = point.getRelativeName();
                        if (relativeName == null) {
                            if (debug != null) {
                                debug.println("DP must be relative or full DN");
                            }
                            return false;
                        }
                        if (debug != null) {
                            debug.println("DP relativeName:" + relativeName);
                        }
                        if (indirectCRL) {
                            if (pointCrlIssuers.size() != 1) {
                                if (debug != null) {
                                    debug.println("must only be one CRL issuer when relative name present");
                                }
                                return false;
                            }
                            pointNames = DistributionPointFetcher.getFullNames(pointCrlIssuer, relativeName);
                        } else {
                            pointNames = DistributionPointFetcher.getFullNames(certIssuer, relativeName);
                        }
                    }
                    boolean match = false;
                    Iterator<GeneralName> i2 = idpNames.iterator();
                    while (!match && i2.hasNext()) {
                        GeneralNameInterface idpName = i2.next().getName();
                        if (debug != null) {
                            debug.println("idpName: " + idpName);
                        }
                        Iterator<GeneralName> p = pointNames.iterator();
                        while (!match && p.hasNext()) {
                            GeneralNameInterface pointName = p.next().getName();
                            if (debug != null) {
                                debug.println("pointName: " + pointName);
                            }
                            match = idpName.equals(pointName);
                        }
                    }
                    if (!match) {
                        if (debug != null) {
                            debug.println("IDP name does not match DP name");
                        }
                        return false;
                    }
                } else {
                    boolean match = false;
                    Iterator<GeneralName> t = pointCrlIssuers.iterator();
                    while (!match && t.hasNext()) {
                        GeneralNameInterface crlIssuerName = t.next().getName();
                        i = idpNames.iterator();
                        while (!match && i.hasNext()) {
                            GeneralNameInterface idpName = i.next().getName();
                            match = crlIssuerName.equals(idpName);
                        }
                    }
                    if (!match) {
                        return false;
                    }
                }
            }
            if ((b = (Boolean)idpExt.get("only_user_certs")).equals(Boolean.TRUE) && certImpl.getBasicConstraints() != -1) {
                if (debug != null) {
                    debug.println("cert must be a EE cert");
                }
                return false;
            }
            b = (Boolean)idpExt.get("only_ca_certs");
            if (b.equals(Boolean.TRUE) && certImpl.getBasicConstraints() == -1) {
                if (debug != null) {
                    debug.println("cert must be a CA cert");
                }
                return false;
            }
            b = (Boolean)idpExt.get("only_attribute_certs");
            if (b.equals(Boolean.TRUE)) {
                if (debug != null) {
                    debug.println("cert must not be an AA cert");
                }
                return false;
            }
        }
        boolean[] interimReasonsMask = new boolean[9];
        ReasonFlags reasons = null;
        if (idpExt != null) {
            reasons = (ReasonFlags)idpExt.get("reasons");
        }
        boolean[] pointReasonFlags = point.getReasonFlags();
        if (reasons != null) {
            if (pointReasonFlags != null) {
                boolean[] idpReasonFlags = reasons.getFlags();
                for (int i3 = 0; i3 < interimReasonsMask.length; ++i3) {
                    interimReasonsMask[i3] = i3 < idpReasonFlags.length && idpReasonFlags[i3] && i3 < pointReasonFlags.length && pointReasonFlags[i3];
                }
            } else {
                interimReasonsMask = (boolean[])reasons.getFlags().clone();
            }
        } else if (idpExt == null || reasons == null) {
            if (pointReasonFlags != null) {
                interimReasonsMask = (boolean[])pointReasonFlags.clone();
            } else {
                Arrays.fill(interimReasonsMask, true);
            }
        }
        boolean oneOrMore = false;
        for (int i4 = 0; i4 < interimReasonsMask.length && !oneOrMore; ++i4) {
            if (!interimReasonsMask[i4] || i4 < reasonsMask.length && reasonsMask[i4]) continue;
            oneOrMore = true;
        }
        if (!oneOrMore) {
            return false;
        }
        if (indirectCRL) {
            X509CertSelector certSel = new X509CertSelector();
            certSel.setSubject(crlIssuer.asX500Principal());
            boolean[] crlSign = new boolean[]{false, false, false, false, false, false, true};
            certSel.setKeyUsage(crlSign);
            AuthorityKeyIdentifierExtension akidext = crlImpl.getAuthKeyIdExtension();
            if (akidext != null) {
                SerialNumber asn;
                KeyIdentifier akid = (KeyIdentifier)akidext.get("key_id");
                if (akid != null) {
                    DerOutputStream derout = new DerOutputStream();
                    derout.putOctetString(akid.getIdentifier());
                    certSel.setSubjectKeyIdentifier(derout.toByteArray());
                }
                if ((asn = (SerialNumber)akidext.get("serial_number")) != null) {
                    certSel.setSerialNumber(asn.getNumber());
                }
            }
            HashSet<TrustAnchor> newTrustAnchors = new HashSet<TrustAnchor>(trustAnchors);
            if (prevKey != null) {
                X500Principal principal = certImpl.getIssuerX500Principal();
                TrustAnchor temporary = new TrustAnchor(principal, prevKey, null);
                newTrustAnchors.add(temporary);
            }
            PKIXBuilderParameters params = null;
            try {
                params = new PKIXBuilderParameters(newTrustAnchors, (CertSelector)certSel);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new CRLException(iape);
            }
            params.setCertStores(certStores);
            params.setSigProvider(provider);
            params.setDate(validity);
            try {
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
                PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(params);
                prevKey = result.getPublicKey();
            }
            catch (Exception e) {
                throw new CRLException(e);
            }
        }
        try {
            AlgorithmChecker.check(prevKey, crl);
        }
        catch (CertPathValidatorException cpve) {
            if (debug != null) {
                debug.println("CRL signature algorithm check failed: " + cpve);
            }
            return false;
        }
        try {
            crl.verify(prevKey, provider);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("CRL signature failed to verify");
            }
            return false;
        }
        Set<String> unresCritExts = crl.getCriticalExtensionOIDs();
        if (unresCritExts != null) {
            unresCritExts.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
            if (!unresCritExts.isEmpty()) {
                if (debug != null) {
                    debug.println("Unrecognized critical extension(s) in CRL: " + unresCritExts);
                    i = unresCritExts.iterator();
                    while (i.hasNext()) {
                        debug.println((String)i.next());
                    }
                }
                return false;
            }
        }
        for (int i5 = 0; i5 < interimReasonsMask.length; ++i5) {
            reasonsMask[i5] = reasonsMask[i5] || i5 < interimReasonsMask.length && interimReasonsMask[i5];
        }
        return true;
    }

    private static GeneralNames getFullNames(X500Name issuer, RDN rdn) throws IOException {
        ArrayList<RDN> rdns = new ArrayList<RDN>(issuer.rdns());
        rdns.add(rdn);
        X500Name fullName = new X500Name(rdns.toArray(new RDN[0]));
        GeneralNames fullNames = new GeneralNames();
        fullNames.add(new GeneralName(fullName));
        return fullNames;
    }

    private static boolean issues(X509CertImpl cert, X509CRLImpl crl, String provider) throws IOException {
        boolean matched = false;
        AdaptableX509CertSelector issuerSelector = new AdaptableX509CertSelector();
        boolean[] usages = cert.getKeyUsage();
        if (usages != null) {
            usages[6] = true;
            issuerSelector.setKeyUsage(usages);
        }
        X500Principal crlIssuer = crl.getIssuerX500Principal();
        issuerSelector.setSubject(crlIssuer);
        AuthorityKeyIdentifierExtension crlAKID = crl.getAuthKeyIdExtension();
        if (crlAKID != null) {
            issuerSelector.parseAuthorityKeyIdentifierExtension(crlAKID);
        }
        if ((matched = issuerSelector.match(cert)) && (crlAKID == null || cert.getAuthorityKeyIdentifierExtension() == null)) {
            try {
                crl.verify(cert.getPublicKey(), provider);
                matched = true;
            }
            catch (Exception e) {
                matched = false;
            }
        }
        return matched;
    }
}

