/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class AlgorithmDecomposer {
    private static final Pattern transPattern = Pattern.compile("/");
    private static final Pattern pattern = Pattern.compile("with|and", 2);

    public Set<String> decompose(String algorithm) {
        if (algorithm == null || algorithm.length() == 0) {
            return new HashSet<String>();
        }
        String[] transTockens = transPattern.split(algorithm);
        HashSet<String> elements = new HashSet<String>();
        for (String transTocken : transTockens) {
            String[] tokens;
            if (transTocken == null || transTocken.length() == 0) continue;
            for (String token : tokens = pattern.split(transTocken)) {
                if (token == null || token.length() == 0) continue;
                elements.add(token);
            }
        }
        if (elements.contains("SHA1") && !elements.contains("SHA-1")) {
            elements.add("SHA-1");
        }
        if (elements.contains("SHA-1") && !elements.contains("SHA1")) {
            elements.add("SHA1");
        }
        if (elements.contains("SHA224") && !elements.contains("SHA-224")) {
            elements.add("SHA-224");
        }
        if (elements.contains("SHA-224") && !elements.contains("SHA224")) {
            elements.add("SHA224");
        }
        if (elements.contains("SHA256") && !elements.contains("SHA-256")) {
            elements.add("SHA-256");
        }
        if (elements.contains("SHA-256") && !elements.contains("SHA256")) {
            elements.add("SHA256");
        }
        if (elements.contains("SHA384") && !elements.contains("SHA-384")) {
            elements.add("SHA-384");
        }
        if (elements.contains("SHA-384") && !elements.contains("SHA384")) {
            elements.add("SHA384");
        }
        if (elements.contains("SHA512") && !elements.contains("SHA-512")) {
            elements.add("SHA-512");
        }
        if (elements.contains("SHA-512") && !elements.contains("SHA512")) {
            elements.add("SHA512");
        }
        return elements;
    }
}

