/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.interop.IsStringLikeNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=IsStringLikeNode.class)
public final class IsStringLikeNodeGen
extends IsStringLikeNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @Node.Child
    private BaseNode_ specialization_;

    private IsStringLikeNodeGen(RubyNode value) {
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public boolean executeIsStringLike(Object valueValue) {
        return this.specialization_.executeBoolean1(valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        return this.specialization_.executeBoolean0(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    private static String expectString(Object value) throws UnexpectedResultException {
        if (value instanceof String) {
            return (String)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static IsStringLikeNode create(RubyNode value) {
        return new IsStringLikeNodeGen(value);
    }

    @GeneratedBy(methodName="notStringLike(Object)", value=IsStringLikeNode.class)
    private static final class NotStringLikeNode_
    extends BaseNode_ {
        NotStringLikeNode_(IsStringLikeNodeGen root) {
            super(root, 4);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (!(RubyGuards.isRubyString(valueValue_) || RubyGuards.isRubySymbol(valueValue_) || RubyGuards.isString(valueValue_))) {
                return this.root.notStringLike(valueValue_);
            }
            return this.getNext().executeBoolean1(valueValue_);
        }

        @Override
        public boolean executeBoolean1(Object valueValue) {
            if (!(RubyGuards.isRubyString(valueValue) || RubyGuards.isRubySymbol(valueValue) || RubyGuards.isString(valueValue))) {
                return this.root.notStringLike(valueValue);
            }
            return this.getNext().executeBoolean1(valueValue);
        }

        static BaseNode_ create(IsStringLikeNodeGen root) {
            return new NotStringLikeNode_(root);
        }
    }

    @GeneratedBy(methodName="isJavaString(String)", value=IsStringLikeNode.class)
    private static final class IsJavaStringNode_
    extends BaseNode_ {
        IsJavaStringNode_(IsStringLikeNodeGen root) {
            super(root, 3);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            String valueValue_;
            try {
                valueValue_ = IsStringLikeNodeGen.expectString(this.root.value_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean1(ex.getResult());
            }
            return this.root.isJavaString(valueValue_);
        }

        @Override
        public boolean executeBoolean1(Object valueValue) {
            if (valueValue instanceof String) {
                String valueValue_ = (String)valueValue;
                return this.root.isJavaString(valueValue_);
            }
            return this.getNext().executeBoolean1(valueValue);
        }

        static BaseNode_ create(IsStringLikeNodeGen root) {
            return new IsJavaStringNode_(root);
        }
    }

    @GeneratedBy(methodName="isRubySymbol(DynamicObject)", value=IsStringLikeNode.class)
    private static final class IsRubySymbolNode_
    extends BaseNode_ {
        IsRubySymbolNode_(IsStringLikeNodeGen root) {
            super(root, 2);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            DynamicObject valueValue_;
            try {
                valueValue_ = this.root.value_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean1(ex.getResult());
            }
            if (this.root.isRubySymbol(valueValue_)) {
                return this.root.isRubySymbol(valueValue_);
            }
            return this.getNext().executeBoolean1(valueValue_);
        }

        @Override
        public boolean executeBoolean1(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && this.root.isRubySymbol(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.isRubySymbol(valueValue_);
            }
            return this.getNext().executeBoolean1(valueValue);
        }

        static BaseNode_ create(IsStringLikeNodeGen root) {
            return new IsRubySymbolNode_(root);
        }
    }

    @GeneratedBy(methodName="isRubyString(DynamicObject)", value=IsStringLikeNode.class)
    private static final class IsRubyStringNode_
    extends BaseNode_ {
        IsRubyStringNode_(IsStringLikeNodeGen root) {
            super(root, 1);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            DynamicObject valueValue_;
            try {
                valueValue_ = this.root.value_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean1(ex.getResult());
            }
            if (this.root.isRubyString(valueValue_)) {
                return this.root.isRubyString(valueValue_);
            }
            return this.getNext().executeBoolean1(valueValue_);
        }

        @Override
        public boolean executeBoolean1(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && this.root.isRubyString(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.isRubyString(valueValue_);
            }
            return this.getNext().executeBoolean1(valueValue);
        }

        static BaseNode_ create(IsStringLikeNodeGen root) {
            return new IsRubyStringNode_(root);
        }
    }

    @GeneratedBy(value=IsStringLikeNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(IsStringLikeNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.getNext().executeBoolean1(valueValue_);
        }

        @Override
        public boolean executeBoolean1(Object valueValue) {
            return this.getNext().executeBoolean1(valueValue);
        }

        static BaseNode_ create(IsStringLikeNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=IsStringLikeNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(IsStringLikeNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public boolean executeBoolean1(Object valueValue) {
            return (Boolean)this.uninitialized((Frame)null, valueValue);
        }

        static BaseNode_ create(IsStringLikeNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=IsStringLikeNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected IsStringLikeNodeGen root;

        BaseNode_(IsStringLikeNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (IsStringLikeNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeBoolean1(valueValue);
        }

        public abstract boolean executeBoolean1(Object var1);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.executeBoolean1(valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public boolean executeBoolean0(VirtualFrame frameValue) {
            return (Boolean)this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            if (valueValue instanceof DynamicObject) {
                DynamicObject valueValue_ = (DynamicObject)valueValue;
                if (this.root.isRubyString(valueValue_)) {
                    return IsRubyStringNode_.create(this.root);
                }
                if (this.root.isRubySymbol(valueValue_)) {
                    return IsRubySymbolNode_.create(this.root);
                }
            }
            if (valueValue instanceof String) {
                return IsJavaStringNode_.create(this.root);
            }
            if (!(RubyGuards.isRubyString(valueValue) || RubyGuards.isRubySymbol(valueValue) || RubyGuards.isString(valueValue))) {
                return NotStringLikeNode_.create(this.root);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

