/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageTypeSpecifier;

public class ImageReadParam
extends IIOParam {
    protected boolean canSetSourceRenderSize = false;
    protected Dimension sourceRenderSize = null;
    protected BufferedImage destination = null;
    protected int[] destinationBands = null;
    protected int minProgressivePass = 0;
    protected int numProgressivePasses = Integer.MAX_VALUE;

    @Override
    public void setDestinationType(ImageTypeSpecifier imageTypeSpecifier) {
        super.setDestinationType(imageTypeSpecifier);
        this.setDestination(null);
    }

    public void setDestination(BufferedImage bufferedImage) {
        this.destination = bufferedImage;
    }

    public BufferedImage getDestination() {
        return this.destination;
    }

    public void setDestinationBands(int[] nArray) {
        if (nArray == null) {
            this.destinationBands = null;
        } else {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                if (n2 < 0) {
                    throw new IllegalArgumentException("Band value < 0!");
                }
                for (int j = i + 1; j < n; ++j) {
                    if (n2 != nArray[j]) continue;
                    throw new IllegalArgumentException("Duplicate band value!");
                }
            }
            this.destinationBands = (int[])nArray.clone();
        }
    }

    public int[] getDestinationBands() {
        if (this.destinationBands == null) {
            return null;
        }
        return (int[])this.destinationBands.clone();
    }

    public boolean canSetSourceRenderSize() {
        return this.canSetSourceRenderSize;
    }

    public void setSourceRenderSize(Dimension dimension) throws UnsupportedOperationException {
        if (!this.canSetSourceRenderSize()) {
            throw new UnsupportedOperationException("Can't set source render size!");
        }
        if (dimension == null) {
            this.sourceRenderSize = null;
        } else {
            if (dimension.width <= 0 || dimension.height <= 0) {
                throw new IllegalArgumentException("width or height <= 0!");
            }
            this.sourceRenderSize = (Dimension)dimension.clone();
        }
    }

    public Dimension getSourceRenderSize() {
        return this.sourceRenderSize == null ? null : (Dimension)this.sourceRenderSize.clone();
    }

    public void setSourceProgressivePasses(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("minPass < 0!");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("numPasses <= 0!");
        }
        if (n2 != Integer.MAX_VALUE && (n + n2 - 1 & Integer.MIN_VALUE) != 0) {
            throw new IllegalArgumentException("minPass + numPasses - 1 > INTEGER.MAX_VALUE!");
        }
        this.minProgressivePass = n;
        this.numProgressivePasses = n2;
    }

    public int getSourceMinProgressivePass() {
        return this.minProgressivePass;
    }

    public int getSourceMaxProgressivePass() {
        if (this.numProgressivePasses == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.minProgressivePass + this.numProgressivePasses - 1;
    }

    public int getSourceNumProgressivePasses() {
        return this.numProgressivePasses;
    }
}

