/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

class ClassTab
extends Tab
implements ActionListener {
    PlotterPanel loadedClassesMeter;
    TimeComboBox timeComboBox;
    private JCheckBox verboseCheckBox;
    private HTMLPane details;
    private ClassOverviewPanel overviewPanel;
    private boolean plotterListening = false;
    private static final String loadedPlotterKey = "loaded";
    private static final String totalLoadedPlotterKey = "totalLoaded";
    private static final Color loadedPlotterColor = Plotter.defaultColor;
    private static final Color totalLoadedPlotterColor = Color.red;

    public static String getTabName() {
        return Messages.CLASSES;
    }

    public ClassTab(VMPanel vmPanel) {
        super(vmPanel, ClassTab.getTabName());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel plotterPanel = new JPanel(new BorderLayout());
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)plotterPanel, "Center");
        this.add((Component)bottomPanel, "South");
        JPanel controlPanel = new JPanel(new FlowLayout(1, 20, 5));
        topPanel.add((Component)controlPanel, "Center");
        this.verboseCheckBox = new JCheckBox(Messages.VERBOSE_OUTPUT);
        this.verboseCheckBox.addActionListener(this);
        this.verboseCheckBox.setToolTipText(Messages.VERBOSE_OUTPUT_TOOLTIP);
        JPanel topRightPanel = new JPanel();
        topRightPanel.setBorder(new EmptyBorder(0, 57, 0, 70));
        topRightPanel.add(this.verboseCheckBox);
        topPanel.add((Component)topRightPanel, "After");
        this.loadedClassesMeter = new PlotterPanel(Messages.NUMBER_OF_LOADED_CLASSES, Plotter.Unit.NONE, false);
        this.loadedClassesMeter.plotter.createSequence(loadedPlotterKey, Messages.LOADED, loadedPlotterColor, true);
        this.loadedClassesMeter.plotter.createSequence(totalLoadedPlotterKey, Messages.TOTAL_LOADED, totalLoadedPlotterColor, true);
        Utilities.setAccessibleName(this.loadedClassesMeter.plotter, Messages.CLASS_TAB_LOADED_CLASSES_PLOTTER_ACCESSIBLE_NAME);
        plotterPanel.add(this.loadedClassesMeter);
        this.timeComboBox = new TimeComboBox(this.loadedClassesMeter.plotter);
        controlPanel.add(new LabeledComponent(Messages.TIME_RANGE_COLON, Resources.getMnemonicInt(Messages.TIME_RANGE_COLON), this.timeComboBox));
        LabeledComponent.layout(plotterPanel);
        bottomPanel.setBorder(new CompoundBorder(new TitledBorder(Messages.DETAILS), new EmptyBorder(10, 10, 10, 10)));
        this.details = new HTMLPane();
        Utilities.setAccessibleName(this.details, Messages.DETAILS);
        JScrollPane scrollPane = new JScrollPane(this.details);
        scrollPane.setPreferredSize(new Dimension(0, 150));
        bottomPanel.add((Component)scrollPane, "South");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        final boolean b = this.verboseCheckBox.isSelected();
        this.workerAdd(new Runnable(){

            @Override
            public void run() {
                ProxyClient proxyClient = ClassTab.this.vmPanel.getProxyClient();
                try {
                    proxyClient.getClassLoadingMXBean().setVerbose(b);
                }
                catch (UndeclaredThrowableException e) {
                    proxyClient.markAsDead();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        final ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (!this.plotterListening) {
            proxyClient.addWeakPropertyChangeListener(this.loadedClassesMeter.plotter);
            this.plotterListening = true;
        }
        return new SwingWorker<Boolean, Object>(){
            private long clCount;
            private long cuCount;
            private long ctCount;
            private boolean isVerbose;
            private String detailsStr;
            private long timeStamp;

            @Override
            public Boolean doInBackground() {
                try {
                    ClassLoadingMXBean classLoadingMBean = proxyClient.getClassLoadingMXBean();
                    this.clCount = classLoadingMBean.getLoadedClassCount();
                    this.cuCount = classLoadingMBean.getUnloadedClassCount();
                    this.ctCount = classLoadingMBean.getTotalLoadedClassCount();
                    this.isVerbose = classLoadingMBean.isVerbose();
                    this.detailsStr = this.formatDetails();
                    this.timeStamp = System.currentTimeMillis();
                    return true;
                }
                catch (UndeclaredThrowableException e) {
                    proxyClient.markAsDead();
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            protected void done() {
                block5: {
                    try {
                        if (((Boolean)this.get()).booleanValue()) {
                            ClassTab.this.loadedClassesMeter.plotter.addValues(this.timeStamp, this.clCount, this.ctCount);
                            if (ClassTab.this.overviewPanel != null) {
                                ClassTab.this.overviewPanel.updateClassInfo(this.ctCount, this.clCount);
                                ClassTab.this.overviewPanel.getPlotter().addValues(this.timeStamp, this.clCount);
                            }
                            ClassTab.this.loadedClassesMeter.setValueLabel(this.clCount + "");
                            ClassTab.this.verboseCheckBox.setSelected(this.isVerbose);
                            ClassTab.this.details.setText(this.detailsStr);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException ex) {
                        if (!JConsole.isDebug()) break block5;
                        ex.printStackTrace();
                    }
                }
            }

            private String formatDetails() {
                String text = "<table cellspacing=0 cellpadding=0>";
                long time = System.currentTimeMillis();
                String timeStamp = Formatter.formatDateTime(time);
                text = text + Formatter.newRow(Messages.TIME, timeStamp);
                text = text + Formatter.newRow(Messages.CURRENT_CLASSES_LOADED, Formatter.justify(this.clCount, 5));
                text = text + Formatter.newRow(Messages.TOTAL_CLASSES_LOADED, Formatter.justify(this.ctCount, 5));
                text = text + Formatter.newRow(Messages.TOTAL_CLASSES_UNLOADED, Formatter.justify(this.cuCount, 5));
                return text;
            }
        };
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new ClassOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class ClassOverviewPanel
    extends OverviewPanel {
        ClassOverviewPanel() {
            super(Messages.CLASSES, ClassTab.loadedPlotterKey, Messages.LOADED, null);
        }

        private void updateClassInfo(long total, long loaded) {
            long unloaded = total - loaded;
            this.getInfoLabel().setText(Resources.format(Messages.CLASS_TAB_INFO_LABEL_FORMAT, loaded, unloaded, total));
        }
    }
}

