/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.RandomAccessOrds;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public abstract class DocValuesIndexFieldData {
    protected final Index index;
    protected final String fieldName;
    protected final Logger logger;

    public DocValuesIndexFieldData(Index index, String fieldName) {
        this.index = index;
        this.fieldName = fieldName;
        this.logger = Loggers.getLogger(this.getClass());
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public final void clear() {
    }

    public final void clear(IndexReader reader) {
    }

    public final Index index() {
        return this.index;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private static final Set<String> BINARY_INDEX_FIELD_NAMES = Collections.unmodifiableSet(Sets.newHashSet("_uid", "_id"));
        private IndexNumericFieldData.NumericType numericType;
        private Function<RandomAccessOrds, ScriptDocValues<?>> scriptFunction = AbstractAtomicOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION;

        public Builder numericType(IndexNumericFieldData.NumericType type) {
            this.numericType = type;
            return this;
        }

        public Builder scriptFunction(Function<RandomAccessOrds, ScriptDocValues<?>> scriptFunction) {
            this.scriptFunction = scriptFunction;
            return this;
        }

        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            String fieldName = fieldType.name();
            if (BINARY_INDEX_FIELD_NAMES.contains(fieldName)) {
                assert (this.numericType == null);
                return new BinaryDVIndexFieldData(indexSettings.getIndex(), fieldName);
            }
            if (this.numericType != null) {
                return new SortedNumericDVIndexFieldData(indexSettings.getIndex(), fieldName, this.numericType);
            }
            return new SortedSetDVOrdinalsIndexFieldData(indexSettings, cache, fieldName, breakerService, this.scriptFunction);
        }
    }
}

