/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.changeset.query.DateValidator;
import org.openstreetmap.josm.gui.dialogs.changeset.query.RestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.TimeValidator;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.I18n;

public class TimeRestrictionPanel
extends JPanel
implements RestrictionPanel {
    private final JRadioButton rbClosedAfter = new JRadioButton();
    private final JRadioButton rbClosedAfterAndCreatedBefore = new JRadioButton();
    private final JosmTextField tfClosedAfterDate1 = new JosmTextField();
    private transient DateValidator valClosedAfterDate1;
    private final JosmTextField tfClosedAfterTime1 = new JosmTextField();
    private transient TimeValidator valClosedAfterTime1;
    private final JosmTextField tfClosedAfterDate2 = new JosmTextField();
    private transient DateValidator valClosedAfterDate2;
    private final JosmTextField tfClosedAfterTime2 = new JosmTextField();
    private transient TimeValidator valClosedAfterTime2;
    private final JosmTextField tfCreatedBeforeDate = new JosmTextField();
    private transient DateValidator valCreatedBeforeDate;
    private final JosmTextField tfCreatedBeforeTime = new JosmTextField();
    private transient TimeValidator valCreatedBeforeTime;

    public TimeRestrictionPanel() {
        this.build();
    }

    protected JPanel buildClosedAfterInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("Date: ", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.7;
        jPanel.add((Component)this.tfClosedAfterDate1, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate1);
        this.valClosedAfterDate1 = DateValidator.decorate(this.tfClosedAfterDate1);
        this.tfClosedAfterDate1.setToolTipText(this.valClosedAfterDate1.getStandardTooltipTextAsHtml());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.3;
        jPanel.add((Component)this.tfClosedAfterTime1, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime1);
        this.valClosedAfterTime1 = TimeValidator.decorate(this.tfClosedAfterTime1);
        this.tfClosedAfterTime1.setToolTipText(this.valClosedAfterTime1.getStandardTooltipTextAsHtml());
        return jPanel;
    }

    protected JPanel buildClosedAfterAndCreatedBeforeInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("Closed after - ", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.7;
        jPanel.add((Component)this.tfClosedAfterDate2, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate2);
        this.valClosedAfterDate2 = DateValidator.decorate(this.tfClosedAfterDate2);
        this.tfClosedAfterDate2.setToolTipText(this.valClosedAfterDate2.getStandardTooltipTextAsHtml());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.3;
        jPanel.add((Component)this.tfClosedAfterTime2, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime2);
        this.valClosedAfterTime2 = TimeValidator.decorate(this.tfClosedAfterTime2);
        this.tfClosedAfterTime2.setToolTipText(this.valClosedAfterTime2.getStandardTooltipTextAsHtml());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("Created before - ", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.7;
        jPanel.add((Component)this.tfCreatedBeforeDate, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeDate);
        this.valCreatedBeforeDate = DateValidator.decorate(this.tfCreatedBeforeDate);
        this.tfCreatedBeforeDate.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.3;
        jPanel.add((Component)this.tfCreatedBeforeTime, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeTime);
        this.valCreatedBeforeTime = TimeValidator.decorate(this.tfCreatedBeforeTime);
        this.tfCreatedBeforeTime.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
        return jPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbClosedAfter, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after the following date/time", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buildClosedAfterInputPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbClosedAfterAndCreatedBefore, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after and created before a specific date/time", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buildClosedAfterAndCreatedBeforeInputPanel(), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbClosedAfter);
        buttonGroup.add(this.rbClosedAfterAndCreatedBefore);
        TimeRestrictionChangedHandler timeRestrictionChangedHandler = new TimeRestrictionChangedHandler();
        this.rbClosedAfter.addItemListener(timeRestrictionChangedHandler);
        this.rbClosedAfterAndCreatedBefore.addItemListener(timeRestrictionChangedHandler);
        this.rbClosedAfter.setSelected(true);
    }

    @Override
    public boolean isValidChangesetQuery() {
        if (this.rbClosedAfter.isSelected()) {
            return this.valClosedAfterDate1.isValid() && this.valClosedAfterTime1.isValid();
        }
        if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
            return this.valClosedAfterDate2.isValid() && this.valClosedAfterTime2.isValid() && this.valCreatedBeforeDate.isValid() && this.valCreatedBeforeTime.isValid();
        }
        return true;
    }

    public void startUserInput() {
        this.restoreFromSettings();
    }

    @Override
    public void fillInQuery(ChangesetQuery changesetQuery) {
        if (!this.isValidChangesetQuery()) {
            throw new IllegalStateException(I18n.tr("Cannot build changeset query with time based restrictions. Input is not valid.", new Object[0]));
        }
        if (this.rbClosedAfter.isSelected()) {
            LocalDate localDate = this.valClosedAfterDate1.getDate();
            LocalTime localTime = this.valClosedAfterTime1.getTime();
            Date date = new Date(localDate.atTime(localTime).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            changesetQuery.closedAfter(date);
        } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
            LocalDate localDate = this.valClosedAfterDate2.getDate();
            LocalTime localTime = this.valClosedAfterTime2.getTime();
            Date date = new Date(localDate.atTime(localTime).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            localDate = this.valCreatedBeforeDate.getDate();
            localTime = this.valCreatedBeforeTime.getTime();
            Date date2 = new Date(localDate.atTime(localTime).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            changesetQuery.closedAfterAndCreatedBefore(date, date2);
        }
    }

    @Override
    public void displayMessageIfInvalid() {
        if (this.isValidChangesetQuery()) {
            return;
        }
        HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>Please enter valid date/time values to restrict<br>the query to a specific time range.</html>", new Object[0]), I18n.tr("Invalid date/time values", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidDateTimeValues"));
    }

    public void rememberSettings() {
        String string = "changeset-query.advanced.time-restrictions";
        if (this.rbClosedAfter.isSelected()) {
            Main.pref.put(string + ".query-type", "closed-after");
        } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
            Main.pref.put(string + ".query-type", "closed-after-created-before");
        }
        Main.pref.put(string + ".closed-after.date", this.tfClosedAfterDate1.getText());
        Main.pref.put(string + ".closed-after.time", this.tfClosedAfterTime1.getText());
        Main.pref.put(string + ".closed-created.closed.date", this.tfClosedAfterDate2.getText());
        Main.pref.put(string + ".closed-created.closed.time", this.tfClosedAfterTime2.getText());
        Main.pref.put(string + ".closed-created.created.date", this.tfCreatedBeforeDate.getText());
        Main.pref.put(string + ".closed-created.created.time", this.tfCreatedBeforeTime.getText());
    }

    public void restoreFromSettings() {
        String string = "changeset-query.advanced.open-restrictions";
        String string2 = Main.pref.get(string + ".query-type", "closed-after");
        this.rbClosedAfter.setSelected("closed-after".equals(string2));
        this.rbClosedAfterAndCreatedBefore.setSelected("closed-after-created-before".equals(string2));
        if (!this.rbClosedAfter.isSelected() && !this.rbClosedAfterAndCreatedBefore.isSelected()) {
            this.rbClosedAfter.setSelected(true);
        }
        this.tfClosedAfterDate1.setText(Main.pref.get(string + ".closed-after.date", ""));
        this.tfClosedAfterTime1.setText(Main.pref.get(string + ".closed-after.time", ""));
        this.tfClosedAfterDate2.setText(Main.pref.get(string + ".closed-created.closed.date", ""));
        this.tfClosedAfterTime2.setText(Main.pref.get(string + ".closed-created.closed.time", ""));
        this.tfCreatedBeforeDate.setText(Main.pref.get(string + ".closed-created.created.date", ""));
        this.tfCreatedBeforeTime.setText(Main.pref.get(string + ".closed-created.created.time", ""));
        if (!this.valClosedAfterDate1.isValid()) {
            this.tfClosedAfterDate1.setText("");
        }
        if (!this.valClosedAfterTime1.isValid()) {
            this.tfClosedAfterTime1.setText("");
        }
        if (!this.valClosedAfterDate2.isValid()) {
            this.tfClosedAfterDate2.setText("");
        }
        if (!this.valClosedAfterTime2.isValid()) {
            this.tfClosedAfterTime2.setText("");
        }
        if (!this.valCreatedBeforeDate.isValid()) {
            this.tfCreatedBeforeDate.setText("");
        }
        if (!this.valCreatedBeforeTime.isValid()) {
            this.tfCreatedBeforeTime.setText("");
        }
    }

    class TimeRestrictionChangedHandler
    implements ItemListener {
        TimeRestrictionChangedHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            TimeRestrictionPanel.this.tfClosedAfterDate1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
            TimeRestrictionPanel.this.tfClosedAfterTime1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
            TimeRestrictionPanel.this.tfClosedAfterDate2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            TimeRestrictionPanel.this.tfClosedAfterTime2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            TimeRestrictionPanel.this.tfCreatedBeforeDate.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            TimeRestrictionPanel.this.tfCreatedBeforeTime.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
        }
    }
}

