/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.core.queue.LinkedBlockingQueueLocksConditions;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="Queue")
public abstract class QueueNodes {

    @CoreMethod(names={"num_waiting"})
    public static abstract class NumWaitingNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public int num_waiting(DynamicObject self) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            final ReentrantLock lock = queue.getLock();
            this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    lock.lockInterruptibly();
                    return true;
                }
            });
            try {
                int n = lock.getWaitQueueLength(queue.getNotEmptyCondition());
                return n;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @CoreMethod(names={"marshal_dump"})
    public static abstract class MarshalDumpNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object marshal_dump(DynamicObject self) {
            throw new RaiseException(this.coreExceptions().typeErrorCantDump(self, this));
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject clear(DynamicObject self) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            queue.clear();
            return self;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int size(DynamicObject self) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            return queue.size();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean empty(DynamicObject self) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            return queue.isEmpty();
        }
    }

    @CoreMethod(names={"receive_timeout"}, required=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="duration")})
    public static abstract class ReceiveTimeoutNode
    extends CoreMethodNode {
        @Specialization
        public Object receiveTimeout(DynamicObject self, int duration) {
            return this.receiveTimeout(self, (double)duration);
        }

        @Specialization
        public Object receiveTimeout(DynamicObject self, double duration) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            long durationInMillis = (long)(duration * 1000.0);
            long start = System.currentTimeMillis();
            return this.getContext().getThreadManager().runUntilResult(this, () -> {
                long now = System.currentTimeMillis();
                long waited = now - start;
                if (waited >= durationInMillis) {
                    Object result = queue.poll();
                    if (result == null) {
                        return false;
                    }
                    return result;
                }
                Object result = queue.poll(durationInMillis, TimeUnit.MILLISECONDS);
                if (result == null) {
                    return false;
                }
                return result;
            });
        }
    }

    @CoreMethod(names={"pop", "shift", "deq"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="nonBlocking")})
    public static abstract class PopNode
    extends CoreMethodNode {
        @CreateCast(value={"nonBlocking"})
        public RubyNode coerceToBoolean(RubyNode nonBlocking) {
            return BooleanCastWithDefaultNodeGen.create(false, nonBlocking);
        }

        @Specialization(guards={"!nonBlocking"})
        public Object popBlocking(DynamicObject self, boolean nonBlocking) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            return this.doPop(queue);
        }

        @CompilerDirectives.TruffleBoundary
        private Object doPop(BlockingQueue<Object> queue) {
            return this.getContext().getThreadManager().runUntilResult(this, () -> queue.take());
        }

        @Specialization(guards={"nonBlocking"})
        public Object popNonBlock(DynamicObject self, boolean nonBlocking, @Cached(value="create()") BranchProfile errorProfile) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            Object value = this.doPoll(queue);
            if (value == null) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().threadError("queue empty", this));
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private Object doPoll(BlockingQueue<Object> queue) {
            return queue.poll();
        }
    }

    @CoreMethod(names={"push", "<<", "enq"}, required=1)
    public static abstract class PushNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject push(DynamicObject self, Object value) {
            LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(self);
            this.doPush(value, queue);
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        private void doPush(Object value, BlockingQueue<Object> queue) {
            queue.add(value);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, this.getContext().getNativePlatform().createLinkedBlockingQueueLocksConditions());
        }
    }
}

