/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.ResourceBundleTools;
import org.languagetool.databroker.DefaultResourceDataBroker;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.CleanOverlappingFilter;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SameRuleGroupFilter;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleLoader;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.xml.sax.SAXException;

public class JLanguageTool {
    public static final String VERSION = "3.6";
    @Nullable
    public static final String BUILD_DATE = JLanguageTool.getBuildDate();
    public static final String PATTERN_FILE = "grammar.xml";
    public static final String FALSE_FRIEND_FILE = "false-friends.xml";
    public static final String SENTENCE_START_TAGNAME = "SENT_START";
    public static final String SENTENCE_END_TAGNAME = "SENT_END";
    public static final String PARAGRAPH_END_TAGNAME = "PARA_END";
    public static final String MESSAGE_BUNDLE = "org.languagetool.MessagesBundle";
    private static ResourceDataBroker dataBroker = new DefaultResourceDataBroker();
    private final List<Rule> builtinRules;
    private final List<Rule> userRules = new ArrayList<Rule>();
    private final Set<String> disabledRules = new HashSet<String>();
    private final Set<CategoryId> disabledRuleCategories = new HashSet<CategoryId>();
    private final Set<String> enabledRules = new HashSet<String>();
    private final Set<CategoryId> enabledRuleCategories = new HashSet<CategoryId>();
    private final Language language;
    private final Language motherTongue;
    private PrintStream printStream;
    private int sentenceCount;
    private boolean listUnknownWords;
    private Set<String> unknownWords;
    private boolean cleanOverlappingMatches;
    private static final List<File> temporaryFiles = new ArrayList<File>();

    @Nullable
    private static String getBuildDate() {
        try {
            URL res = JLanguageTool.class.getResource(JLanguageTool.class.getSimpleName() + ".class");
            if (res == null) {
                return null;
            }
            URLConnection connObj = res.openConnection();
            if (connObj instanceof JarURLConnection) {
                JarURLConnection conn = (JarURLConnection)connObj;
                Manifest manifest = conn.getManifest();
                return manifest.getMainAttributes().getValue("Implementation-Date");
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get build date from JAR", e);
        }
    }

    public JLanguageTool(Language language) {
        this(language, null);
    }

    public JLanguageTool(Language language, Language motherTongue) {
        this.language = Objects.requireNonNull(language, "language cannot be null");
        this.motherTongue = motherTongue;
        ResourceBundle messages = ResourceBundleTools.getMessageBundle(language);
        this.builtinRules = this.getAllBuiltinRules(language, messages);
        this.cleanOverlappingMatches = true;
        try {
            this.activateDefaultPatternRules();
            this.activateDefaultFalseFriendRules();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not activate rules", e);
        }
    }

    public static synchronized ResourceDataBroker getDataBroker() {
        if (dataBroker == null) {
            dataBroker = new DefaultResourceDataBroker();
        }
        return dataBroker;
    }

    public static synchronized void setDataBroker(ResourceDataBroker broker) {
        dataBroker = broker;
    }

    public void setListUnknownWords(boolean listUnknownWords) {
        this.listUnknownWords = listUnknownWords;
    }

    public void setCleanOverlappingMatches(boolean cleanOverlappingMatches) {
        this.cleanOverlappingMatches = cleanOverlappingMatches;
    }

    public static ResourceBundle getMessageBundle() {
        return ResourceBundleTools.getMessageBundle();
    }

    public static ResourceBundle getMessageBundle(Language lang) {
        return ResourceBundleTools.getMessageBundle(lang);
    }

    private List<Rule> getAllBuiltinRules(Language language, ResourceBundle messages) {
        try {
            return language.getRelevantRules(messages);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get rules of language " + language, e);
        }
    }

    public void setOutput(PrintStream printStream) {
        this.printStream = printStream;
    }

    public List<AbstractPatternRule> loadPatternRules(String filename) throws IOException {
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        try (InputStream is = this.getClass().getResourceAsStream(filename);){
            if (is == null) {
                List<AbstractPatternRule> list = ruleLoader.getRules(new File(filename));
                return list;
            }
            List<AbstractPatternRule> list = ruleLoader.getRules(is, filename);
            return list;
        }
    }

    public List<AbstractPatternRule> loadFalseFriendRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (this.motherTongue == null) {
            return Collections.emptyList();
        }
        FalseFriendRuleLoader ruleLoader = new FalseFriendRuleLoader();
        try (InputStream is = this.getClass().getResourceAsStream(filename);){
            if (is == null) {
                List<AbstractPatternRule> list = ruleLoader.getRules(new File(filename), this.language, this.motherTongue);
                return list;
            }
            List<AbstractPatternRule> list = ruleLoader.getRules(is, this.language, this.motherTongue);
            return list;
        }
    }

    public void activateLanguageModelRules(File indexDir) throws IOException {
        LanguageModel languageModel = this.language.getLanguageModel(indexDir);
        if (languageModel != null) {
            ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
            List<Rule> rules = this.language.getRelevantLanguageModelRules(messages, languageModel);
            this.userRules.addAll(rules);
        }
    }

    private void activateDefaultPatternRules() throws IOException {
        List<AbstractPatternRule> patternRules = this.language.getPatternRules();
        List<String> enabledRules = this.language.getDefaultEnabledRulesForVariant();
        List<String> disabledRules = this.language.getDefaultDisabledRulesForVariant();
        if (!enabledRules.isEmpty() || !disabledRules.isEmpty()) {
            for (AbstractPatternRule patternRule : patternRules) {
                if (enabledRules.contains(patternRule.getId())) {
                    patternRule.setDefaultOn();
                }
                if (!disabledRules.contains(patternRule.getId())) continue;
                patternRule.setDefaultOff();
            }
        }
        this.userRules.addAll(patternRules);
    }

    private void activateDefaultFalseFriendRules() throws ParserConfigurationException, SAXException, IOException {
        String falseFriendRulesFilename = JLanguageTool.getDataBroker().getRulesDir() + "/" + FALSE_FRIEND_FILE;
        this.userRules.addAll(this.loadFalseFriendRules(falseFriendRulesFilename));
    }

    public void addRule(Rule rule) {
        this.userRules.add(rule);
    }

    public void disableRule(String ruleId) {
        this.disabledRules.add(ruleId);
        this.enabledRules.remove(ruleId);
    }

    public void disableRules(List<String> ruleIds) {
        this.disabledRules.addAll(ruleIds);
        this.enabledRules.removeAll(ruleIds);
    }

    public void disableCategory(String categoryName) {
        for (Rule rule : this.getAllRules()) {
            if (!rule.getCategory().getName().equals(categoryName)) continue;
            this.disableCategory(rule.getCategory().getId());
        }
    }

    public void disableCategory(CategoryId id) {
        this.disabledRuleCategories.add(id);
        this.enabledRuleCategories.remove(id);
    }

    public boolean isCategoryDisabled(CategoryId id) {
        return this.disabledRuleCategories.contains(id);
    }

    public Language getLanguage() {
        return this.language;
    }

    public Set<String> getDisabledRules() {
        return this.disabledRules;
    }

    public void enableDefaultOffRule(String ruleId) {
        this.enableRule(ruleId);
    }

    public void enableDefaultOffRuleCategory(CategoryId id) {
        this.enableRuleCategory(id);
    }

    public Set<String> getDisabledCategories() {
        HashSet<String> names = new HashSet<String>();
        for (Rule rule : this.getAllRules()) {
            if (!this.disabledRuleCategories.contains(rule.getCategory().getId())) continue;
            names.add(rule.getCategory().getName());
        }
        return names;
    }

    public void enableRule(String ruleId) {
        this.disabledRules.remove(ruleId);
        this.enabledRules.add(ruleId);
    }

    public void enableRuleCategory(CategoryId id) {
        this.disabledRuleCategories.remove(id);
        this.enabledRuleCategories.add(id);
    }

    public List<String> sentenceTokenize(String text) {
        return this.language.getSentenceTokenizer().tokenize(text);
    }

    public List<RuleMatch> check(String text) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL);
    }

    public List<RuleMatch> check(String text, boolean tokenizeText, ParagraphHandling paraMode) throws IOException {
        return this.check(new AnnotatedTextBuilder().addText(text).build(), tokenizeText, paraMode);
    }

    public List<RuleMatch> check(AnnotatedText text) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode) throws IOException {
        List<Object> sentences;
        if (tokenizeText) {
            sentences = this.sentenceTokenize(annotatedText.getPlainText());
        } else {
            sentences = new ArrayList();
            sentences.add(annotatedText.getPlainText());
        }
        List<Rule> allRules = this.getAllRules();
        if (this.printStream != null) {
            this.printIfVerbose(allRules.size() + " rules activated for language " + this.language);
        }
        for (Rule rule : allRules) {
            rule.reset();
        }
        this.sentenceCount = sentences.size();
        this.unknownWords = new HashSet<String>();
        List<AnalyzedSentence> analyzedSentences = this.analyzeSentences(sentences);
        List<RuleMatch> ruleMatches = this.performCheck(analyzedSentences, sentences, allRules, paraMode, annotatedText);
        ruleMatches = new SameRuleGroupFilter().filter(ruleMatches);
        if (this.cleanOverlappingMatches) {
            ruleMatches = new CleanOverlappingFilter(this.language).filter(ruleMatches);
        }
        return ruleMatches;
    }

    public List<AnalyzedSentence> analyzeText(String text) throws IOException {
        List<String> sentences = this.sentenceTokenize(text);
        return this.analyzeSentences(sentences);
    }

    protected List<AnalyzedSentence> analyzeSentences(List<String> sentences) throws IOException {
        ArrayList<AnalyzedSentence> analyzedSentences = new ArrayList<AnalyzedSentence>();
        int j = 0;
        for (String sentence : sentences) {
            AnalyzedSentence analyzedSentence = this.getAnalyzedSentence(sentence);
            this.rememberUnknownWords(analyzedSentence);
            if (++j == sentences.size()) {
                AnalyzedTokenReadings[] anTokens = analyzedSentence.getTokens();
                anTokens[anTokens.length - 1].setParagraphEnd();
                analyzedSentence = new AnalyzedSentence(anTokens);
            }
            analyzedSentences.add(analyzedSentence);
            this.printSentenceInfo(analyzedSentence);
        }
        return analyzedSentences;
    }

    protected void printSentenceInfo(AnalyzedSentence analyzedSentence) {
        if (this.printStream != null) {
            this.printIfVerbose(analyzedSentence.toString());
            this.printIfVerbose(analyzedSentence.getAnnotations());
        }
    }

    protected List<RuleMatch> performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, ParagraphHandling paraMode, AnnotatedText annotatedText) throws IOException {
        TextCheckCallable matcher = new TextCheckCallable(allRules, sentences, analyzedSentences, paraMode, annotatedText, 0, 0, 1);
        try {
            return (List)matcher.call();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    List<RuleMatch> checkAnalyzedSentence(ParagraphHandling paraMode, List<Rule> allRules, int charCount, int lineCount, int columnCount, String sentence, AnalyzedSentence analyzedSentence) throws IOException {
        return this.checkAnalyzedSentence(paraMode, allRules, charCount, lineCount, columnCount, sentence, analyzedSentence, null);
    }

    public List<RuleMatch> checkAnalyzedSentence(ParagraphHandling paraMode, List<Rule> rules, int charCount, int lineCount, int columnCount, String sentence, AnalyzedSentence analyzedSentence, AnnotatedText annotatedText) throws IOException {
        ArrayList<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
        for (Rule rule : rules) {
            RuleMatch[] thisMatches;
            if (rule instanceof TextLevelRule || this.ignoreRule(rule) || rule instanceof PatternRule && ((PatternRule)rule).canBeIgnoredFor(analyzedSentence) || paraMode == ParagraphHandling.ONLYPARA) continue;
            for (RuleMatch element1 : thisMatches = rule.match(analyzedSentence)) {
                RuleMatch thisMatch = this.adjustRuleMatchPos(element1, charCount, columnCount, lineCount, sentence, annotatedText);
                sentenceMatches.add(thisMatch);
            }
        }
        return new SameRuleGroupFilter().filter(sentenceMatches);
    }

    private boolean ignoreRule(Rule rule) {
        boolean isRuleDisabled;
        Category ruleCategory = rule.getCategory();
        boolean isCategoryDisabled = (this.disabledRuleCategories.contains(ruleCategory.getId()) || rule.getCategory().isDefaultOff()) && !this.enabledRuleCategories.contains(ruleCategory.getId());
        boolean bl = isRuleDisabled = this.disabledRules.contains(rule.getId()) || rule.isDefaultOff() && !this.enabledRules.contains(rule.getId());
        boolean isDisabled = isCategoryDisabled ? !this.enabledRules.contains(rule.getId()) : isRuleDisabled;
        return isDisabled;
    }

    public RuleMatch adjustRuleMatchPos(RuleMatch match, int charCount, int columnCount, int lineCount, String sentence, AnnotatedText annotatedText) {
        int fromPos = match.getFromPos() + charCount;
        int toPos = match.getToPos() + charCount;
        if (annotatedText != null) {
            fromPos = annotatedText.getOriginalTextPositionFor(fromPos);
            toPos = annotatedText.getOriginalTextPositionFor(toPos - 1) + 1;
        }
        RuleMatch thisMatch = new RuleMatch(match.getRule(), fromPos, toPos, match.getMessage(), match.getShortMessage());
        thisMatch.setSuggestedReplacements(match.getSuggestedReplacements());
        String sentencePartToError = sentence.substring(0, match.getFromPos());
        String sentencePartToEndOfError = sentence.substring(0, match.getToPos());
        int lastLineBreakPos = sentencePartToError.lastIndexOf(10);
        int column = lastLineBreakPos == -1 ? sentencePartToError.length() + columnCount : sentencePartToError.length() - lastLineBreakPos;
        int lastLineBreakPosInError = sentencePartToEndOfError.lastIndexOf(10);
        int endColumn = lastLineBreakPosInError == -1 ? sentencePartToEndOfError.length() + columnCount : sentencePartToEndOfError.length() - lastLineBreakPosInError;
        int lineBreaksToError = JLanguageTool.countLineBreaks(sentencePartToError);
        int lineBreaksToEndOfError = JLanguageTool.countLineBreaks(sentencePartToEndOfError);
        thisMatch.setLine(lineCount + lineBreaksToError);
        thisMatch.setEndLine(lineCount + lineBreaksToEndOfError);
        thisMatch.setColumn(column);
        thisMatch.setEndColumn(endColumn);
        return thisMatch;
    }

    protected void rememberUnknownWords(AnalyzedSentence analyzedText) {
        if (this.listUnknownWords) {
            AnalyzedTokenReadings[] atr;
            for (AnalyzedTokenReadings reading : atr = analyzedText.getTokensWithoutWhitespace()) {
                if (reading.isTagged()) continue;
                this.unknownWords.add(reading.getToken());
            }
        }
    }

    public List<String> getUnknownWords() {
        if (!this.listUnknownWords) {
            throw new IllegalStateException("listUnknownWords is set to false, unknown words not stored");
        }
        ArrayList<String> words = new ArrayList<String>(this.unknownWords);
        Collections.sort(words);
        return words;
    }

    static int countLineBreaks(String s) {
        int nextPos;
        int pos = -1;
        int count = 0;
        while ((nextPos = s.indexOf(10, pos + 1)) != -1) {
            pos = nextPos;
            ++count;
        }
        return count;
    }

    public AnalyzedSentence getAnalyzedSentence(String sentence) throws IOException {
        AnalyzedSentence analyzedSentence = this.language.getDisambiguator().disambiguate(this.getRawAnalyzedSentence(sentence));
        if (this.language.getPostDisambiguationChunker() != null) {
            this.language.getPostDisambiguationChunker().addChunkTags(Arrays.asList(analyzedSentence.getTokens()));
        }
        return analyzedSentence;
    }

    public AnalyzedSentence getRawAnalyzedSentence(String sentence) throws IOException {
        AnalyzedToken sentenceStartToken;
        List<String> tokens = this.language.getWordTokenizer().tokenize(sentence);
        Map<Integer, String> softHyphenTokens = this.replaceSoftHyphens(tokens);
        List<AnalyzedTokenReadings> aTokens = this.language.getTagger().tag(tokens);
        if (this.language.getChunker() != null) {
            this.language.getChunker().addChunkTags(aTokens);
        }
        int numTokens = aTokens.size();
        int posFix = 0;
        for (int i = 1; i < numTokens; ++i) {
            aTokens.get(i).setWhitespaceBefore(aTokens.get(i - 1).isWhitespace());
            aTokens.get(i).setStartPos(aTokens.get(i).getStartPos() + posFix);
            if (softHyphenTokens.isEmpty() || softHyphenTokens.get(i) == null) continue;
            aTokens.get(i).addReading(this.language.getTagger().createToken(softHyphenTokens.get(i), null));
            posFix += softHyphenTokens.get(i).length() - aTokens.get(i).getToken().length();
        }
        AnalyzedTokenReadings[] tokenArray = new AnalyzedTokenReadings[tokens.size() + 1];
        AnalyzedToken[] startTokenArray = new AnalyzedToken[1];
        int toArrayCount = 0;
        startTokenArray[0] = sentenceStartToken = new AnalyzedToken("", SENTENCE_START_TAGNAME, null);
        tokenArray[toArrayCount++] = new AnalyzedTokenReadings(startTokenArray, 0);
        int startPos = 0;
        for (AnalyzedTokenReadings posTag : aTokens) {
            posTag.setStartPos(startPos);
            tokenArray[toArrayCount++] = posTag;
            startPos += posTag.getToken().length();
        }
        int lastToken = toArrayCount - 1;
        for (int i = 0; i < toArrayCount - 1; ++i) {
            if (tokenArray[lastToken - i].isWhitespace()) continue;
            lastToken -= i;
            break;
        }
        tokenArray[lastToken].setSentEnd();
        if (tokenArray.length == lastToken + 1 && tokenArray[lastToken].isLinebreak()) {
            tokenArray[lastToken].setParagraphEnd();
        }
        return new AnalyzedSentence(tokenArray);
    }

    private Map<Integer, String> replaceSoftHyphens(List<String> tokens) {
        Pattern ignoredCharacterRegex = this.language.getIgnoredCharactersRegex();
        HashMap<Integer, String> ignoredCharsTokens = new HashMap<Integer, String>();
        if (ignoredCharacterRegex == null) {
            return ignoredCharsTokens;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            if (!ignoredCharacterRegex.matcher(tokens.get(i)).find()) continue;
            ignoredCharsTokens.put(i, tokens.get(i));
            tokens.set(i, ignoredCharacterRegex.matcher(tokens.get(i)).replaceAll(""));
        }
        return ignoredCharsTokens;
    }

    public Map<CategoryId, Category> getCategories() {
        HashMap<CategoryId, Category> map = new HashMap<CategoryId, Category>();
        for (Rule rule : this.getAllRules()) {
            map.put(rule.getCategory().getId(), rule.getCategory());
        }
        return map;
    }

    public List<Rule> getAllRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        return rules;
    }

    public List<Rule> getAllActiveRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        for (Rule rule : rules) {
            if (this.ignoreRule(rule)) continue;
            rulesActive.add(rule);
        }
        return rulesActive;
    }

    public List<AbstractPatternRule> getPatternRulesByIdAndSubId(String Id, String subId) {
        List<Rule> rules = this.getAllRules();
        ArrayList<AbstractPatternRule> rulesById = new ArrayList<AbstractPatternRule>();
        for (Rule rule : rules) {
            if (!(rule instanceof AbstractPatternRule) || !rule.getId().equals(Id) || !((AbstractPatternRule)rule).getSubId().equals(subId)) continue;
            rulesById.add((AbstractPatternRule)rule);
        }
        return rulesById;
    }

    public int getSentenceCount() {
        return this.sentenceCount;
    }

    protected void printIfVerbose(String s) {
        if (this.printStream != null) {
            this.printStream.println(s);
        }
    }

    public static void addTemporaryFile(File file) {
        temporaryFiles.add(file);
    }

    public static void removeTemporaryFiles() {
        for (File file : temporaryFiles) {
            file.delete();
        }
    }

    class TextCheckCallable
    implements Callable<List<RuleMatch>> {
        private final List<Rule> rules;
        private final ParagraphHandling paraMode;
        private final AnnotatedText annotatedText;
        private final List<String> sentences;
        private final List<AnalyzedSentence> analyzedSentences;
        private int charCount;
        private int lineCount;
        private int columnCount;

        TextCheckCallable(List<Rule> rules, List<String> sentences, List<AnalyzedSentence> analyzedSentences, ParagraphHandling paraMode, AnnotatedText annotatedText, int charCount, int lineCount, int columnCount) {
            this.rules = rules;
            if (sentences.size() != analyzedSentences.size()) {
                throw new IllegalArgumentException("sentences and analyzedSentences do not have the same length : " + sentences.size() + " != " + analyzedSentences.size());
            }
            this.sentences = sentences;
            this.analyzedSentences = analyzedSentences;
            this.paraMode = paraMode;
            this.annotatedText = annotatedText;
            this.charCount = charCount;
            this.lineCount = lineCount;
            this.columnCount = columnCount;
        }

        @Override
        public List<RuleMatch> call() throws Exception {
            ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
            int i = 0;
            for (Rule rule : this.rules) {
                RuleMatch[] matches;
                if (!(rule instanceof TextLevelRule) || JLanguageTool.this.ignoreRule(rule) || this.paraMode == ParagraphHandling.ONLYNONPARA) continue;
                for (RuleMatch match : matches = ((TextLevelRule)rule).match(this.analyzedSentences)) {
                    LineColumnRange range = this.getLineColumnRange(match);
                    match.setColumn(range.from.column);
                    match.setEndColumn(range.to.column);
                    match.setLine(range.from.line);
                    match.setEndLine(range.to.line);
                }
                ruleMatches.addAll(Arrays.asList(matches));
            }
            for (AnalyzedSentence analyzedSentence : this.analyzedSentences) {
                String sentence = this.sentences.get(i++);
                try {
                    List<RuleMatch> sentenceMatches = JLanguageTool.this.checkAnalyzedSentence(this.paraMode, this.rules, this.charCount, this.lineCount, this.columnCount, sentence, analyzedSentence, this.annotatedText);
                    ruleMatches.addAll(sentenceMatches);
                    this.charCount += sentence.length();
                    this.lineCount += JLanguageTool.countLineBreaks(sentence);
                    int lineBreakPos = sentence.lastIndexOf(10);
                    if (lineBreakPos == -1) {
                        this.columnCount += sentence.length();
                        continue;
                    }
                    if (lineBreakPos == 0) {
                        this.columnCount = sentence.length();
                        if (JLanguageTool.this.language.getSentenceTokenizer().singleLineBreaksMarksPara()) continue;
                        --this.columnCount;
                        continue;
                    }
                    this.columnCount = sentence.length() - lineBreakPos;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not check sentence (language: " + JLanguageTool.this.language + "): '" + StringUtils.abbreviate((String)analyzedSentence.toTextString(), (int)200) + "'", e);
                }
            }
            return ruleMatches;
        }

        private LineColumnRange getLineColumnRange(RuleMatch match) {
            LineColumnPosition fromPos = new LineColumnPosition(-1, -1);
            LineColumnPosition toPos = new LineColumnPosition(-1, -1);
            LineColumnPosition pos = new LineColumnPosition(0, 0);
            int charCount = 0;
            for (AnalyzedSentence analyzedSentence : this.analyzedSentences) {
                for (AnalyzedTokenReadings readings : analyzedSentence.getTokens()) {
                    String token = readings.getToken();
                    if ("\n".equals(token)) {
                        ++pos.line;
                        pos.column = 0;
                    }
                    pos.column += token.length();
                    if ((charCount += token.length()) == match.getFromPos()) {
                        fromPos = new LineColumnPosition(pos.line, pos.column);
                    }
                    if (charCount != match.getToPos()) continue;
                    toPos = new LineColumnPosition(pos.line, pos.column);
                }
            }
            return new LineColumnRange(fromPos, toPos);
        }

        private class LineColumnRange {
            LineColumnPosition from;
            LineColumnPosition to;

            private LineColumnRange(LineColumnPosition from, LineColumnPosition to) {
                this.from = from;
                this.to = to;
            }
        }

        private class LineColumnPosition {
            int line;
            int column;

            private LineColumnPosition(int line, int column) {
                this.line = line;
                this.column = column;
            }
        }
    }

    public static enum ParagraphHandling {
        NORMAL,
        ONLYPARA,
        ONLYNONPARA;

    }
}

