/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public class RecoveryWaitForClusterStateRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private long clusterStateVersion;

    public RecoveryWaitForClusterStateRequest() {
    }

    RecoveryWaitForClusterStateRequest(long recoveryId, ShardId shardId, long clusterStateVersion) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.clusterStateVersion = clusterStateVersion;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public long clusterStateVersion() {
        return this.clusterStateVersion;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.clusterStateVersion = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVLong(this.clusterStateVersion);
    }
}

