/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestUtils;

public abstract class RestRequest
implements ToXContent.Params {
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, String> params;
    private final String rawPath;
    private final Set<String> consumedParams = new HashSet<String>();

    public RestRequest(NamedXContentRegistry xContentRegistry, String uri) {
        this.xContentRegistry = xContentRegistry;
        HashMap<String, String> params = new HashMap<String, String>();
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            this.rawPath = uri;
        } else {
            this.rawPath = uri.substring(0, pathEndPos);
            RestUtils.decodeQueryString(uri, pathEndPos + 1, params);
        }
        this.params = params;
    }

    public RestRequest(NamedXContentRegistry xContentRegistry, Map<String, String> params, String path) {
        this.xContentRegistry = xContentRegistry;
        this.params = params;
        this.rawPath = path;
    }

    public abstract Method method();

    public abstract String uri();

    public String rawPath() {
        return this.rawPath;
    }

    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    public abstract boolean hasContent();

    public abstract BytesReference content();

    public abstract String header(String var1);

    public abstract Iterable<Map.Entry<String, String>> headers();

    @Nullable
    public SocketAddress getRemoteAddress() {
        return null;
    }

    @Nullable
    public SocketAddress getLocalAddress() {
        return null;
    }

    public final boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    @Override
    public final String param(String key) {
        this.consumedParams.add(key);
        return this.params.get(key);
    }

    @Override
    public final String param(String key, String defaultValue) {
        this.consumedParams.add(key);
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> params() {
        return this.params;
    }

    List<String> consumedParams() {
        return this.consumedParams.stream().collect(Collectors.toList());
    }

    List<String> unconsumedParams() {
        return this.params.keySet().stream().filter(p -> !this.consumedParams.contains(p)).collect(Collectors.toList());
    }

    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse long parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        return Booleans.parseBoolean(this.param(key), defaultValue);
    }

    @Override
    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        return Booleans.parseBoolean(this.param(key), defaultValue);
    }

    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.param(key), defaultValue, key);
    }

    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue(this.param(key), defaultValue, key);
    }

    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return Strings.splitStringByCommaToArray(value);
    }

    public String[] paramAsStringArrayOrEmptyIfAll(String key) {
        String[] params = this.paramAsStringArray(key, Strings.EMPTY_ARRAY);
        if (Strings.isAllOrWildcard(params)) {
            return Strings.EMPTY_ARRAY;
        }
        return params;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public final XContentParser contentParser() throws IOException {
        BytesReference content = this.content();
        if (content.length() == 0) {
            throw new ElasticsearchParseException("Body required", new Object[0]);
        }
        return XContentFactory.xContent(content).createParser(this.xContentRegistry, content);
    }

    public final void applyContentParser(CheckedConsumer<XContentParser, IOException> applyParser) throws IOException {
        if (this.hasContent()) {
            try (XContentParser parser = this.contentParser();){
                applyParser.accept(parser);
            }
        }
    }

    public final boolean hasContentOrSourceParam() {
        return this.hasContent() || this.hasParam("source");
    }

    public final XContentParser contentOrSourceParamParser() throws IOException {
        BytesReference content = this.contentOrSourceParam();
        if (content.length() == 0) {
            throw new ElasticsearchParseException("Body required", new Object[0]);
        }
        return XContentFactory.xContent(content).createParser(this.xContentRegistry, content);
    }

    public final void withContentOrSourceParamParserOrNull(CheckedConsumer<XContentParser, IOException> withParser) throws IOException {
        BytesReference content = this.contentOrSourceParam();
        if (content.length() > 0) {
            try (XContentParser parser = XContentFactory.xContent(content).createParser(this.xContentRegistry, content);){
                withParser.accept(parser);
            }
        } else {
            withParser.accept(null);
        }
    }

    public final BytesReference contentOrSourceParam() {
        if (this.hasContent()) {
            return this.content();
        }
        String source = this.param("source");
        if (source != null) {
            return new BytesArray(source);
        }
        return BytesArray.EMPTY;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD;

    }
}

