/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.profile.query.QueryTimingType;

public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private final IndexSearcher in;
    private AggregatedDfs aggregatedDfs;
    private final Engine.Searcher engineSearcher;
    private QueryProfiler profiler;

    public ContextIndexSearcher(Engine.Searcher searcher, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy) {
        super(searcher.reader());
        this.in = searcher.searcher();
        this.engineSearcher = searcher;
        this.setSimilarity(searcher.searcher().getSimilarity(true));
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
    }

    @Override
    public void close() {
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public Query rewrite(Query original) throws IOException {
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = this.in.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    public Weight createNormalizedWeight(Query query, boolean needsScores) throws IOException {
        if (this.aggregatedDfs != null && needsScores) {
            return super.createNormalizedWeight(query, needsScores);
        }
        if (this.profiler != null) {
            return super.createNormalizedWeight(query, needsScores);
        }
        return this.in.createNormalizedWeight(query, needsScores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, boolean needsScores) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            QueryProfileBreakdown profile = (QueryProfileBreakdown)this.profiler.getQueryBreakdown(query);
            profile.startTime(QueryTimingType.CREATE_WEIGHT);
            try {
                weight = super.createWeight(query, needsScores);
            }
            finally {
                profile.stopAndRecordTime();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, needsScores);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        if (this.aggregatedDfs != null) {
            return super.explain(this.createNormalizedWeight(query, true), doc);
        }
        return this.in.explain(query, doc);
    }

    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, context);
        }
        TermStatistics termStatistics = (TermStatistics)this.aggregatedDfs.termStatistics().get((Object)term);
        if (termStatistics == null) {
            return super.termStatistics(term, context);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = (CollectionStatistics)this.aggregatedDfs.fieldStatistics().get((Object)field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public DirectoryReader getDirectoryReader() {
        return this.engineSearcher.getDirectoryReader();
    }
}

